#include "stdafx.h"
#include "NaviMeshNode.h"

#include "NaviMesh.h"
#include "RenderSystem.h"

bool cNaviMeshBranchNode::Load( cFileLoader& loader )
{
	///  ڸ ε
	if( loader.Read( &mBoundBox, sizeof(cBox) ) != sizeof(cBox) )
		return false;

	mCenter = (mBoundBox.GetMin() + mBoundBox.GetMax()) * 0.5f;
	mRadius = (mBoundBox.GetMax() - mBoundBox.GetMin()).Length() * 0.5f;

	/// ڽ  ε
	if( mChild[0]->Load( loader ) == false )
		return false;
	if( mChild[1]->Load( loader ) == false )
		return false;
	if( mChild[2]->Load( loader ) == false )
		return false;
	if( mChild[3]->Load( loader ) == false )
		return false;
	return true;
}

bool cNaviMeshLeafNode::Load( cFileLoader& loader )
{
	///  ڸ ε
	if( loader.Read( &mBoundBox, sizeof(cBox) ) != sizeof(cBox) )
		return false;

	mCenter = (mBoundBox.GetMin() + mBoundBox.GetMax()) * 0.5f;
	mRadius = (mBoundBox.GetMax() - mBoundBox.GetMin()).Length() * 0.5f;

	///  ε
	switch( mVersion )
	{
	case 2:
		{
			///  迭 ε
			float h;
			for( unsigned int yi = mYIndex, yend = mYIndex + mLineCount; yi < yend; ++yi )
			{
				for( unsigned int xi = mXIndex, xend = mXIndex + mLineCount; xi < xend; ++xi )
				{
					loader.ReadFloat( &h );
					NAVIMESH->SetHeight( xi, yi, h );
				}
			}

			/// ۸ 
			mBuffer->UpdatePosCoord( NAVIMESH, mXIndex, mYIndex, mLineCount );
			break;
		}
	case 3:
		{
			break;
		}
	}
	return true;
}
