#include "stdafx.h"
#include "NaviMesh.h"

#include "RenderSystem.h"
#include "NaviMeshNode.h"

static const char* gNaviMeshFileCode = "IrisNaviMesh";

int cNaviMesh::Load( const cString& pathName )
{
	Clear();

	///  
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		return NAVIMESH_LOAD_ERROR_OPEN;
	}

	///   ε
	cNaviMeshFileHeader header;

	if( loader.Read( &header, sizeof(cNaviMeshFileHeader) ) != sizeof(cNaviMeshFileHeader) )
	{
		return NAVIMESH_LOAD_ERROR_FILE_HEADER;
	}

	if( ::memcmp( header.mCode, gNaviMeshFileCode, 13 ) != 0 )
	{
		return NAVIMESH_LOAD_ERROR_FILE_TYPE;
	}

	switch( header.mVersion )
	{
	case 2:
		--header.mCellCount;
		break;
	case 3:
		break;
	default:
		return NAVIMESH_LOAD_ERROR_FILE_VERSION;
	}

	///  
	cNaviMeshLeafNode::mVersion = header.mVersion;

	/// ׸ ũ⸦ ˻
	if( CheckCellCount( header.mCellCount ) == false )
	{
		return NAVIMESH_LOAD_ERROR_GRID_SIZE;
	}

	///  
	mCellCount = header.mCellCount;
	mLineCount = mCellCount + 1;
	mMetersPerVertex = header.mMetersPerVertex;
	mUnitsPerMeter = header.mUnitsPerMeter;
	mUnitsPerVertex = mMetersPerVertex * (float)mUnitsPerMeter;
	mUnitsPerLeafNode = cNaviMeshLeafNode::mCellCount * mUnitsPerVertex;

	/// ̸ ε
	unsigned int numVerts = mLineCount * mLineCount;
	mHeights = new float[numVerts];

	switch( header.mVersion )
	{
	case 2:
		break;
	case 3:
		loader.Read( mHeights, sizeof(float) * numVerts );
		break;
	}

	///    ʱȭ
	unsigned int buffCount = mCellCount / NAVIMESH_BUFF_CELL_COUNT;
	mBuffer = new cNaviMeshBuffer*[buffCount];

	for( unsigned int yi = 0; yi < buffCount; ++yi )
	{
		mBuffer[yi] = new cNaviMeshBuffer[buffCount];
	}

	for( unsigned int yi = 0; yi < buffCount; ++yi )
	{
		for( unsigned int xi = 0; xi < buffCount; ++xi )
		{
			mBuffer[yi][xi].Init( this, xi * NAVIMESH_BUFF_CELL_COUNT, yi * NAVIMESH_BUFF_CELL_COUNT );
		}
	}

	///   迭 
	unsigned int leafCount = mCellCount / NAVIMESH_LEAF_CELL_COUNT;
	unsigned int numNodes = leafCount * leafCount;
	mNodeArray.Resize( numNodes );

	///   迭 뷮 
	mVisibleArray.Reserve( numNodes );

	/// Ʈ    ε
	mRootNode = new cNaviMeshBranchNode( 0, 0, 0, mCellCount );

	if( mRootNode->Load( loader ) == false )
	{
		return NAVIMESH_LOAD_ERROR_NODE;
	}

	mRootNode->SyncHeight();

	/// ̴ ʱȭ
	cRenderer* renderer = RENDERSYS->GetRenderer();
	mShader.Init( renderer->GetNaviMeshEffect() );

	///   
	LPDIRECT3DDEVICE9 device = renderer->GetD3DDevice();

	D3DVERTEXELEMENT9 decl[] = 
	{
		{ 0, 0, D3DDECLTYPE_FLOAT3, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_POSITION, 0 },
		D3DDECL_END()
	};

	device->CreateVertexDeclaration( decl, &mVertexDeclaration );

	/// ε ۸ 
	unsigned int indexCount = NAVIMESH_LEAF_LINE_COUNT_X2;
	unsigned short indexArray[NAVIMESH_LEAF_LINE_COUNT_X2];
	unsigned short* p = indexArray;

	for( unsigned int xi = 0, xend = NAVIMESH_LEAF_LINE_COUNT; xi < xend; ++xi )
	{
		*p = (unsigned short)(xi); ++p;
		*p = (unsigned short)(xi + NAVIMESH_BUFF_LINE_COUNT); ++p;
	}

	mIndexBuffer = renderer->CreateIndexBuffer( indexCount, indexArray );
	assert( mIndexBuffer );

	///
	mInited = true;
	mModified = false;
	return 1;
}
