#include "stdafx.h"
#include "NaviMesh.h"

#include "NaviMeshNode.h"

static const char* gNaviMeshFileCode = "IrisNaviMesh";
static const int gNaviMeshFileVersion = 3;

bool cNaviMesh::Save( const cString& pathName )
{
	///  
	cFileSaver saver;

	if( FileExist( pathName ) )
	{
		cString newPathName = pathName;
		newPathName += ".bak";
		FileRemove( newPathName );
		FileRename( pathName, newPathName );
	}
	if( saver.Open( pathName ) == false )
	{
		assert( 0 && "failed to open file to save navimesh" );
		return false;
	}

	///   
	cNaviMeshFileHeader header;
	::memcpy( header.mCode, gNaviMeshFileCode, 13 );
	header.mVersion = gNaviMeshFileVersion;
	header.mCellCount = mCellCount;
	header.mMetersPerVertex = mMetersPerVertex;
	header.mUnitsPerMeter = mUnitsPerMeter;

	if( saver.Write( &header, sizeof(cNaviMeshFileHeader) ) != sizeof(cNaviMeshFileHeader) )
	{
		assert( 0 && "failed to save navimesh file header" );
		return false;
	}

	/// ̸ 
	unsigned int numVerts = mLineCount * mLineCount;
	saver.Write( mHeights, sizeof(float) * numVerts );

	///   
	if( mRootNode->Save( saver ) == false )
	{
		assert( 0 && "failed to save navimesh nodes" );
		return false;
	}

	/// ~
	mModified = false;
	return true;
}
