#include "StdAfx.h"
#include "PlayerSceneNode.h"

#include "ResourceManager.h"

//#include "ObjectNameCard.h"
#include "SceneManager.h"
#include "CameraManager.h"
#include "RenderSystem.h"

//#include "ChatBubble.h"

cPlayerSceneNode::cPlayerSceneNode( eSceneNodeType type )
: cDynamicSceneNode( type )
{
	//mpTarotBubble = 0;
}

cPlayerSceneNode::~cPlayerSceneNode()
{
	//SAFE_DELETE(mpTarotBubble);
}

bool cPlayerSceneNode::Init( const cPlayerSceneNodeParam& param )
{
	if( cDynamicSceneNode::Init( param ) == false )
	{
		return false;
	}

	mHead = GetPartObject( eLINK_HEAD );
	if( !mHead )
		assert(0);

	/// ǳ ü 
	//mpChatBubble = new cChatBubble;
	//mpTarotBubble = new cChatBubble;

	return true;
}

bool cPlayerSceneNode::InitLinkInfo()
{
	// ̺κ  ޸ Ҵ Ѵ. (߿  Ȯϰ Ͽ ߰ϰų ϰ..)
	// 뷫  :   2 +  1
	mLinkInfo = NiNew NiTPrimitiveArray<sLinkInfo*>(15, 5);
	assert(mLinkInfo);
	if( mLinkInfo == 0 ) 
	{
		return false;
	}

	for( unsigned int i=0; i<mLinkInfo->GetAllocatedSize(); ++i )
	{
		mLinkInfo->SetAt( i,0 );
	}

	return true;
}

/* ------------------------------------------------------------------
* Լ̸ :	InitPartsName()
*      :	׷  ü ̸ Ѵ.
* ǻ :	Ŀ Ϸ °͵ Ѵ.
* ------------------------------------------------------------------ */
bool cPlayerSceneNode::InitPartsName()
{
	mPartsNameMap.SetAt( ePART_HAIR,	"hair" );
	mPartsNameMap.SetAt( ePART_FACE,	"face" );
	mPartsNameMap.SetAt( ePART_BODY1,	"body1" );
	mPartsNameMap.SetAt( ePART_BODY2,	"body2" );
	mPartsNameMap.SetAt( ePART_HAND,	"hand" );
	mPartsNameMap.SetAt( ePART_FOOT,	"foot" );

	mPartsNameMap.SetAt( eLINK_HEAD,	"head_dummy" );
	mPartsNameMap.SetAt( eLINK_BODY,	"body_dummy" );
	mPartsNameMap.SetAt( eLINK_RHAND,	"Rhand_dummy" );
	mPartsNameMap.SetAt( eLINK_LHAND,	"Lhand_dummy" );
	mPartsNameMap.SetAt( eLINK_FOOT,	"foot_dummy" );
	mPartsNameMap.SetAt( eLINK_LARM,	"Larm_dummy" );

	mPartsNameMap.SetAt( eLINK_RWEAPON,	"weapon_dummy" );
	mPartsNameMap.SetAt( eLINK_LWEAPON,	"WeaponL_dummy" );

	return true;
}

/* ------------------------------------------------------------------
* Լ̸ :	InitializeRandomIdle()
*      :	 پ缺 ϱ ؼ
* ǻ :	
* ------------------------------------------------------------------ */
void cPlayerSceneNode::InitializeRandomIdle()
{
	mRandomIdle = NiNew NiTPrimitiveArray<cActorManagerForPartition::EventCode>(1);

	mRandomIdle->SetAt( 0, 0 );
	//	m_pkRandomIdle->SetAt(1, 2);
	//	m_pkRandomIdle->SetAt(1, 3);
}

void cPlayerSceneNode::Process( float deltaTime, float accumTime )
{
	cDynamicSceneNode::Process( deltaTime, accumTime );

	//if( mpTarotBubble )
	//{
	//	if( mHead == 0 )
	//	{
	//		assert( 0 );
	//		return;
	//	}

	//	NiPoint3 headPos = mHead->GetWorldTranslate();
	//	headPos.z += mHeadDist;

	//	mpTarotBubble->Update( headPos, time );
	//}
}


const NiPoint3& cPlayerSceneNode::GetObjectCenter()
{
	NiAVObject* spine = GetPartObject( eLINK_BODY );

	if( spine )	
		return spine->GetWorldTranslate();
	else
		return NiPoint3::ZERO;
}

/* ------------------------------------------------------------------
* Լ̸ :	ChangeParts( unsigned int index, const cString& pathName )
*      :	Ʈ ü ̽ 
* ǻ :	
* ------------------------------------------------------------------ */
//bool cPlayerSceneNode::ChangeParts( unsigned int partIdx, const char* fileName )
//{
//	if( fileName == 0 )
//		return false;
//
//	///
//	RESOURCEMAN->LoadNIFFile( fileName, cResourceManager::eCHARACTEREFFECT );
//
//	///
//	NiNode* pNode = RESOURCEMAN->CloneObjectByName( fileName );
//	assert(pNode);
//	if( !pNode ) 
//	{
//		return false;
//	}
//
//	return cDynamicSceneNode::ChangeParts( partIdx, pNode );
//}
//
//bool cPlayerSceneNode::ChangePartsTexture( unsigned int partsIdx, const char* fileName )
//{
//	if( partsIdx != ePART_HAIR )
//		return true;
//
//	NiTexture* pTexture = RESOURCEMAN->LoadTexture( fileName );
//	if( pTexture == 0 )
//	{
//		assert(0);
//		return false;
//	}
//
//	return cDynamicSceneNode::ChangePartsTexture( ePART_HAIR, pTexture );
//}


/* ------------------------------------------------------------------
* Լ̸ :	LinkToDummy( unsigned int index, const cString& pathName )
*      :	ü ũ ̽
* ǻ :	
* ------------------------------------------------------------------ */
//unsigned int cPlayerSceneNode::LinkObject( unsigned int dummyIdx, const char* fileName )
//{
//	if( fileName == 0 )
//		return false;
//
//	///
//	RESOURCEMAN->LoadNIFFile( fileName, cResourceManager::eCHARACTEREFFECT );
//
//	///
//	NiNode* pNode = RESOURCEMAN->GetObjectByName( fileName );
//	if( !pNode ) 
//	{
//		assert(0);
//		return UINT_MAX;
//	}
//
//	return cDynamicSceneNode::LinkObject( dummyIdx, pNode );
//}
//
//NiAVObject*	 cPlayerSceneNode::GetPartWeapon( unsigned int objectIdx, bool left )
//{
//	NiAVObject* pObj = GetLinkObject( objectIdx );
//	if( pObj == 0 )
//		return 0;
//
//	unsigned int partIdx = (left == true)? eLINK_LWEAPON:eLINK_RWEAPON;
//	const char* partsName = NULL;
//	if( mPartsNameMap.GetAt( partIdx, partsName ) == false )
//	{
//		return NULL;
//	}
//	return pObj->GetObjectByName( partsName );
//}
//
//cObjectNameCard* cPlayerSceneNode::CreateNameCard( cBaseObject* pObj )
//{
//	if( !pObj )
//	{
//		assert(0);
//		return 0;
//	}
//	return new cPlayerNameCard( pObj );
//}
//
//void cPlayerSceneNode::AddDepthPlaneObject() const
//{
//	if( mpTarotBubble && mpTarotBubble->IsActive() )
//	{
//		/// ǳ 
//		SCENEMAN->AddPlane( mpTarotBubble );
//		return;
//	}
//
//	cDynamicSceneNode::AddDepthPlaneObject();
//
//	/// Ÿ ̸  ɼ üũ
//	/// Ƽ θ üũѴ.
//	/// Ƽ? type2 : (̸0? type1 : 0);
//
//	if( mpNameCard )
//		mpNameCard->SetCardType( eNameCard_Type_Extra );
//}
//
//void cPlayerSceneNode::ActiveTarotBubble( LPTSTR msg, unsigned long color )
//{
//	if( mpTarotBubble )
//		mpTarotBubble->Active( msg, color, true );
//}
//
//void cPlayerSceneNode::DeActiveTarotBubble()
//{
//	if( mpTarotBubble )
//		mpTarotBubble->DeActive();
//}

//////////////////////////////////////////////////////////////////////////
/// Hero SceneNode

//
//cHeroSceneNode::cHeroSceneNode( eType type )
//: cPlayerSceneNode( type )
//{
//}
//
//cHeroSceneNode::~cHeroSceneNode()
//{
//}
//
//void cHeroSceneNode::AddDepthPlaneObject() const
//{
//	if( mpTarotBubble && mpTarotBubble->IsActive() )
//	{
//		/// ǳ 
//		SCENEMAN->AddPlane( mpTarotBubble );
//		return;
//	}
//
//	cDynamicSceneNode::AddDepthPlaneObject();
//
//	/// ̸  ɼ üũ
//	/// ɼ type2 : type1
//	if( mpNameCard )
//		mpNameCard->SetCardType( eNameCard_Type_Extra );
//}