/* ==========================================================================
*    : ̼
*    : 2006.12.16
*      : ڿ 
* ǻ : 
1. ׻  ޸  ϵ ۼѴ.
2. ڿ  ޸  ׻ ڿ RefCount üũѴ.
3. NiNode Ѱ NIFϿ Ѵ.  Child ؼ ϴ   Ѵ.
*===========================================================================*/
#pragma once

#include "ModelInstance.h"
#include "TexturePalette.h"

NiSmartPointer(cTexturePalette);

/// ڿ 
class cResourceManager
{
	static cResourceManager* mSingleton;

public:
	cResourceManager();
	//cResourceManager( LPDIRECT3DDEVICE9 device );
	~cResourceManager();

	/// 
	void Clear();

	/// NIF 
	bool LoadNIF( const cString& pathName );

	/// KFM 
	bool LoadKFM( const cString& pathName );

	///  ؽó 
	NiTexture* LoadNiTexture( const cString& pathName, bool useMipMap = true );
	void RemoveTexture( NiTexture* tex );
	//bool LoadTexture( const cString& pathName, LPDIRECT3DTEXTURE9* texture );
	//void RemoveTexture( LPDIRECT3DTEXTURE9 tex );

	/// ؽó
	LPDIRECT3DTEXTURE9 LoadD3DTexture( const cString& pathName );

	///  带 
	bool RemoveNiNode( const char* name );
	bool RemoveNiNode( NiNode* node );

	///   带 
	void RemoveAllNiNodes();

	///    
	unsigned int GetNumNiNodes() const;

	///  带 
	NiNode* GetNiNode( unsigned int index ) const;
	NiNode* GetNiNode( const cString& fileName ) const;

	///  带 
	NiNode* CloneNiNode( unsigned int index );
	NiNode* CloneNiNode( const cString& pathName );

	// KFM   Լ
	unsigned int AddModel( cModelInstance* model, const cString& name );
	void RemoveAllModels();

	unsigned int GetNumModels() const;
	cModelInstance* GetModel( unsigned int index ) const;
	cModelInstance* GetModel( const cString& name );

	/// ׸ ؽó
	NiTexture* GetShadowTexture() const;

protected:
	///  带 ߰
	unsigned int AddNiNode( NiNode* node );

public:
	/// ü 
	static cResourceManager* GetSingleton();

protected:
	///  丮
	cString mBaseDir;

	///  ؽó ȷƮ
	cTexturePalettePtr mNiTexturePalette;

	/// ؽó 
	typedef tHashMap<cString, NiTexturePtr> cNiTextureMap;
	cNiTextureMap mNiTextureMap;

	/// ׸ ؽó
	NiTexture* mShadowTexture;

	///   迭
	NiTObjectArray<NiNodePtr> mNiNodeArray;

	///   ε 
	typedef tHashMap<cString, unsigned int> cNiNodeIndexMap;
	cNiNodeIndexMap mNiNodeIndexMap;

	// ִϸ̼ ϴ KFM  Ŭ ..
	NiTObjectArray<cModelInstancePtr> mModelArray;
	NiTStringPointerMap<unsigned int> mModelIndexMap;
};

inline
unsigned int cResourceManager::GetNumNiNodes() const
{
	return mNiNodeArray.GetSize();
}

inline
unsigned int cResourceManager::GetNumModels() const
{
	return mModelArray.GetSize();
}

inline
NiTexture* cResourceManager::GetShadowTexture() const
{
	return mShadowTexture;
}

inline
cResourceManager* cResourceManager::GetSingleton()
{
	return mSingleton;
}

#define RESOURCEMAN	cResourceManager::GetSingleton()
