/* ==========================================================================
*    : ̼
*    : 2006.12.15
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

#include "SceneTree.h"
#include "VisibleArray.h"
#include "VisibleArraySorter.h"

class cRay;
class cCamera;
class cTerrain;
class cAreaGroup;
class cAreaSceneNode;
class cAreaSceneNodeParam;
class cLightSceneNode;
class cLightSceneNodeParam;
#ifdef MAP_EDITOR
class cSoundSceneNode;
#endif
class cSoundSceneNodeParam;
class cStaticSceneNode;
class cStaticSceneNodeParam;
class cDynamicSceneNode;
class cNpcSceneNode;
class cNpcSceneNodeParam;
class cMonsterSceneNode;
class cMonsterSceneNodeParam;
class cPortalSceneNode;
class cPortalSceneNodeParam;
class cGatheringSceneNode;
class cGatheringSceneNodeParam;
class cShadowGeometry;


///   
#pragma pack( push, 1 )
class cSceneFileHeader
{
public:
	/// ĺ ڵ
	char mCode[10];

	/// 
	unsigned int mVersion;

	///  Ʈ 
	NiPoint3 mCenter;
	float mMinRadius;
	float mMaxRadius;

	///   
	unsigned int mNumSceneNodes;
};

class cSoundSceneFileHeader
{
public:
	/// ĺ ڵ
	char mCode[10];

	/// 
	unsigned int mVersion;

	///   
	unsigned int mNumSceneNodes;
};
#pragma pack( pop )

///  ÷
class cSceneCuller : public NiCullingProcess
{
public:
	cSceneCuller( const cCamera* cam, const NiPoint3& heroPos, bool testing );

#ifdef MAP_EDITOR
	///  
	unsigned int GetVisibleLevel( const NiPoint3& pos );
#endif

public:
	const cCamera* mCamera;
	NiPoint3 mHeroPos;
	bool mPlaying;

#ifdef MAP_EDITOR
	float mSqaredLevelDistance0;
	float mSqaredLevelDistance1;
	float mSqaredLevelDistance2;
#endif
};

///  
///  带 , ϴ ̴.
///  ϰ,
/// 浹 ˻, ü ˻,   ۾ Ѵ.
class cSceneManager
{
	static cSceneManager* mSingleton;
	friend class cObjectEditor;
	friend class cLightEditor;

public:
	cSceneManager();
	~cSceneManager();

	/// 
	void Clear();

	/// ʱȭ
	bool Init( const cTerrain& terrain, float minRadius = 1000 );
	bool Init( const NiPoint3& center, float minRadius, float maxRadius );
	bool InitTree( const cTerrain& terrain, float minRadius = 1000 );
	bool InitTree( const NiPoint3& center, float minRadius, float maxRadius );
	bool IsInited() const;

	/// ε
#ifdef MAP_EDITOR
	bool Load( const cString& pathName, tHashSet<cStaticSceneNode*>& objectSet, tHashSet<cLightSceneNode*>& lightSet, tHashSet<cSoundSceneNode*>& soundSet, tHashSet<cAreaSceneNode*>& areaSet, bool add = false );
	bool LoadSound( const cString& pathName, tHashSet<cSoundSceneNode*>& soundSet );
#else
	bool Load( const cString& pathName, unsigned int mapindex, bool add = false );
	bool LoadSound( const cString& pathName, unsigned int mapindex );
#endif

	bool LoadEnvVer6( cFileLoader& loader, bool add );
	bool LoadEnvVer7( cFileLoader& loader, bool add );
	bool LoadEnvVer8( cFileLoader& loader, bool add );
	bool LoadEnvVer9( cFileLoader& loader , bool add);
	bool LoadEnvVer10( cFileLoader& loader, bool add );
	bool LoadGlobalAreaVer6( cFileLoader& loader, bool add );
	bool LoadGlobalAreaVer7( cFileLoader& loader, bool add );
	bool LoadGlobalAreaVer8( cFileLoader& loader, bool add );
	bool LoadGlobalAreaVer9( cFileLoader& loader, bool add );
	bool LoadGlobalAreaVer10( cFileLoader& loader, bool add );
#ifdef MAP_EDITOR
	bool LoadVer6( cFileLoader& loader, cSceneFileHeader& header, tHashSet<cStaticSceneNode*>& objectSet, tHashSet<cLightSceneNode*>& lightSet, tHashSet<cSoundSceneNode*>& soundSet, tHashSet<cAreaSceneNode*>& areaSet );
	bool LoadVer7( cFileLoader& loader, cSceneFileHeader& header, tHashSet<cStaticSceneNode*>& objectSet, tHashSet<cLightSceneNode*>& lightSet, tHashSet<cSoundSceneNode*>& soundSet, tHashSet<cAreaSceneNode*>& areaSet );
	bool LoadVer8( cFileLoader& loader, cSceneFileHeader& header, tHashSet<cStaticSceneNode*>& objectSet, tHashSet<cLightSceneNode*>& lightSet, tHashSet<cSoundSceneNode*>& soundSet, tHashSet<cAreaSceneNode*>& areaSet );
	bool LoadVer9( cFileLoader& loader, cSceneFileHeader& header, tHashSet<cStaticSceneNode*>& objectSet, tHashSet<cLightSceneNode*>& lightSet, tHashSet<cSoundSceneNode*>& soundSet, tHashSet<cAreaSceneNode*>& areaSet );
	bool LoadVer10( cFileLoader& loader, cSceneFileHeader& header, tHashSet<cStaticSceneNode*>& objectSet, tHashSet<cLightSceneNode*>& lightSet, tHashSet<cSoundSceneNode*>& soundSet, tHashSet<cAreaSceneNode*>& areaSet );
	bool LoadVer11( cFileLoader& loader, cSceneFileHeader& header, tHashSet<cStaticSceneNode*>& objectSet, tHashSet<cLightSceneNode*>& lightSet, tHashSet<cAreaSceneNode*>& areaSet );
	bool LoadAreaGroup( const cString& pathName );
	bool LoadObjectTransformScript( const cString& pathName, tHashSet<cStaticSceneNode*>& objectSet );

	bool LoadSoundVer11( cFileLoader& loader, cSoundSceneFileHeader& header, tHashSet<cSoundSceneNode*>& soundSet );
#else
	bool LoadVer6( cFileLoader& loader, cSceneFileHeader& header );
	bool LoadVer7( cFileLoader& loader, cSceneFileHeader& header );
	bool LoadVer8( cFileLoader& loader, cSceneFileHeader& header );
	bool LoadVer9( cFileLoader& loader, cSceneFileHeader& header );
	bool LoadVer10( cFileLoader& loader, unsigned int mapindex, cSceneFileHeader& header );
	bool LoadVer11( cFileLoader& loader, unsigned int mapindex, cSceneFileHeader& header );

	bool LoadSoundVer11( cFileLoader& loader, unsigned int mapindex, cSoundSceneFileHeader& header );
#endif

	/// ó
	void Process( float deltaTime, float accumTime, bool testing );

	/// 
	void Render();
	void RenderShadow();

	/// Ʈ ġ, ũ 
	void AdjustAllPos( float scale );
	void AdjustAllSize( float scale );

	/// ȭ  ǥ ϴ   
	/// ﰢ  ˻Ѵ.
	bool Pick( tArray<cSceneNode*>* pickedArray, int mouseX, int mouseY, bool sortByDistance, eSceneNodeType type );

	/// 浹ϴ   
	bool Pick( tArray<cSceneNode*>* pickedArray, const cRay& ray, float maxDistance, bool sortByDistance, eSceneNodeType type );
	bool Pick( tArray<cSceneNode*>* pickedArray, const cSphere& sphere, eSceneNodeType type );

	/// 带 
	void DestroyAll();
	bool DestroyNode( cSceneNode* node );
	bool DestroyNode( eSceneNodeType type, unsigned int index );

	/// 带 
	cAreaSceneNode* CreateArea( const cAreaSceneNodeParam& param );
	cLightSceneNode* CreateLight( const cLightSceneNodeParam& param );
	cStaticSceneNode* CreateStatic( cStaticSceneNodeParam& param );
	cNpcSceneNode* CreateNPC( const cNpcSceneNodeParam& param );
	cMonsterSceneNode* CreateMonster( const cMonsterSceneNodeParam& param );
	cGatheringSceneNode* CreateGathering( cGatheringSceneNodeParam& param );
	cPortalSceneNode* CreatePortal( cPortalSceneNodeParam& param );

#ifdef MAP_EDITOR
	cSoundSceneNode* CreateSound( const cSoundSceneNodeParam& param );

	void SetStaticeObjectWireframe( bool view ) { mStaticObjectWireframe = view; }
#endif

	/// ֺ
	void SetAmbientLightAmbient( unsigned int i, const NiColor& color );
	void SetAmbientLightDiffuse( unsigned int i, const NiColor& color );
	void SetAmbientLightDimmer( unsigned int i, float dimmer );
	NiAmbientLight* GetAmbientLight( unsigned int i ) const;

	/// Ɽ
	void SetDirLightAmbient( unsigned int i, const NiColor& color );
	void SetDirLightDiffuse( unsigned int i, const NiColor& color );
	void SetDirLightDimmer( unsigned int i, float dimmer );
	void SetDirLightRotate( unsigned int i, float xangle, float yangle, float zangle );
	NiDirectionalLight* GetDirLight( unsigned int i ) const;

	/// Ȱ
	void SetFog( bool enabled, const NiColor& color, float depth );
	void SetFogColor( const NiColor& color );
	void SetFogDepth( float depth );
	NiFogProperty* GetFogProperty() const;

	///   Ÿ
	void SetLevelDistance( float dist0, float dist1, float dist2 );
	float GetLevelDistance0() const;
	float GetLevelDistance1() const;
	float GetLevelDistance2() const;

	unsigned int CalcVisibleLevel( cStaticSceneNode* n );

	///  Ʈ 
	const NiPoint3& GetCenter() const;
	float GetMinRadius() const;
	float GetMaxRadius() const;

	/// ̴   
	unsigned int GetNumVisibleAlphaNodes() const;
	unsigned int GetNumVisibleSolidNodes() const;

	/// ü  
	cAreaSceneNode* GetGlobalArea();

	/// ׸
	void AddVisibleShadowGeom( cShadowGeometry* geom );

protected:
	/// 带 ߰
	void AddNode( cSceneNode* node );

public:
	/// ü 
	static cSceneManager* GetSingleton();

protected:
	/// ʱȭ 
	bool mInited;

	/// ؽó 
	typedef tHashMap<unsigned int, NiTexture*> cTextureMap;
	cTextureMap mTextureMap;

	/// Ʈ
	///  Ͽ   Ѵ.
	/// 浹 ˻  ø ȿ ϱ Ѵ.
	NiPoint3 mCenter;
	float mMinRadius;
	float mMaxRadius;
	cSceneTree mNodeTree;

	///  迭
	typedef tArray<cAreaSceneNode*> cAreaArray;
	cAreaArray mAreaArray;

	///  迭
	typedef tArray<cLightSceneNode*> cLightArray;
	cLightArray mLightArray;

	///   迭
	typedef tArray<cStaticSceneNode*> cStaticArray;
	cStaticArray mStaticArray;

#ifdef MAP_EDITOR
	bool mStaticObjectWireframe;
#endif

	///   迭
	typedef tArray<cDynamicSceneNode*> cDynamicArray;
	cDynamicArray mDynamicArray;

#ifdef MAP_EDITOR
	///  迭
	typedef tArray<cSoundSceneNode*> cSoundArray;
	cSoundArray mSoundArray;
#endif

	///   Ÿ
	float mLevelDistance0;
	float mLevelDistance1;
	float mLevelDistance2;
	float mSqaredLevelDistance0;
	float mSqaredLevelDistance1;
	float mSqaredLevelDistance2;

	///    迭
	cVisibleArray mAlphaArray;

	///    迭
	cVisibleArray mSolidArray;
	cVisibleArray mSkinedArray;

	///    迭 
	cAlphaArraySorter mAlphaArraySorter;

	///    迭 
	cSolidArraySorter mSolidArraySorter;
	cSolidArraySorter mSkinedArraySorter;

	/// Ȱ Ӽ
	NiFogPropertyPtr mFogProp;

	/// 
	NiAmbientLightPtr mAmbientLight[2];
	NiDirectionalLightPtr mDirLight[2];

	/// ŷ   迭
	typedef tArray<cSceneNode*> cPickedArray;
	cPickedArray mPickedArray;

	/// ü  
	cAreaSceneNode* mGlobalArea;

#ifdef MAP_EDITOR
	///  ׷
	typedef tHashMap<unsigned int, cAreaGroup*> cAreaGroupMap;
	cAreaGroupMap mAreaGroupMap;
#endif

	/// ׸  迭
	typedef tArray<cShadowGeometry*> cShadowGeomArray;
	cShadowGeomArray mShadowGeomArray;

	NiPoint3 mHeroPos;
};

inline
bool cSceneManager::IsInited() const
{
	return mInited;
}

inline
NiFogProperty* cSceneManager::GetFogProperty() const
{
	return mFogProp;
}

inline
NiAmbientLight* cSceneManager::GetAmbientLight( unsigned int i ) const
{
	return mAmbientLight[i];
}

inline
NiDirectionalLight* cSceneManager::GetDirLight( unsigned int i ) const
{
	return mDirLight[i];
}

inline
const NiPoint3& cSceneManager::GetCenter() const
{
	return mCenter;
}

inline
float cSceneManager::GetMinRadius() const
{
	return mMinRadius;
}

inline
float cSceneManager::GetMaxRadius() const
{
	return mMaxRadius;
}

inline
unsigned int cSceneManager::GetNumVisibleAlphaNodes() const
{
	return mAlphaArray.GetCount();
}

inline
unsigned int cSceneManager::GetNumVisibleSolidNodes() const
{
	return mSolidArray.GetCount();
}

inline
cAreaSceneNode* cSceneManager::GetGlobalArea()
{
	return mGlobalArea;
}

inline
void cSceneManager::SetLevelDistance( float dist0, float dist1, float dist2 )
{
	mLevelDistance0 = dist0;
	mLevelDistance1 = dist1;
	mLevelDistance2 = dist2;
	mSqaredLevelDistance0 = mLevelDistance0 * mLevelDistance0;//dist0 * dist0;
	mSqaredLevelDistance1 = mLevelDistance1 * mLevelDistance1;//dist1 * dist1;
	mSqaredLevelDistance2 = mLevelDistance2 * mLevelDistance2;//dist2 * dist2;
}

inline
float cSceneManager::GetLevelDistance0() const
{
	return mLevelDistance0;
}

inline
float cSceneManager::GetLevelDistance1() const
{
	return mLevelDistance1;
}

inline
float cSceneManager::GetLevelDistance2() const
{
	return mLevelDistance2;
}

inline
void cSceneManager::AddVisibleShadowGeom( cShadowGeometry* geom )
{
	assert( geom );

	mShadowGeomArray.PushBack( geom );
}

inline
cSceneManager* cSceneManager::GetSingleton()
{
	return mSingleton;
}

#define SCENEMAN cSceneManager::GetSingleton()
