/* ==========================================================================
*    : ̼
*    : 2006.12.08
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

#include "Ray.h"
#include "Sphere.h"
#include "MaterialData.h"

class cSceneCuller;
class cLightSceneNode;

///   Ÿ
enum eSceneNodeType
{
	SCENENODE_NULL		= 0,
	SCENENODE_RENDERING	= (1 <<  0),

	SCENENODE_AREA		= (1 <<  1),
	SCENENODE_LIGHT		= (1 <<  2),
	SCENENODE_SOUND		= (1 <<  3),
	SCENENODE_STATIC	= (1 <<  4) | SCENENODE_RENDERING,
	SCENENODE_DYNAMIC	= (1 <<  5) | SCENENODE_RENDERING,
	SCENENODE_EFFECT	= (1 <<  6) | SCENENODE_RENDERING,

	SCENENODE_ITEM		= (1 <<  7) | SCENENODE_STATIC,
	SCENENODE_PORTAL	= (1 <<  8) | SCENENODE_STATIC,
	SCENENODE_GATHERING	= (1 <<  9) | SCENENODE_STATIC,

	SCENENODE_PLAYER	= (1 << 10) | SCENENODE_DYNAMIC,
	SCENENODE_NPC		= (1 << 11) | SCENENODE_DYNAMIC,
	SCENENODE_MONSTER	= (1 << 12) | SCENENODE_DYNAMIC,

	SCENENODE_HERO		= (1 << 13) | SCENENODE_PLAYER,
};

enum eSceneNodeTypeVer8
{
	SCENENODE_NULL_VER8	= 0,
	SCENENODE_AREA_VER8,
	SCENENODE_LIGHT_VER8,
	SCENENODE_SOUND_VER8,
	SCENENODE_STATIC_VER8,
	SCENENODE_DYNAMIC_VER8,
};

///  Ÿ
class cAlphaData
{
public:
	cAlphaData( bool blendEnabled, bool testEnabled, NiAlphaProperty::TestFunction testFunc, unsigned char testRef, NiAlphaProperty* prop );

public:
	///  
	bool mBlendEnabled;

	///  ׽
	bool mTestEnabled;
	NiAlphaProperty::TestFunction mTestFunc;
	unsigned char mTestRef;

	///  Ӽ
	NiAlphaProperty* mProp;
};

inline
cAlphaData::cAlphaData( bool blendEnabled, bool testEnabled, NiAlphaProperty::TestFunction testFunc, unsigned char testRef, NiAlphaProperty* prop )
: mBlendEnabled( blendEnabled )
, mTestEnabled( testEnabled )
, mTestFunc( testFunc )
, mTestRef( testRef )
, mProp( prop )
{
	assert( prop );
}

///   
class cSceneNodeParam
{
public:
	cSceneNodeParam();

public:
	///  ̸
	mutable cString mPathName;

	/// ġ
	NiPoint3 mTranslate;

	/// ȸ
	NiMatrix3 mRotate;

	/// 
	float mScale;

	///  
	mutable NiAVObject* mNiObject;

	/// ŷ
	mutable NiPick::PickType mPickType;
	mutable NiPick::SortType mPickSort;
	mutable NiPick::IntersectType mPickIntersect;
	mutable NiPick::CoordinateType mPickCoordinate;
	mutable bool mPickFrontOnly;
	mutable bool mPickReturnTexture;
	mutable bool mPickReturnNormal;
	mutable bool mPickReturnColor;
};

inline
cSceneNodeParam::cSceneNodeParam()
: mTranslate( NiPoint3::ZERO )
, mRotate( NiMatrix3::IDENTITY )
, mScale( 1.0f )
, mNiObject( 0 )
, mPickType( NiPick::FIND_ALL )
, mPickSort( NiPick::SORT )
, mPickIntersect( NiPick::TRIANGLE_INTERSECT )
, mPickCoordinate( NiPick::WORLD_COORDINATES )
, mPickFrontOnly( true )
, mPickReturnTexture( false )
, mPickReturnNormal( false )
, mPickReturnColor( false )
{
}

///  
class cSceneNode
{
	friend class cSceneManager;
	friend class cSceneTree;
	friend class cSceneTreeNode;
	friend class cObjectEditor;
	friend class cLightEditor;
	friend class cObjectDeletingInfo;

public:
	/// ó
	virtual void Process( float deltaTime, float accumTime );
	virtual void ProcessAlpha( float deltaTime );
	virtual bool OnVisible( cSceneCuller& culler );

	/// 
	void Update();
	void UpdateAlpha();
	void UpdateTransform();

	/// ŷ
	virtual bool Pick( const cRay& ray );

	/// ŷ 
	/// : Pick() ȣ Ŀ ؾ Ѵ.
	const NiPick::Results& GetPickResults() const;
	const NiPoint3& GetPickPos() const;
	float GetPickDistance() const;

	/// 
	void RemoveLight( cLightSceneNode* node );

	/// Ÿ
	eSceneNodeType GetType() const;
	bool IsKindof( eSceneNodeType type ) const;

	bool IsEnableFrustumFlag() { return mCheckFrustum; }

	///  Ʈ
	NiAVObject* GetNiObject() const;

	/// ̵
	void Translate( const NiPoint3& move );
	virtual void SetTranslate( const NiPoint3& trans );
	const NiPoint3& GetTranslate() const;
	virtual const NiPoint3& GetWorldTranslate() const;

	/// ȸ
	void SetRotate( const NiPoint3& axis, float angle );
	void SetRotate( float xangle, float yangle, float zangle );
	void SetRotate( const NiMatrix3& rot );
	const NiMatrix3& GetRotate() const;
	const NiMatrix3& GetWorldRotate() const;

	/// ũ
	void SetScale( float scale );
	float GetScale() const;
	float GetWorldScale() const;

	///  
	const cSphere& GetBoundSphere() const;

	/// ߽
	virtual const NiPoint3& GetCenter() const;

	/// 
	virtual float GetRadius() const;

	///  
	unsigned int WhichSide( const NiPlane& plane ) const;

	///  ̸
	const cString& GetFileName() const;

	///  Ÿ
	void SetUserData0( unsigned int data );
	void SetUserData1( unsigned int data );
	void SetUserData2( unsigned int data );
	void SetUserData3( unsigned int data );
	unsigned int GetUserData0() const;
	unsigned int GetUserData1() const;
	unsigned int GetUserData2() const;
	unsigned int GetUserData3() const;

	///  
	bool IsAlphaBlended() const;

	///  ʿ 
	void SetNeedUpdateTransform( bool update );
	void SetNeedUpdateEffects( bool update );

	///  Ʈ 
	unsigned int GetNumGeoms() const;

#ifdef REGEN_TOOL
	/// ø
	void SetCulled( bool culled );
#endif

protected:
	cSceneNode( eSceneNodeType = SCENENODE_NULL );
	virtual ~cSceneNode();

	/// 
	virtual bool Save( cFileSaver& saver );

	/// ʱȭ
	virtual bool Init( const cSceneNodeParam& param );

	///  Ʈ
	void CollectGeoms( NiAVObject* obj );
	void CollectBillboards( NiAVObject* obj );
	NiGeometry* GetGeom( NiNode* node );

	///  Ӽ
	void CollectProperties( NiAVObject* obj );

	///  Ʈ  迭 ߰
	virtual void AddToVisibleArray( NiVisibleArray* solidArray, NiVisibleArray* skinedArray, NiVisibleArray* alphaArray ) const;

protected:
	/// Ÿ
	eSceneNodeType mType;

	/// ̸
	cString mFilePath;
	cString mFileName;

	///  Ÿ
	unsigned int mUserData0;
	unsigned int mUserData1;
	unsigned int mUserData2;
	unsigned int mUserData3;

	///  Ʈ
	NiAVObjectPtr mNiObject;

	///  Ÿ Ʈ
	typedef tList<cMaterialData> cMaterialDataList;
	cMaterialDataList mMatDataList;

	///  Ÿ Ʈ
	typedef tList<cAlphaData> cAlphaDataList;
	cAlphaDataList mAlphaDataList;

	///  Ʈ Ʈ
	typedef tPair<NiTriBasedGeom*, bool> cGeomPair;
	typedef tList<cGeomPair> cGeomList;
	cGeomList mGeomList;

	///   Ʈ
	typedef tList<NiBillboardNode*> cBillboardList;
	cBillboardList mBillboardList;

	/// ŷ
	///  Ʈ ̿ 浹 ˻  ŷ ϰ,   Ѵ.
	bool mPickBound;
	NiPick mPick;
	NiPoint3 mPickPos;
	float mPickDistance;

	///  ʿ 
	bool mNeedUpdateProperties;
	bool mNeedUpdateTransform;
	bool mNeedUpdateEffects;
	bool mNeedUpdateAlpha;

	///  
	cSphere mBoundSphere;

	/// 
	bool mAlphaForced;
	bool mAlphaBlended;
	float mTargetAlpha;
	float mAlpha;

	///  迭
	typedef tArray<cSceneNode*> cLightArray;
	cLightArray mLightArray;

	///  ڿ    ε
	unsigned int mIndexByManager;

	/// ̳
	///  带 ϴ  Ʈ 
	cSceneTreeNode* mContainer;

	/// ̳ʿ    ݺ
	tList<cSceneNode*>::cIterator mIteratorByContainer;

	bool mCheckFrustum;

#ifdef REGEN_TOOL
	bool mCulled;
#endif
};

inline
void cSceneNode::SetNeedUpdateTransform( bool update )
{
	mNeedUpdateTransform = update;
}

inline
void cSceneNode::SetNeedUpdateEffects( bool update )
{
	mNeedUpdateEffects = update;
}

inline
eSceneNodeType cSceneNode::GetType() const
{
	return mType;
}

inline
bool cSceneNode::IsKindof( eSceneNodeType type ) const
{
	return (mType & type) == type;
}

inline
NiAVObject* cSceneNode::GetNiObject() const
{
	return mNiObject;
}

inline
const NiPick::Results& cSceneNode::GetPickResults() const
{
	return mPick.GetResults();
}

inline
const NiPoint3& cSceneNode::GetPickPos() const
{
	return mPickPos;
}

inline
float cSceneNode::GetPickDistance() const
{
	return mPickDistance;
}

inline
const NiPoint3& cSceneNode::GetTranslate() const
{
	return mNiObject->GetTranslate();
}

inline
const NiMatrix3& cSceneNode::GetRotate() const
{
	return mNiObject->GetRotate();
}

inline
float cSceneNode::GetScale() const
{
	return mNiObject->GetScale();
}

inline
const NiPoint3& cSceneNode::GetWorldTranslate() const
{
	return mNiObject->GetWorldTranslate();
}

inline
const NiMatrix3& cSceneNode::GetWorldRotate() const
{
	return mNiObject->GetWorldRotate();
}

inline
float cSceneNode::GetWorldScale() const
{
	return mNiObject->GetWorldScale();
}

inline
const cSphere& cSceneNode::GetBoundSphere() const
{
	return mBoundSphere;
}

inline
unsigned int cSceneNode::WhichSide( const NiPlane& plane ) const
{
	float dist = plane.Distance( GetCenter() );
	float radius = GetRadius();

	if( dist <= -radius )
		return NiPlane::NEGATIVE_SIDE;
	else if( dist >= radius )
		return NiPlane::POSITIVE_SIDE;
	else
		return NiPlane::NO_SIDE;
}

inline
const cString& cSceneNode::GetFileName() const
{
	return mFileName;
}

inline
void cSceneNode::SetUserData0( unsigned int data )
{
	mUserData0 = data;
}

inline
void cSceneNode::SetUserData1( unsigned int data )
{
	mUserData1 = data;
}

inline
void cSceneNode::SetUserData2( unsigned int data )
{
	mUserData2 = data;
}

inline 
void cSceneNode::SetUserData3( unsigned int data )
{
	mUserData3 = data;
}

inline
unsigned int cSceneNode::GetUserData0() const
{
	return mUserData0;
}

inline
unsigned int cSceneNode::GetUserData1() const
{
	return mUserData1;
}

inline
unsigned int cSceneNode::GetUserData2() const
{
	return mUserData2;
}

inline
unsigned int cSceneNode::GetUserData3() const
{
	return mUserData3;
}


inline
unsigned int cSceneNode::GetNumGeoms() const
{
	return mGeomList.GetSize();
}

inline
bool cSceneNode::IsAlphaBlended() const
{
	return mAlphaForced ? true : mAlphaBlended;
}

#ifdef REGEN_TOOL
inline
void cSceneNode::SetCulled( bool culled )
{
	mCulled = culled;
}
#endif

///    Լ
/// ŷ Ÿ Ѵ.
class cSceneNodeCompareForPicking
{
public:
	bool operator () ( const cSceneNode* left, const cSceneNode* right ) const
	{
		return left->GetPickDistance() < right->GetPickDistance();
	};
};
