/* ==========================================================================
*    : ̼
*    : 2006.12.07
*      :  Ʈ
* ǻ : 
*===========================================================================*/
#pragma once

#include "Sphere.h"
#include "SceneNode.h"

class cSceneTree;
class cSceneCuller;

/// ׽Ʈ 
///  带  ϴ  ˻ϴµ δ.
class cTestSphere : public cSphere
{
public:
	/// ˻ 
	bool mResult;
};

///  Ʈ 
///    ϴ ̴̳.
class cSceneTreeNode : public cSphere
{
	friend class cSceneTree;

public:
	cSceneTreeNode( cSceneTree* tree, cSceneTreeNode* parent, const NiPoint3& center, float radius );
	cSceneTreeNode( cSceneTree* tree, cSceneTreeNode* parent, const cSphere& sphere );
	~cSceneTreeNode();

	void* operator new( size_t n ); 
	void operator delete( void* p );

	/// Ʈ     
	void Clear();

	///  带 ߰
	void Push( cSceneNode* node );

	///  带 
	void Remove( cSceneNode* node );

	///   ̵ Ǵ ũ ȭ  
	void Update( cSceneNode* node );

	/// ø
	void Cull();

	///  浹ϴ   
	/// ﰢ  ˻Ѵ.
	bool CollideRay();

	///  浹ϴ   
	///   ˻Ѵ.
	bool CollideSphere();

protected:
	///  迭 ߰
	void AddToVisibleArray() const;

private:
	/// Ʈ
	cSceneTree* mTree;

	/// θ
	cSceneTreeNode* mParent;

	/// ڽ 迭
	cSceneTreeNode* mChild[4];

	/// ׽Ʈ 
	cTestSphere mTestSpheres[4];

	///   Ʈ
	typedef tList<cSceneNode*> cObjectList;
	cObjectList mObjectList;

	/// ޸ Ǯ
	static tPool<cSceneTreeNode> mPool;

	/// ø
	static NiFrustumPlanes* mFrustum;
	static cSceneCuller* mCuller;
	static eSceneNodeType mPickType;
	static NiVisibleArray* mSolidArray;
	static NiVisibleArray* mSkinedArray;
	static NiVisibleArray* mAlphaArray;

	/// 浹 ˻
	static const cRay* mRay;
	static float mMaxDistance;
	static const cSphere* mSphere;
	static tArray<cSceneNode*>* mCollideArray;
};

///  Ʈ
///      øϰų 浹 ˻縦 ϱ  Ѵ.
class cSceneTree
{
public:
	cSceneTree();
	virtual ~cSceneTree();

	///    
	void Clear();

	/// ʱȭ
	void Init( const NiPoint3& center, float minRadius, float maxRadius );

	///  带 ߰
	void Push( cSceneNode* node );

	/// ø
	void Cull( NiVisibleArray* solidArray, NiVisibleArray* skinedArray, NiVisibleArray* alphaArray, NiFrustumPlanes& frustum, cSceneCuller& culler, eSceneNodeType type );

	///  浹ϴ   
	/// ﰢ  ˻Ѵ.
	bool CollideRay( tArray<cSceneNode*>* pickedArray, const cRay& ray, float maxDistance, bool sortByDistance, eSceneNodeType type );

	///  浹ϴ   
	///   ˻Ѵ.
	bool CollideSphere( tArray<cSceneNode*>* pickedArray, const cSphere& sphere, eSceneNodeType type );

	///  
	const NiPoint3& GetCenter() const;

	/// ּ  
	float GetMinRadius() const;

	/// ִ  
	float GetMaxRadius() const;

protected:
	/// Ʈ 
	cSceneTreeNode* mRootNode;

	/// 
	NiPoint3 mCenter;

	/// ּ 
	float mMinRadius;

	/// ִ 
	float mMaxRadius;
};

inline
const NiPoint3& cSceneTree::GetCenter() const
{
	return mCenter;
}

inline
float cSceneTree::GetMinRadius() const
{
	return mMinRadius;
}

inline
float cSceneTree::GetMaxRadius() const
{
	return mMaxRadius;
}
