/* ==========================================================================
*    : ̼
*    : 2007.01.23
*      :   
* ǻ : 
*===========================================================================*/
#pragma once

#include "SceneNode.h"

///    
class cSoundSceneNodeParam : public cSceneNodeParam
{
public:
	cSoundSceneNodeParam();

public:
	/// 
	float mOuterRadius;

	///  Ÿ
	float mAttenDistance;

	/// ݺ Ƚ
	unsigned int mLoopCount;

	///  
	float mLoopInterval;

	///   [0, 1]
	float mVolumeRatio;
};

inline
cSoundSceneNodeParam::cSoundSceneNodeParam()
: mOuterRadius( 1000.0f )
, mAttenDistance( 100.0f )
, mLoopCount( 0 )
, mLoopInterval( 0.0f )
, mVolumeRatio( 1.0f )
{
	mPickType = NiPick::FIND_FIRST;
	mPickSort = NiPick::NO_SORT;
	mPickIntersect = NiPick::BOUND_INTERSECT;
	mPickFrontOnly = false;
}

#ifdef MAP_EDITOR
#include "Sphere.h"

///   
class cSoundSceneNode : public cSceneNode
{
	friend class cSceneManager;
	friend class cSoundEditor;

	enum eListenerStatus
	{
		LISTENER_IN,
		LISTENER_OUT
	};

public:
	/// ó
	void Process( float deltaTime, float accumTime );

	/// ŷ
	bool Pick( const cRay& ray );

	/// ߽
	const NiPoint3& GetCenter() const;

	/// 
	void SetRadius( float radius );
	float GetRadius() const;

	///  Ÿ
	void SetAttenDistance( float dist );
	float GetAttenDistance() const;

	///
	void SetListenerStatus( eListenerStatus status, const cSphere& sphere );

protected:
	cSoundSceneNode( eSceneNodeType type = SCENENODE_SOUND );
	virtual ~cSoundSceneNode();

	/// 
	virtual bool Save( cFileSaver& saver );

	/// ʱȭ
	virtual bool Init( const cSoundSceneNodeParam& param );

	/// ݺ Ƚ
	void SetLoopCount( unsigned int count );
	int GetLoopCount() const;

	///  
	void SetLoopInterval( float interval );
	float GetLoopInterval() const;

	/// 
	void SetVolumeRatio( float ratio );
	float GetVolumeRatio() const;

protected:
	///  
	NiAudioSourcePtr mSound;

	///  
	eListenerStatus mListenerStatus;
	eListenerStatus mOldListenerStatus;

	/// 
	float mRadius;

	///  Ÿ
	float mAttenDistance;

	/// ݺ ȸ
	unsigned int mLoopCount;
	unsigned int mTempCount;

	///  
	float mLoopInterval;
	float mTempInterval;

	/// 
	float mVolumeRatio;
	float mGain;
	float mTargetGain;

	///  
	cSphere mListenerSphere;
};

inline
const NiPoint3& cSoundSceneNode::GetCenter() const
{
	return mSound->GetWorldTranslate();
}

inline
void cSoundSceneNode::SetRadius( float radius )
{
	mNeedUpdateTransform = true;
	mRadius = radius;
}

inline
float cSoundSceneNode::GetRadius() const
{
	return mRadius;
}

inline
void cSoundSceneNode::SetAttenDistance( float dist )
{
	mAttenDistance = dist;
}

inline
float cSoundSceneNode::GetAttenDistance() const
{
	return mAttenDistance;
}

inline
void cSoundSceneNode::SetLoopCount( unsigned int count )
{
	mLoopCount = count;
}

inline
int cSoundSceneNode::GetLoopCount() const
{
	return mLoopCount;
}

inline
void cSoundSceneNode::SetLoopInterval( float interval )
{
	mLoopInterval = interval;
}

inline
float cSoundSceneNode::GetLoopInterval() const
{
	return mLoopInterval;
}

inline
void cSoundSceneNode::SetVolumeRatio( float ratio )
{
	mVolumeRatio = ratio;
}

inline
float cSoundSceneNode::GetVolumeRatio() const
{
	return mVolumeRatio;
}
#endif /// MAP_EDITOR
