/* ==========================================================================
*    : ̼
*    : 2007.03.20
*      :  ý
* ǻ : 
*===========================================================================*/
#pragma once

#ifdef MAP_EDITOR
///  ý
class cSoundSystem
{
	static cSoundSystem* mSingleton;

public:
	cSoundSystem();
	~cSoundSystem();

	/// ʱȭ
	bool Init( NiWindowRef hwnd );

	/// 2D 
	NiAudioSource* Load2DSound( unsigned int index, const cString& pathName, bool streamed = false );
	NiAudioSource* Get2DSound( unsigned int index ) const;
	bool Play2DSound( unsigned int index );
	bool Stop2DSound( unsigned int index );

public:
	/// ü 
	static cSoundSystem* GetSingleton();

private:
	/// 2D  
	typedef tHashMap<unsigned int, NiAudioSourcePtr> c2DSoundMap;
	c2DSoundMap m2DSoundMap;
};

inline
NiAudioSource* cSoundSystem::Get2DSound( unsigned int index ) const
{
	c2DSoundMap::cConstIterator i = m2DSoundMap.Find( index );

	if( i != m2DSoundMap.End() )
		return i->mSecond;
	else
		return 0;
}

inline
cSoundSystem* cSoundSystem::GetSingleton()
{
	return mSingleton;
}

#define SOUNDSYS cSoundSystem::GetSingleton()
#endif /// MAP_EDITOR
