#include "stdafx.h"
#include "StaticSceneNode.h"

#include "SceneManager.h"
#include "ResourceManager.h"

#include "NifAnimationInfo.h"

cStaticSceneNode::cStaticSceneNode( eSceneNodeType type )
: cSceneNode( type )
, mNumVerts( 0 )
, mVisibleLevel( 0 )
, mOccludeLevel( 1 )
, mFogApplied( false )
, mMaterialApplied( false )
, mPickedByCamera( false )
{
	mNifAniInfo = new cNifAnimationInfo;
}

cStaticSceneNode::~cStaticSceneNode()
{
	delete mNifAniInfo;
}

void cStaticSceneNode::Process( float deltaTime, float accumTime )
{
	ProcessVisibleLevel( deltaTime );
	if( mCheckFrustum == false )
		return;

	/// ݺ     带 ó
	if( mNifAniInfo )
	{
		mNeedUpdateTransform = true;
		mNifAniInfo->Update( accumTime );
	}

	cSceneNode::Process( deltaTime, accumTime );

#ifdef REGEN_TOOL
	mTargetAlpha = 0.4f;

	/// ĸ ó
	ProcessAlpha( deltaTime );
#endif
}

void cStaticSceneNode::ProcessVisibleLevel( float deltaTime )
{
	///   ó
#ifdef MAP_EDITOR
	if( mVisibleLevel < 3 )
	{
		///  Ÿŭ Ÿ üũ
		if( mVisibleLevel <  SCENEMAN->CalcVisibleLevel( this ) )
		{
			if( mVisibleLevel == 2 )
			{
				int a = 0;
				a = 1;
			}

			mTargetAlpha = 0.0f;
			if( mAlpha == mTargetAlpha )
				/// no frustum check
				mCheckFrustum = false;
			else
				/// frustum check
				mCheckFrustum = true;
		}
		else
		{
			if( mOccludeLevel ==1 && mPickedByCamera )
			{
				mPickedByCamera = false;
				mTargetAlpha = 0.4f;
			}
			else
			{
				mTargetAlpha = 1.0f;
			}

			/// frustum check
			mCheckFrustum = true;
		}

		/// ĸ ó
		ProcessAlpha( deltaTime );
	}

	/*
//	if( mOccludeLevel == 1 )
	{
		if( culler.mPlaying )
		{
			if( mVisibleLevel < 3 && mVisibleLevel < culler.GetVisibleLevel( GetCenter() ) )
			{
				mTargetAlpha = 0.0f;
			}
			else
			{
				if( mPickedByCamera )
				{
					mPickedByCamera = false;
					mTargetAlpha = 0.4f;
				}
				else
				{
					mTargetAlpha = 1.0f;
				}
			}
		}
		else
		{
			mTargetAlpha = 1.0f;
		}

		/// ĸ ó
		ProcessAlpha( deltaTime );
	}
//	else
//	{
//	}
*/
#else
deltaTime;
#endif
}

bool cStaticSceneNode::Save( cFileSaver& saver )
{
	///   
	if( cSceneNode::Save( saver ) == false ) 
		return false;

	/// Ȱ  θ 
	saver.WriteUnsignedInt( mFogApplied ? 1 : 0 );

	///   θ 
	saver.WriteUnsignedInt( mMaterialApplied ? 1 : 0 );

	///  Ӽ 
	saver.Write( &mMaterial, sizeof(cMaterialData_Ver9) );

	/// Ÿ Ӽ 
	saver.WriteUnsignedInt( mVisibleLevel );
	saver.WriteUnsignedInt( mOccludeLevel );
	return true;
}

bool cStaticSceneNode::Init( cStaticSceneNodeParam& param )
{
	///  ε
	if( RESOURCEMAN->LoadNIF( param.mPathName ) == false )
		return false;

	/// ҽ ڷκ  带 
	NiNode* n = RESOURCEMAN->CloneNiNode( param.mPathName );

	if( n == 0 )
	{
		assert( 0 && "failed to clone node from resource manager" );
		return false;
	}

	///  ʱȭ
	param.mNiObject = n;
	if( cSceneNode::Init( param ) == false )
	{
		return false;
	}

	///   
	mVisibleLevel = param.mVisibleLevel;

	///   
	mOccludeLevel = param.mOccludeLevel;

	///  Ӽ 
	NiAlphaProperty* alphaProp = (NiAlphaProperty*)n->GetProperty( NiProperty::ALPHA );
	mAlphaForced = (alphaProp != 0);

	if( mAlphaForced )
	{
		mAlphaBlended = true;

#ifdef REGEN_TOOL
		bool blendEnabled = alphaProp->GetAlphaBlending();
		bool testEnabled = alphaProp->GetAlphaTesting();
		NiAlphaProperty::TestFunction testFunc = alphaProp->GetTestMode();
		unsigned char testRef = alphaProp->GetTestRef();
		mAlphaDataList.PushBack( cAlphaData( blendEnabled, testEnabled, testFunc, testRef, alphaProp ) );
#endif
	}
	else
	{
		mAlphaBlended = false;

#ifdef MAP_EDITOR

		mWireProp = NiNew NiWireframeProperty;
		mWireProp->SetWireframe( false );

		n->AttachProperty( mWireProp );

		if( mOccludeLevel == 1 )
#endif
		{
			///  Ӽ 
			alphaProp = NiNew NiAlphaProperty;
			alphaProp->SetAlphaBlending( false );
			alphaProp->SetAlphaTesting( false );
			n->AttachProperty( alphaProp );

			bool blendEnabled = alphaProp->GetAlphaBlending();
			bool testEnabled = alphaProp->GetAlphaTesting();
			NiAlphaProperty::TestFunction testFunc = alphaProp->GetTestMode();
			unsigned char testRef = alphaProp->GetTestRef();
			mAlphaDataList.PushBack( cAlphaData( blendEnabled, testEnabled, testFunc, testRef, alphaProp ) );
		}
	}

	/// Ӽ 
	CollectProperties( n );

	///  
	mMaterialApplied = param.mMaterialApplied;
	if( mMaterialApplied )
		SetMaterial( param.mMaterial );

	/// Ȱ Ӽ 
	mFogApplied = param.mFogApplied;
	if( mFogApplied )
	{
		n->AttachProperty( SCENEMAN->GetFogProperty() );
	}

	///  
	n->AttachEffect( SCENEMAN->GetAmbientLight( 0 ) );
	n->AttachEffect( SCENEMAN->GetDirLight( 0 ) );

	/// ִϸ̼ Ʈѷ  
	mNifAniInfo->CollectData( n );

	if( mNifAniInfo->GetNumberOfControllers() )
	{
		mNifAniInfo->SetAnimType( NiTimeController::APP_INIT );
		mNifAniInfo->SetLooping( true );
	}
	else
	{
		/// ִ  ٸ 
		delete mNifAniInfo;
		mNifAniInfo = 0;
	}

	/// 
	mNeedUpdateProperties = true;
	n->SetSelectiveUpdate( false );
	n->UpdateProperties();
	n->UpdateEffects();
	n->Update( 0.0f );

	/// ﰢ  
	cGeomList::cIterator i = mGeomList.Begin();
	cGeomList::cIterator iend = mGeomList.End();

	for( ; i != iend; ++i )
	{
		mNumVerts += i->mFirst->GetActiveVertexCount();
	}
	return true;
}

void cStaticSceneNode::SetMaterial( const cMaterialData& material )
{
	mMaterial = material;

	if( mMaterialApplied )
	{
		cMaterialDataList::cIterator i = mMatDataList.Begin();
		cMaterialDataList::cIterator iend = mMatDataList.End();

		for( ; i != iend; ++i )
		{
			NiMaterialProperty* matProp = i->mProp;

			matProp->SetAmbientColor( material.mAmbient );
			matProp->SetDiffuseColor( material.mDiffuse );
			matProp->SetSpecularColor( material.mSpecular );
			matProp->SetEmittance( material.mEmissive );
			matProp->SetShineness( material.mShininess );
			matProp->SetAlpha( material.mAlpha );
		}
	}
}

void cStaticSceneNode::SetAmbient( const NiColor& color )
{
	mMaterial.mAmbient = color;

	if( mMaterialApplied )
	{
		cMaterialDataList::cIterator i = mMatDataList.Begin();
		cMaterialDataList::cIterator iend = mMatDataList.End();

		for( ; i != iend; ++i )
		{
			i->mProp->SetAmbientColor( color );
		}
	}
}

void cStaticSceneNode::SetDiffuse( const NiColor& color )
{
	mMaterial.mDiffuse = color;

	if( mMaterialApplied )
	{
		cMaterialDataList::cIterator i = mMatDataList.Begin();
		cMaterialDataList::cIterator iend = mMatDataList.End();

		for( ; i != iend; ++i )
		{
			i->mProp->SetDiffuseColor( color );
		}
	}
}

void cStaticSceneNode::SetEmissive( const NiColor& color )
{
	mMaterial.mEmissive = color;

	if( mMaterialApplied )
	{
		cMaterialDataList::cIterator i = mMatDataList.Begin();
		cMaterialDataList::cIterator iend = mMatDataList.End();

		for( ; i != iend; ++i )
		{
			i->mProp->SetEmittance( color );
		}
	}
}

void cStaticSceneNode::SetMaterialApplied( bool matApplied )
{
//	if( mMaterialApplied == matApplied )
//	{
//		NiMessageBox( _T("Bug Check!!"), _T("Error") );
//	}

	mMaterialApplied = matApplied;

	if( mMaterialApplied )
		SetMaterial( mMaterial );
	else
		RestoreMaterial();
}

void cStaticSceneNode::SetVisibleLevel( unsigned int level )
{
	mVisibleLevel = level;
}

void cStaticSceneNode::SetOccludeLevel( unsigned int level )
{
	mOccludeLevel = level;
}

void cStaticSceneNode::SetFogApplied( bool fogApplied )
{
	if( mFogApplied == fogApplied )
		return;

	if( fogApplied )
	{
		mFogApplied = true;
		mNiObject->AttachProperty( SCENEMAN->GetFogProperty() );
	}
	else
	{
		mFogApplied = false;
		mNiObject->DetachProperty( SCENEMAN->GetFogProperty() );
	}
	mNiObject->UpdateProperties();
}

void cStaticSceneNode::RestoreMaterial()
{
	cMaterialDataList::cIterator i = mMatDataList.Begin();
	cMaterialDataList::cIterator iend = mMatDataList.End();

	for( ; i != iend; ++i )
	{
		cMaterialData& matData = *i;
		NiMaterialProperty* matProp = matData.mProp;

		if( matProp )
		{
			matProp->SetAmbientColor( matData.mAmbient );
			matProp->SetDiffuseColor( matData.mDiffuse );
			matProp->SetSpecularColor( matData.mSpecular );
			matProp->SetEmittance( matData.mEmissive );
			matProp->SetShineness( matData.mShininess );
			matProp->SetAlpha( matData.mAlpha );
		}
	}
}

NiTimeController* cStaticSceneNode::GetTimeController( NiAVObject* obj )
{
	NiTimeController* tc = NiGetController( NiTimeController, obj );

	if( tc )
		return tc;

	NiNode* node = NiDynamicCast( NiNode, obj );

	if( node )
	{
		NiAVObject* child = 0;

		for( unsigned int i = 0, iend = node->GetArrayCount(); i < iend; ++i )
		{
			child = node->GetAt( i );

			if( child )
			{
				tc = GetTimeController( child );
				if( tc )
					return tc;
			}
		}
	}
	return 0;
}

bool cStaticSceneNode::IsAnimated() const
{
	return mNifAniInfo->GetNumberOfControllers() > 0;
}

/*
unsigned int cStaticSceneNode::CalcVisibleLevel()
{
	float sqrDist = (mHeroPos - GetCenter()).SqrLength();

	if( sqrDist > mSqaredLevelDistance2 )
		return 3;
	if( sqrDist > mSqaredLevelDistance1 )
		return 2;
	if( sqrDist > mSqaredLevelDistance0 )
		return 1;
	return 0;
}
*/