/* ==========================================================================
*    : ̼
*    : 2006.12.20
*      :   
* ǻ : 
*===========================================================================*/
#pragma once

#include "SceneNode.h"

class cNifAnimationInfo;

///    
class cStaticSceneNodeParam : public cSceneNodeParam
{
public:
	cStaticSceneNodeParam();

public:
	/// Ȱ  
	bool mFogApplied;

	/// 
	bool mMaterialApplied;
	cMaterialData mMaterial;

	///  
	unsigned int mVisibleLevel;

	///  
	unsigned int mOccludeLevel;
};

inline
cStaticSceneNodeParam::cStaticSceneNodeParam()
: mFogApplied( true )
, mMaterialApplied( false )
, mVisibleLevel( 0 )
, mOccludeLevel( 1 )
{
	mPickFrontOnly = false;
}

///   
/// ó ǥ ϰ  ̵ ʴ´.
/// ڸ ݺ ִϸ̼   ִ.
/// ,  ,     .
class cStaticSceneNode : public cSceneNode
{
	friend class cSceneManager;
	friend class cObjectEditor;

public:
	/// ó
	virtual void Process( float deltaTime, float accumTime );
	virtual void ProcessVisibleLevel( float deltaTime );

	/// 
	void SetMaterialApplied( bool matApplied );
	bool GetMaterialApplied() const;

	void SetMaterial( const cMaterialData& material );
	const cMaterialData& GetMaterial() const;

	/// ֺ ݻ
	void SetAmbient( const NiColor& color );
	const NiColor& GetAmbient() const;

	///  ݻ
	void SetDiffuse( const NiColor& color );
	const NiColor& GetDiffuse() const;

	/// ߻
	void SetEmissive( const NiColor& color );
	const NiColor& GetEmissive() const;

	///  
	void SetVisibleLevel( unsigned int level );
	unsigned int GetVisibleLevel() const;

	///  
	void SetOccludeLevel( unsigned int );
	unsigned int GetOccludeLevel() const;

	/// Ȱ 
	void SetFogApplied( bool fogApplied );
	bool GetFogApplied() const;

	/// ﰢ 
	unsigned int GetNumVerts() const;

	/// ִϸ̼  
	bool IsAnimated() const;

#ifdef MAP_EDITOR
	void SetWirframe( bool set ) { mWireProp->SetWireframe( set ); }
#endif

protected:
	cStaticSceneNode( eSceneNodeType type = SCENENODE_STATIC );
	virtual ~cStaticSceneNode();

	/// 
	virtual bool Save( cFileSaver& saver );

	/// ʱȭ
	virtual bool Init( cStaticSceneNodeParam& param );

	/// Ʈѷ 
	/// ⺻  Ѵ.
	NiTimeController* GetTimeController( NiAVObject* obj );

	/// 
	void RestoreMaterial();

	///  
	unsigned int CalcVisibleLevel();

protected:
	/// ִ Ʈѷ 
	cNifAnimationInfo* mNifAniInfo;

	///  
	unsigned int mNumVerts;

	/// Ȱ
	bool mFogApplied;

	/// 
	bool mMaterialApplied;
	cMaterialData mMaterial;

	///  
	unsigned int mVisibleLevel;

	///  
	unsigned int mOccludeLevel;

	/// ī޶ ɸ 
	bool mPickedByCamera;

#ifdef MAP_EDITOR
	NiWireframeProperty* mWireProp;
#endif
};

inline
unsigned int cStaticSceneNode::GetNumVerts() const
{
	return mNumVerts;
}

inline
const cMaterialData& cStaticSceneNode::GetMaterial() const
{
	return mMaterial;
}

inline
const NiColor& cStaticSceneNode::GetAmbient() const
{
	return mMaterial.mAmbient;
}

inline
const NiColor& cStaticSceneNode::GetDiffuse() const
{
	return mMaterial.mDiffuse;
}

inline
const NiColor& cStaticSceneNode::GetEmissive() const
{
	return mMaterial.mEmissive;
}

inline
unsigned int cStaticSceneNode::GetVisibleLevel() const
{
	return mVisibleLevel;
}

inline
unsigned int cStaticSceneNode::GetOccludeLevel() const
{
	return mOccludeLevel;
}

inline
bool cStaticSceneNode::GetFogApplied() const
{
	return mFogApplied;
}

inline
bool cStaticSceneNode::GetMaterialApplied() const
{
	return mMaterialApplied;
}
