/* ==========================================================================
*    : ̼
*    : 2006.12.04
*      : 
* ǻ : 
*===========================================================================*/
#pragma once

#include "Shader.h"

class cRay;
class cSphere;
class cBox;
class cSceneNode;
class cTerrainBranchNode;
class cTerrainLeafNode;
#ifdef MAP_EDITOR
class cTerrainBuildingInfo;
class cTerrainPaintingInfo;
class cTerrainDetailingInfo;
#endif /// MAP_EDITOR

enum eTerrainViewMode;

///  
const unsigned int TERRAIN_DEFAULT_RESOLUTION = 512;
const unsigned int TERRAIN_BUFF_CELL_COUNT = 128;
const unsigned int TERRAIN_BUFF_LINE_COUNT = TERRAIN_BUFF_CELL_COUNT + 1;
const unsigned int TERRAIN_BUFF_VERT_COUNT = TERRAIN_BUFF_LINE_COUNT * TERRAIN_BUFF_LINE_COUNT;
const unsigned int TERRAIN_LEAF_CELL_COUNT = 8;
const unsigned int TERRAIN_LEAF_LINE_COUNT = TERRAIN_LEAF_CELL_COUNT + 1;
const unsigned int TERRAIN_LEAF_LINE_COUNT_X2 = TERRAIN_LEAF_LINE_COUNT * 2;
const unsigned int TERRAIN_LEAF_VERT_COUNT = TERRAIN_LEAF_LINE_COUNT * TERRAIN_LEAF_LINE_COUNT;

///  ؽó 
const unsigned int TERRAIN_TEXTURE_COUNT = 21;
const unsigned int TERRAIN_TEXTURE_COUNT_VER2 = 16;

///  ε  ڵ
const int TERRAIN_LOAD_ERROR_OPEN = -1;
const int TERRAIN_LOAD_ERROR_FILE_HEADER = -2;
const int TERRAIN_LOAD_ERROR_FILE_TYPE = -3;
const int TERRAIN_LOAD_ERROR_FILE_VERSION = -4;
const int TERRAIN_LOAD_ERROR_GRID_SIZE = -5;
const int TERRAIN_LOAD_ERROR_TEXTURE_NAME = -6;
const int TERRAIN_LOAD_ERROR_TEXTURE = -7;
const int TERRAIN_LOAD_ERROR_NODE = -8;

///  Lod
enum eTerrainLod
{
	TERRAIN_LOD_0 = 0,
	TERRAIN_LOD_1,
	TERRAIN_LOD_2,
	TERRAIN_LOD_COUNT
};

///   
#pragma pack( push, 1 )
class cTerrainFileHeader
{
public:
	/// ĺ ڵ
	char mCode[12];

	/// 
	unsigned int mVersion;

	/// ׸ ũ ( )
	unsigned int mCellCount;

	///   
	float mMetersPerVertex;

	/// ʹ  
	unsigned int mUnitsPerMeter;

	/// ؽó 
	unsigned int mNumTextures;
};
#pragma pack( pop )

///  ؽó
class cTerrainTexture
{
	friend class cTerrain;
	friend class cTerrainLeafNode;

public:
	cTerrainTexture( unsigned int index, const cString& pathName, LPDIRECT3DTEXTURE9 tex );
	~cTerrainTexture();

	void Grab();
	void Drop();

	const char* GetFileName() const;
	CBitmap* GetBitmap();
	unsigned int GetWidth() const;
	unsigned int GetHeight() const;
	unsigned int GetIndexByTerrain() const;

	///  
	/// : x y [0, 1]  Ѵ.
	bool GetColor( float* red, float* green, float* blue, float x, float y );

private:
	///  ̸
	cString mFileName;

	/// ̹ Ÿ
	cTargaImage mImageData;

	/// Ʈ
	CBitmap mBitmap;

	///     ε
	unsigned int mIndexByTerrain;

	///  īƮ
	unsigned int mRefCount;

private:
	/// DX9
	LPDIRECT3DTEXTURE9 mTexture;
};

inline
const char* cTerrainTexture::GetFileName() const
{
	return mFileName.Cstr();
}

inline
CBitmap* cTerrainTexture::GetBitmap()
{
	return &mBitmap;
}

inline
unsigned int cTerrainTexture::GetWidth() const
{
	return mImageData.GetWidth();
}

inline
unsigned int cTerrainTexture::GetHeight() const
{
	return mImageData.GetHeight();
}

inline
unsigned int cTerrainTexture::GetIndexByTerrain() const
{
	return mIndexByTerrain;
}

///  
class cTerrainBuffer
{
	friend class cTerrain;
	friend class cTerrainLeafNode;

public:
	cTerrainBuffer();
	~cTerrainBuffer();

	bool Init( cTerrain* terrain, unsigned int xi, unsigned int yi );

protected:
	void UpdatePosCoord( cTerrain* terrain, unsigned int xstart, unsigned int ystart, unsigned int count );
	void UpdateColor( cTerrain* terrain, unsigned int xstart, unsigned int ystart, unsigned int count );
	void UpdateAlpha( cTerrain* terrain, unsigned int xstart, unsigned int ystart, unsigned int count );

private:
	unsigned int mXIndex;
	unsigned int mYIndex;

	/// DX9
	LPDIRECT3DVERTEXBUFFER9 mPosCoordBuffer;
	LPDIRECT3DVERTEXBUFFER9 mNormalBuffer;
	LPDIRECT3DVERTEXBUFFER9 mColorBuffer;
	LPDIRECT3DVERTEXBUFFER9 mAlphaBuffer;
};

/// 
class cTerrain
{
	static cTerrain* mSingleton;
	friend class cTerrainLeafNode;
	friend class cTerrainTexture;
	friend class cTerrainBuffer;
#ifdef MAP_EDITOR
	friend class cTerrainBuilding;
#endif

public:
	cTerrain();
	~cTerrain();

	/// 
	void Clear();

	/// ʱȭ
	void Init( unsigned int cellCount, float metersPerVertex = 1.0f, unsigned int unitsPerMeter = 100 );
	bool IsInited() const;

	/// ε

#ifdef MAP_EDITOR
	int Load( const cString& pathName );
	bool LoadPaintAlpha( const cString& pathName, unsigned int numVerts );
#else
	int Load( const cString& pathName, unsigned int mapIndex );
#endif

	/// ó
	void Process( bool testing );

	/// 
	void Render();

	/// ؽó
	bool LoadTexture( const cString& pathName );
	bool LoadTexture( unsigned int index, const cString& pathName );
	void UnLoadTexture( unsigned int index );
	cTerrainTexture* GetTexture( int index );

	/// ŷ
	bool Pick( NiPoint3* pos, int mouseX, int mouseY );
	bool Pick( NiPoint3* pos, const cRay& ray );

	///  浹ϴ  
	/// ٿ ڽ ˻Ѵ.
	bool CollideSphere( tArray<cTerrainLeafNode*>* pickedArray, const cSphere& sphere );

#ifdef MAP_EDITOR
	///  
	void SetViewMode( eTerrainViewMode viewMode );

	/// 
	bool Save( const cString& pathName );
	bool SavePaintAlpha( const cString& pathName );

	/// ̸
	void ClearHeightMap();
	bool ImportHeightMap( const cString& pathName, float scale );
	bool ImportHeightMap( const cString& pathName );
	bool ExportHeightMap( const cString& pathName );

	/// 
	void ClearColorMap();
	bool ImportColorMap( const cString& pathName );
	bool ExportColorMap( const cString& pathName );

	/// ĸ
	void ClearAlphaMap();
	bool ImportAlphaMap( const cString& pathName );
	bool ExportAlphaMap( const cString& pathName );

	/// 
	void AdjustHeight( float scale );

	/// 
	void SyncAllToNaviMesh();

	/// 
	bool Raise( const NiPoint3& pos, float innerRadius, float outerRadius, float strength );
	bool Lower( const NiPoint3& pos, float innerRadius, float outerRadius, float strength );
	bool Flatten( const NiPoint3& pos, float innerRadius, float outerRadius, float strength );
	bool Smooth( const NiPoint3& pos, float outerRadius, float ratio );
	bool SyncToNaviMesh( const NiPoint3& pos, float innerRadius, float outerRadius );
	bool SyncToPickHeight( const NiPoint3& pos, float innerRadius, float outerRadius, float z );

	/// ĥ
	bool Color( const NiPoint3& pos, float innerRadius, float outerRadius, const NiColor& color );
	bool Brush( const NiPoint3& pos, float innerRadius, float outerRadius, const NiColor& color, float opacity );
	bool Lighter( const NiPoint3& pos, float innerRadius, float outerRadius );
	bool Darker( const NiPoint3& pos, float innerRadius, float outerRadius );
	bool BlurColor( const NiPoint3& pos, float outerRadius, float ratio );

	/// 
	void SetDetailTextures( cTerrainLeafNode* node, unsigned int index0, unsigned int index1, unsigned int index2 );
	void SetDetailTexturesToAll( unsigned int index0, unsigned int index1, unsigned int index2 );
	bool PaintAlpha( const NiPoint3& pos, float innerRadius, float outerRadius, const NiPoint3& alpha, bool applyDetailTex, unsigned int texIndex0, unsigned int texIndex1, unsigned int texIndex2 );
	bool BlurAlpha( const NiPoint3& pos, float outerRadius, float ratio );
	bool SharpenAlpha( const NiPoint3& pos, float outerRadius, float ratio );

	///  
	bool IsModified() const;
#endif /// MAP_EDITOR

	/// Level of Detail
	void SetLodEnabled( bool enabled );

	/// ֺ
	void SetAmbientLightAmbient( const NiColor& color );
	void SetAmbientLightDiffuse( const NiColor& color );
	void SetAmbientLightDimmer( float dimmer );

	/// Ȱ
	void SetFog( bool enabled, const NiColor& color, float depth );
	void SetFogColor( const NiColor& color );
	void SetFogDepth( float depth );

	/// ֺ
	NiAmbientLight* GetAmbientLight() const;

	/// ̰
	float GetHeight( float x, float y ) const;
	const float* GetHeights() const;

	/// ׸ ũ
	unsigned int GetCellCount() const;
	unsigned int GetLeafCellCount() const;

	/// 
	float GetMetersPerVertex() const;
	unsigned int GetUnitsPerMeter() const;
	float GetUnitsPerVertex() const;
	float GetUnitsPerLeafNode() const;

	/// ش ġ  
	cTerrainLeafNode* GetLeafNode( float x, float y ) const;

	/// ش ġ 
	bool GetColor( NiColor* color, const NiPoint3& pos ) const;

	///   迭
	tArray<cTerrainLeafNode*>& GetLeafNodeArray();

	/// ̴   
	unsigned int GetNumVisibleNodes() const;

	///  ü δ  
	const cBox& GetBoundBox() const;

	///  ̰
	/// ε    false Ѵ.
	bool GetHeight( float* height, unsigned int xi, unsigned int yi );

	///
	NiFogProperty* GetFogProperty() const;

protected:
#ifdef MAP_EDITOR
	/// 
	/// Undo, Redo ʿ  Ѵ.
	bool BackupBuilding( cTerrainBuildingInfo* info, unsigned int xbegin, unsigned int ybegin, unsigned int xend, unsigned int yend, const NiPoint3& pos, float outerRadius );
	bool BackupPainting( cTerrainPaintingInfo* info, unsigned int xbegin, unsigned int ybegin, unsigned int xend, unsigned int yend, const NiPoint3& pos, float outerRadius );
	bool BackupDetailing( cTerrainDetailingInfo* info, unsigned int xbegin, unsigned int ybegin, unsigned int xend, unsigned int yend, const NiPoint3& pos, float outerRadius );

	/// 
	void UpdateBuilding( cTerrainBuildingInfo* info, unsigned int xbegin, unsigned int ybegin, unsigned int xend, unsigned int yend, const NiPoint3& pos, float outerRadius );
	void UpdatePainting( cTerrainPaintingInfo* info, unsigned int xbegin, unsigned int ybegin, unsigned int xend, unsigned int yend, const NiPoint3& pos, float outerRadius );
	void UpdateDetailing( cTerrainDetailingInfo* info, unsigned int xbegin, unsigned int ybegin, unsigned int xend, unsigned int yend, const NiPoint3& pos, float outerRadius );
#endif /// MAP_EDITOR

	/// ׸ ũ⸦ ˻
	bool CheckCellCount( unsigned int cellCount );

	/// 
	void Render0( LPDIRECT3DDEVICE9 device, const D3DXMATRIX& worldViewProj );
	void Render1( LPDIRECT3DDEVICE9 device, const D3DXMATRIX& worldViewProj );

	/// ؽó
	void AddTexture( unsigned int index, cTerrainTexture* tex );
	void RemoveTexture( unsigned int index );

	/// 
	cTerrainBuffer* GetBuffer( unsigned int xi, unsigned int yi );

	///   
	bool CalcRange( unsigned int* xbegin, unsigned int* ybegin, unsigned int* xend, unsigned int* yend, const NiPoint3& pos, float outerRadius );
	bool CalcRangeTight( unsigned int* xbegin, unsigned int* ybegin, unsigned int* xend, unsigned int* yend, const NiPoint3& pos, float outerRadius );

	/// ش ġ  带 
	void SetLeafNode( unsigned int xi, unsigned int yi, cTerrainLeafNode* node );

	/// ̰
	void SetHeight( unsigned int xi, unsigned int yi, float height );
	float GetHeightFast( unsigned int xi, unsigned int yi ) const;

	/// 
	void ComputeNormals( unsigned int xbegin, unsigned int ybegin, unsigned int xend, unsigned int yend );
	const NiPoint3& GetNormalFast( unsigned int xi, unsigned int yi ) const;

	/// 
	void SetColor( unsigned int xi, unsigned int yi, const NiColor& color );
	bool GetColor( NiColor* color, unsigned int xi, unsigned int yi );
	const NiColor& GetColorFast( unsigned int xi, unsigned int yi ) const;

	/// İ
	void SetAlpha( unsigned int xi, unsigned int yi, const NiPoint3& alpha );
	bool GetAlpha( NiPoint3* alpha, unsigned int xi, unsigned int yi );
	const NiPoint3& GetAlphaFast( unsigned int xi, unsigned int yi ) const;

	void SetPaintAlpha( unsigned int xi, unsigned int yi, const NiPoint3& alpha );
	bool GetPaintAlpha( NiPoint3* alpha, unsigned int xi, unsigned int yi );
	const NiPoint3& GetPaintAlphaFast( unsigned int xi, unsigned int yi ) const;

public:
	/// ü 
	static cTerrain* GetSingleton();

protected:
	/// ʱȭ 
	bool mInited;

	/// ׸ ũ
	unsigned int mCellCount;
	unsigned int mLineCount;

	///   ( 1 )
	float mMetersPerVertex;

	/// ʹ  ( 100 )
	unsigned int mUnitsPerMeter;

	///  
	float mUnitsPerVertex;

	///   
	float mUnitsPerLeafNode;

	/// Ʈ 
	cTerrainBranchNode* mRootNode;

	///   迭
	typedef tArray<cTerrainLeafNode*> cLeafNodeArray;
	cLeafNodeArray mNodeArray;

	///  迭
	cLeafNodeArray mVisibleArray;

	/// ũ 迭
	//cLeafNodeArray mCrackedArray;

	///  迭
	float* mHeights;

	///  迭
	NiPoint3* mNormals;

	///  迭
	NiColor* mColors;

	///  迭
	NiPoint3* mAlphas;
	NiPoint3* mPaintAlphas;

	/// ֺ
	NiAmbientLightPtr mAmbientLight;

	///   Ӽ
	NiFogPropertyPtr mFogProp;

	/// Level of detail
	bool mLodEnabled;
	float mSquaredDistanceLod[TERRAIN_LOD_COUNT];

	/// ؽó 迭
	cTerrainTexture* mTextures[TERRAIN_TEXTURE_COUNT];
	unsigned int mNumTextures;

	/// ؽó 
	typedef tHashMap<cString, LPDIRECT3DTEXTURE9> cTextureMap;
	cTextureMap mTextureMap;

	/// ̴
	cTerrainShader mShader0;
	cTerrainShader mShader1;

	/// 
	cTerrainBuffer** mBuffer;

	/// DX9
	LPDIRECT3DVERTEXDECLARATION9 mVertexDeclaration0;
	LPDIRECT3DVERTEXDECLARATION9 mVertexDeclaration1;
	LPDIRECT3DINDEXBUFFER9 mIndexBuffer;

#ifdef MAP_EDITOR
	///  
	eTerrainViewMode mViewMode;

	///  
	bool mModified;
#endif
};

inline
bool cTerrain::IsInited() const
{
	return mInited;
}

inline
void cTerrain::SetLodEnabled( bool enabled )
{
	mLodEnabled = enabled;
}

inline
NiAmbientLight* cTerrain::GetAmbientLight() const
{
	return mAmbientLight;
}

inline
cTerrainTexture* cTerrain::GetTexture( int i )
{
	if( i < 0 || i >= TERRAIN_TEXTURE_COUNT )
	{
		assert( 0 && "index out of range" );
		return 0;
	}
	else
		return mTextures[i];
}

inline
cTerrainBuffer* cTerrain::GetBuffer( unsigned int xi, unsigned int yi )
{
	return &(mBuffer[yi / TERRAIN_BUFF_CELL_COUNT][xi / TERRAIN_BUFF_CELL_COUNT]);
}

inline
float cTerrain::GetHeightFast( unsigned int xi, unsigned int yi ) const
{
	return mHeights[yi * mLineCount + xi];
}

inline
const NiPoint3& cTerrain::GetNormalFast( unsigned int xi, unsigned int yi ) const
{
	return mNormals[yi * mLineCount + xi];
}

inline
void cTerrain::SetColor( unsigned int xi, unsigned int yi, const NiColor& color )
{
	mColors[yi * mLineCount + xi] = color;
}

inline
const NiColor& cTerrain::GetColorFast( unsigned int xi, unsigned int yi ) const
{
	return mColors[yi * mLineCount + xi];
}

inline
void cTerrain::SetAlpha( unsigned int xi, unsigned int yi, const NiPoint3& alpha )
{
	mAlphas[yi * mLineCount + xi] = alpha;
}

inline
const NiPoint3& cTerrain::GetAlphaFast( unsigned int xi, unsigned int yi ) const
{
	return mAlphas[yi * mLineCount + xi];
}

inline
const NiPoint3& cTerrain::GetPaintAlphaFast( unsigned int xi, unsigned int yi ) const
{
	return mPaintAlphas[yi * mLineCount + xi];
}

inline 
void cTerrain::SetPaintAlpha( unsigned int xi, unsigned int yi, const NiPoint3& alpha )
{
	mPaintAlphas[yi * mLineCount + xi] = alpha;
}

inline
const float* cTerrain::GetHeights() const
{
	return mHeights;
}

inline
unsigned int cTerrain::GetCellCount() const
{
	return mCellCount;
}

inline
float cTerrain::GetMetersPerVertex() const
{
	return mMetersPerVertex;
}

inline
unsigned int cTerrain::GetUnitsPerMeter() const
{
	return mUnitsPerMeter;
}

inline
float cTerrain::GetUnitsPerVertex() const
{
	return mUnitsPerVertex;
}

inline
float cTerrain::GetUnitsPerLeafNode() const
{
	return mUnitsPerLeafNode;
}

inline
tArray<cTerrainLeafNode*>& cTerrain::GetLeafNodeArray()
{
	return mNodeArray;
}

inline
unsigned int cTerrain::GetNumVisibleNodes() const
{
	return mVisibleArray.GetSize();
}

inline
NiFogProperty* cTerrain::GetFogProperty() const
{
	return mFogProp;
}

#ifdef MAP_EDITOR
inline
bool cTerrain::IsModified() const
{
	return mModified;
}
#endif

inline
cTerrain* cTerrain::GetSingleton()
{
	return mSingleton;
}

#define TERRAIN	cTerrain::GetSingleton()
