/* ==========================================================================
*    : ̼
*    : 2006.12.04
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

#include "Box.h"
#include "Terrain.h"

class cRay;
class cSceneNode;
class cLightSceneNode;
class cTerrainBranchNode;
class cTerrainLeafNode;
class cTerrainTexture;
class cTerrainBuffer;
#ifdef MAP_EDITOR
class cTerrainNodeBuildingInfo;
class cTerrainNodeBuilding;
class cTerrainNodePaintingInfo;
class cTerrainNodePainting;
class cTerrainNodeDetailingInfo;
class cTerrainNodeDetailing;
#endif

enum eTerrainViewMode;

///  
class cTerrainNode
{
	friend class cTerrain;

public:
	cTerrainNode( cTerrainBranchNode* parent, unsigned int xi, unsigned int yi, unsigned int cellCount );
	virtual ~cTerrainNode();

	/// ε
	virtual bool Load( cFileLoader& loader ) = 0;

#ifdef MAP_EDITOR
	/// 
	virtual bool Save( cFileSaver& saver ) = 0;
#endif

	/// ȭ
	virtual void SyncHeight() = 0;
	virtual void SyncAlpha() = 0;
	virtual void SyncPaintAlpha() = 0;
	virtual void SyncColor() = 0;

	/// ø
	virtual void Cull() = 0;
	virtual void AddToVisibleArray() = 0;

	/// 浹 ˻
	virtual bool CollideRay() = 0;

	///  浹ϴ  
	/// ٿ ڽ ˻Ѵ.
	virtual bool CollideSphere() = 0;

	///  
	const cBox& GetBoundBox() const;

	/// 
	const NiPoint3& GetCenter() const;

protected:
	///  ڸ 
	virtual void UpdateBoundUpward() = 0;

public:
	/// θ
	cTerrainBranchNode* mParent;

	/// 
	cBox mBoundBox;
	NiPoint3 mCenter;
	float mRadius;

protected:
	/// ø
	static NiFrustumPlanes* mFrustum;
	static tArray<cTerrainLeafNode*>* mVisibleArray;

	/// 浹 ˻
	static const cRay* mRay;
	static float* mDistance;
	static NiPoint3* mContact;
	static const cSphere* mSphere;
	static tArray<cTerrainLeafNode*>* mPickedArray;
};

inline
const cBox& cTerrainNode::GetBoundBox() const
{
	return mBoundBox;
}

inline
const NiPoint3& cTerrainNode::GetCenter() const
{
	return mCenter;
}

///   
class cTerrainBranchNode : public cTerrainNode
{
	friend class cTerrainLeafNode;

public:
	cTerrainBranchNode( cTerrainBranchNode* parent, unsigned int xi, unsigned int yi, unsigned int cellCount );
	~cTerrainBranchNode();

	/// ε
	bool Load( cFileLoader& loader );

#ifdef MAP_EDITOR
	/// 
	bool Save( cFileSaver& saver );
#endif

	/// ȭ
	void SyncHeight();
	void SyncAlpha();
	void SyncPaintAlpha();
	void SyncColor();

	/// ø
	void Cull();
	void AddToVisibleArray();

	/// 浹 ˻
	bool CollideRay();
	bool CollideSphere();

protected:
	///  ڸ 
	void UpdateBoundUpward();

public:
	/// ڽ 迭
	cTerrainNode* mChild[4];
};

///   
class cTerrainLeafNode : public cTerrainNode
{
	friend class cTerrain;
	friend class cTerrainBranchNode;
	friend class cTerrainNodeCompareForRendering;
	friend class cLightSceneNode;
#ifdef MAP_EDITOR
	friend class cTerrainNodeBuilding;
	friend class cTerrainNodePainting;
	friend class cTerrainNodeDetailing;
#endif

public:
	cTerrainLeafNode( cTerrainBranchNode* parent, unsigned int xi, unsigned int yi, unsigned int cellCount );
	~cTerrainLeafNode();

	/// 
	void Clear();

	/// ε
	bool Load( cFileLoader& loader );

#ifdef MAP_EDITOR
	/// 
	bool Save( cFileSaver& saver );
#endif

	/// ȭ
	void SyncHeight();
	void SyncAlpha();
	void SyncPaintAlpha();
	void SyncColor();

	/// ø
	void Cull();

	///  
	void SetVisible( bool visible );

	///  迭 ߰
	void AddToVisibleArray();

	/// 浹 ˻
	bool CollideRay();
	bool CollideSphere();

	/// 
	void SetLight( cLightSceneNode* light, unsigned int indexByLight );
	const cLightSceneNode* GetLight() const;

#ifdef MAP_EDITOR
	/// ø
	bool Raise( const NiPoint3& pos, float innerRadius, float outerRadius, float maxValue );

	/// 
	bool Lower( const NiPoint3& pos, float innerRadius, float outerRadius, float maxValue );

	/// ϰ 
	bool Flatten( const NiPoint3& pos, float innerRadius, float outerRadius, float maxValue );

	/// ε巴 
	/// ratio [0.1, 1]    Ѵ.
	bool Smooth( const NiPoint3& pos, float outerRadius, float ratio );
#endif /// MAP_EDITOR

	/// ׺޽ÿ 
	bool SyncToNaviMesh( const NiPoint3& pos, float innerRadius, float outerRadius );

	/// ŷ ̿ 
	bool SyncToPickHeight( const NiPoint3& pos, float innerRadius, float outerRadius, float z );

#ifdef MAP_EDITOR
	/// 
	bool PaintAlpha( const NiPoint3& pos, float innerRadius, float outerRadius, const NiPoint3& alpha );
	bool BlurAlpha( const NiPoint3& pos, float outerRadius, float ratio );
	bool SharpenAlpha( const NiPoint3& pos, float outerRadius, float ratio );

	/// ĥ
	bool Color( const NiPoint3& pos, float innerRadius, float outerRadius, const NiColor& color );
	bool Brush( const NiPoint3& pos, float innerRadius, float outerRadius, const NiColor& color, float opacity );
	bool Lighter( const NiPoint3& pos, float innerRadius, float outerRadius );
	bool Darker( const NiPoint3& pos, float innerRadius, float outerRadius );
	bool BlurColor( const NiPoint3& pos, float outerRadius, float ratio );
#endif /// MAP_EDITOR

	/// ؽó
	unsigned int GetTextureIndex0() const;
	unsigned int GetTextureIndex1() const;
	unsigned int GetTextureIndex2() const;
	unsigned int GetTextureValue0() const;
	unsigned int GetTextureValue1() const;
	LPDIRECT3DTEXTURE9 GetD3DTexture0() const;
	LPDIRECT3DTEXTURE9 GetD3DTexture1() const;
	LPDIRECT3DTEXTURE9 GetD3DTexture2() const;

private:
	///  ڸ 
	void UpdateBoundUpward();

	///   
	void UpdatePosCoords();
	void UpdateColors();
	void UpdateAlphas();

#ifdef MAP_EDITOR
	/// 
	/// Undo, Redo ʿ  Ѵ.
	bool BackupBuilding( cTerrainNodeBuildingInfo* info, const NiPoint3& pos, float outerRadius );
	bool BackupPainting( cTerrainNodePaintingInfo* info, const NiPoint3& pos, float outerRadius );
	bool BackupDetailing( cTerrainNodeDetailingInfo* info, const NiPoint3& pos, float outerRadius );

	///  ȭ  
	/// ȭ    ũ Ѵ.
	void UpdateBuilding( cTerrainNodeBuildingInfo* info, const NiPoint3& pos, float outerRadius );
	void UpdatePainting( cTerrainNodePaintingInfo* info, const NiPoint3& pos, float outerRadius );
	void UpdateDetailing( cTerrainNodeDetailingInfo* info, const NiPoint3& pos, float outerRadius );

	/// Undo, Redo
	void Undo( const cTerrainNodeBuilding& doing );
	void Undo( const cTerrainNodePainting& doing );
	void Undo( const cTerrainNodeDetailing& doing );
	void Redo( const cTerrainNodeBuilding& doing );
	void Redo( const cTerrainNodePainting& doing );
	void Redo( const cTerrainNodeDetailing& doing );
#endif /// MAP_EDITOR

	///   
	bool CalcRange( unsigned int* xbegin, unsigned int* ybegin, unsigned int* xend, unsigned int* yend, const NiPoint3& pos, float outerRadius );

	/// ؽó
	void SetTextures( cTerrainTexture* tex0, cTerrainTexture* tex1, cTerrainTexture* tex2 );
	void SetTexture0( cTerrainTexture* tex );
	void SetTexture1( cTerrainTexture* tex );
	void SetTexture2( cTerrainTexture* tex );
	void CalcTextureValue();

private:
	/// ǥ ( ׸  ġ)
	unsigned int mXIndex;
	unsigned int mYIndex;

	///  
	bool mVisible;

	/// 
	cTerrainBuffer* mBuffer;

	///  ؽó
	cTerrainTexture* mTexture0;
	cTerrainTexture* mTexture1;
	cTerrainTexture* mTexture2;
	unsigned int mTextureValue0;
	unsigned int mTextureValue1;

	/// 
	cLightSceneNode* mLight;
	unsigned int mIndexByLight;

	///  迭
	float* mHeights;

	///  迭
	NiPoint3* mAlphas;
	NiPoint3* mPaintAlphas;

	///  迭
	NiColor* mColors;

	/// Level of detail
	int mLod;
	//unsigned int mCrack;

private:
	/// 
	static unsigned int mVersion;

	///   ׸ ũ
	static unsigned int mCellCount[TERRAIN_LOD_COUNT];
	static unsigned int mLineCount[TERRAIN_LOD_COUNT];
};

inline
void cTerrainLeafNode::SetVisible( bool visible )
{
	mVisible = visible;
}

inline
const cLightSceneNode* cTerrainLeafNode::GetLight() const
{
	return mLight;
}

inline
unsigned int cTerrainLeafNode::GetTextureIndex0() const
{
	if( mTexture0 == 0 )
	{
		assert( 0 );
		return 0;
	}
	return mTexture0->mIndexByTerrain;
}

inline
unsigned int cTerrainLeafNode::GetTextureIndex1() const
{
	if( mTexture1 == 0 )
	{
		assert( 0 );
		return 0;
	}
	return mTexture1->mIndexByTerrain;
}

inline
unsigned int cTerrainLeafNode::GetTextureIndex2() const
{
	if( mTexture2 == 0 )
	{
		assert( 0 );
		return 0;
	}
	return mTexture2->mIndexByTerrain;
}

inline
unsigned int cTerrainLeafNode::GetTextureValue0() const
{
	return mTextureValue0;
}

inline
unsigned int cTerrainLeafNode::GetTextureValue1() const
{
	return mTextureValue1;
}

inline
LPDIRECT3DTEXTURE9 cTerrainLeafNode::GetD3DTexture0() const
{
	return mTexture0 ? mTexture0->mTexture : 0;
}

inline
LPDIRECT3DTEXTURE9 cTerrainLeafNode::GetD3DTexture1() const
{
	return mTexture1 ? mTexture1->mTexture : 0;
}

inline
LPDIRECT3DTEXTURE9 cTerrainLeafNode::GetD3DTexture2() const
{
	return mTexture2 ? mTexture2->mTexture : 0;
}

///    Լ
class cTerrainNodeCompareForRendering
{
public:
	bool operator () ( const cTerrainLeafNode* left, const cTerrainLeafNode* right ) const
	{
		cTerrainBuffer* lbuff = left->mBuffer;
		cTerrainBuffer* rbuff = right->mBuffer;

		if( lbuff == rbuff )
		{
			unsigned int ltex = left->mTextureValue0;
			unsigned int rtex = right->mTextureValue0;

			if( ltex == rtex )
			{
				ltex = left->mTextureValue1;
				rtex = right->mTextureValue1;

				if( ltex == rtex )
					return left->mLod < right->mLod;
				return ltex < rtex;
			}
			return ltex < rtex;
		}
		return lbuff < rbuff;
	};
};
