#include "stdafx.h"

#ifdef MAP_EDITOR
#include "Terrain.h"
#include "TerrainNode.h"
#include "../Doing/DoingManager.h"
#include "../Doing/TerrainDetailing.h"

bool cTerrain::BackupDetailing( cTerrainDetailingInfo* info, unsigned int xbegin, unsigned int ybegin, unsigned int xend, unsigned int yend, const NiPoint3& pos, float outerRadius )
{
	assert( info );

	cTerrainNodeDetailingInfo* n = &(info->mNodeArray[0]);
	unsigned int nodeCount = mCellCount / cTerrainLeafNode::mCellCount[0];
	bool ret = false;

	for( unsigned int yi = ybegin, i = nodeCount * ybegin; yi < yend; ++yi, i += nodeCount )
	{
		for( unsigned int xi = xbegin; xi < xend; ++xi, ++n )
		{
			if( mNodeArray[i + xi]->BackupDetailing( n, pos, outerRadius ) )
			{
				ret = true;
			}
		}
	}
	return ret;
}

void cTerrain::UpdateDetailing( cTerrainDetailingInfo* info, unsigned int xbegin, unsigned int ybegin, unsigned int xend, unsigned int yend, const NiPoint3& pos, float outerRadius )
{
	assert( info );

	cTerrainNodeDetailingInfo* n = &(info->mNodeArray[0]);
	unsigned int nodeCount = mCellCount / cTerrainLeafNode::mCellCount[0];

	for( unsigned int yi = ybegin, i = nodeCount * ybegin; yi < yend; ++yi, i += nodeCount )
	{
		for( unsigned int xi = xbegin; xi < xend; ++xi, ++n )
		{
			mNodeArray[i + xi]->UpdateDetailing( n, pos, outerRadius );
		}
	}
}

bool cTerrain::PaintAlpha( const NiPoint3& pos, float innerRadius, float outerRadius, const NiPoint3& alpha, bool applyDetailTex, unsigned int texIndex0, unsigned int texIndex1, unsigned int texIndex2 )
{
	///  
	unsigned int xbegin, ybegin, xend, yend;
	if( CalcRangeTight( &xbegin, &ybegin, &xend, &yend, pos, outerRadius ) == false )
		return false;

	///   
	cTerrainDetailingInfo info;
	info.mNodeArray.Resize( (yend - ybegin) * (xend - xbegin) );

	///     
	///   尡 ϳ  ٷ Ѵ.
	if( BackupDetailing( &info, xbegin, ybegin, xend, yend, pos, outerRadius ) == false )
	{
		return false;
	}

	///    鿡  
	unsigned int nodeCount = mCellCount / cTerrainLeafNode::mCellCount[0];

	for( unsigned int yi = ybegin, i = nodeCount * ybegin; yi < yend; ++yi, i += nodeCount )
	{
		for( unsigned int xi = xbegin; xi < xend; ++xi )
		{
			cTerrainLeafNode* n = mNodeArray[xi+i];
			if( applyDetailTex )
				SetDetailTextures( n, texIndex0, texIndex1, texIndex2 );
			n->PaintAlpha( pos, innerRadius, outerRadius, alpha );
		}
	}

	///     
	UpdateDetailing( &info, xbegin, ybegin, xend, yend, pos, outerRadius );

	///   ߰
	DOINGMAN->PushTerrainDetailing( info );
	mModified = true;
	return true;
}

bool cTerrain::SharpenAlpha( const NiPoint3& pos, float outerRadius, float ratio )
{
	///  
	unsigned int xbegin, ybegin, xend, yend;
	if( CalcRange( &xbegin, &ybegin, &xend, &yend, pos, outerRadius ) == false )
		return false;

	///   
	cTerrainDetailingInfo info;
	info.mNodeArray.Resize( (yend - ybegin) * (xend - xbegin) );

	///     
	///   尡 ϳ  ٷ Ѵ.
	if( BackupDetailing( &info, xbegin, ybegin, xend, yend, pos, outerRadius ) == false )
	{
		return false;
	}

	///    鿡  
	unsigned int nodeCount = mCellCount / cTerrainLeafNode::mCellCount[0];

	for( unsigned int yi = ybegin, i = nodeCount * ybegin; yi < yend; ++yi, i += nodeCount )
	{
		for( unsigned int xi = xbegin; xi < xend; ++xi )
		{
			mNodeArray[i + xi]->SharpenAlpha( pos, outerRadius, ratio );
		}
	}

	///     
	UpdateDetailing( &info, xbegin, ybegin, xend, yend, pos, outerRadius );

	///   ߰
	DOINGMAN->PushTerrainDetailing( info );
	mModified = true;
	return true;
}

bool cTerrain::BlurAlpha( const NiPoint3& pos, float outerRadius, float ratio )
{
	///  
	unsigned int xbegin, ybegin, xend, yend;
	if( CalcRange( &xbegin, &ybegin, &xend, &yend, pos, outerRadius ) == false )
		return false;

	///   
	cTerrainDetailingInfo info;
	info.mNodeArray.Resize( (yend - ybegin) * (xend - xbegin) );

	///     
	///   尡 ϳ  ٷ Ѵ.
	if( BackupDetailing( &info, xbegin, ybegin, xend, yend, pos, outerRadius ) == false )
	{
		return false;
	}

	///    鿡  
	unsigned int nodeCount = mCellCount / cTerrainLeafNode::mCellCount[0];

	for( unsigned int yi = ybegin, i = nodeCount * ybegin; yi < yend; ++yi, i += nodeCount )
	{
		for( unsigned int xi = xbegin; xi < xend; ++xi )
		{
			mNodeArray[i + xi]->BlurAlpha( pos, outerRadius, ratio );
		}
	}

	///     
	UpdateDetailing( &info, xbegin, ybegin, xend, yend, pos, outerRadius );

	///   ߰
	DOINGMAN->PushTerrainDetailing( info );
	mModified = true;
	return true;
}
#endif /// MAP_EDITOR
