#include "stdafx.h"

#ifdef MAP_EDITOR
#include "Terrain.h"
#include "TerrainNode.h"
#include "../Doing/DoingManager.h"
#include "../Doing/TerrainPainting.h"

bool cTerrain::BackupPainting( cTerrainPaintingInfo* info, unsigned int xbegin, unsigned int ybegin, unsigned int xend, unsigned int yend, const NiPoint3& pos, float outerRadius )
{
	assert( info );

	cTerrainNodePaintingInfo* n = &(info->mNodeArray[0]);
	unsigned int nodeCount = mCellCount / cTerrainLeafNode::mCellCount[0];
	bool ret = false;

	for( unsigned int yi = ybegin, i = ybegin * nodeCount; yi < yend; ++yi, i += nodeCount )
	{
		for( unsigned int xi = xbegin; xi < xend; ++xi, ++n )
		{
			if( mNodeArray[i + xi]->BackupPainting( n, pos, outerRadius ) )
			{
				ret = true;
			}
		}
	}
	return ret;
}

void cTerrain::UpdatePainting( cTerrainPaintingInfo* info, unsigned int xbegin, unsigned int ybegin, unsigned int xend, unsigned int yend, const NiPoint3& pos, float outerRadius )
{
	assert( info );

	cTerrainNodePaintingInfo* n = &(info->mNodeArray[0]);
	unsigned int nodeCount = mCellCount / cTerrainLeafNode::mCellCount[0];

	for( unsigned int yi = ybegin, i = ybegin * nodeCount; yi < yend; ++yi, i += nodeCount )
	{
		for( unsigned int xi = xbegin; xi < xend; ++xi, ++n )
		{
			mNodeArray[i + xi]->UpdatePainting( n, pos, outerRadius );
		}
	}
}

bool cTerrain::Color( const NiPoint3& pos, float innerRadius, float outerRadius, const NiColor& color )
{
	///  
	unsigned int xbegin, ybegin, xend, yend;
	if( CalcRange( &xbegin, &ybegin, &xend, &yend, pos, outerRadius ) == false )
		return false;

	///   
	cTerrainPaintingInfo info;
	info.mNodeArray.Resize( (yend - ybegin) * (xend - xbegin) );

	///     
	///   尡 ϳ  ٷ Ѵ.
	if( BackupPainting( &info, xbegin, ybegin, xend, yend, pos, outerRadius ) == false )
	{
		return false;
	}

	///    鿡  
	unsigned int nodeCount = mCellCount / cTerrainLeafNode::mCellCount[0];

	for( unsigned int yi = ybegin, i = ybegin * nodeCount; yi < yend; ++yi, i += nodeCount )
	{
		for( unsigned int xi = xbegin; xi < xend; ++xi )
		{
			mNodeArray[i + xi]->Color( pos, innerRadius, outerRadius, color );
		}
	}

	///     
	UpdatePainting( &info, xbegin, ybegin, xend, yend, pos, outerRadius );

	///   ߰
	DOINGMAN->PushTerrainPainting( info );
	mModified = true;
	return true;
}

bool cTerrain::Brush( const NiPoint3& pos, float innerRadius, float outerRadius, const NiColor& color, float opacity )
{
	///  
	unsigned int xbegin, ybegin, xend, yend;
	if( CalcRange( &xbegin, &ybegin, &xend, &yend, pos, outerRadius ) == false )
		return false;

	///   
	cTerrainPaintingInfo info;
	info.mNodeArray.Resize( (yend - ybegin) * (xend - xbegin) );

	///     
	///   尡 ϳ  ٷ Ѵ.
	if( BackupPainting( &info, xbegin, ybegin, xend, yend, pos, outerRadius ) == false )
	{
		return false;
	}

	///    鿡  
	unsigned int nodeCount = mCellCount / cTerrainLeafNode::mCellCount[0];

	for( unsigned int yi = ybegin, i = ybegin * nodeCount; yi < yend; ++yi, i += nodeCount )
	{
		for( unsigned int xi = xbegin; xi < xend; ++xi )
		{
			mNodeArray[i + xi]->Brush( pos, innerRadius, outerRadius, color, opacity );
		}
	}

	///     
	UpdatePainting( &info, xbegin, ybegin, xend, yend, pos, outerRadius );

	///   ߰
	DOINGMAN->PushTerrainPainting( info );
	mModified = true;
	return true;
}

bool cTerrain::Lighter( const NiPoint3& pos, float innerRadius, float outerRadius )
{
	///  
	unsigned int xbegin, ybegin, xend, yend;
	if( CalcRange( &xbegin, &ybegin, &xend, &yend, pos, outerRadius ) == false )
		return false;

	///   
	cTerrainPaintingInfo info;
	info.mNodeArray.Resize( (yend - ybegin) * (xend - xbegin) );

	///     
	///   尡 ϳ  ٷ Ѵ.
	if( BackupPainting( &info, xbegin, ybegin, xend, yend, pos, outerRadius ) == false )
	{
		return false;
	}

	///    鿡  
	unsigned int nodeCount = mCellCount / cTerrainLeafNode::mCellCount[0];

	for( unsigned int yi = ybegin, i = ybegin * nodeCount; yi < yend; ++yi, i += nodeCount )
	{
		for( unsigned int xi = xbegin; xi < xend; ++xi )
		{
			mNodeArray[i + xi]->Lighter( pos, innerRadius, outerRadius );
		}
	}

	///     
	UpdatePainting( &info, xbegin, ybegin, xend, yend, pos, outerRadius );

	///   ߰
	DOINGMAN->PushTerrainPainting( info );
	mModified = true;
	return true;
}

bool cTerrain::Darker( const NiPoint3& pos, float innerRadius, float outerRadius )
{
	///  
	unsigned int xbegin, ybegin, xend, yend;
	if( CalcRange( &xbegin, &ybegin, &xend, &yend, pos, outerRadius ) == false )
		return false;

	///   
	cTerrainPaintingInfo info;
	info.mNodeArray.Resize( (yend - ybegin) * (xend - xbegin) );

	///     
	///   尡 ϳ  ٷ Ѵ.
	if( BackupPainting( &info, xbegin, ybegin, xend, yend, pos, outerRadius ) == false )
	{
		return false;
	}

	///    鿡  
	unsigned int nodeCount = mCellCount / cTerrainLeafNode::mCellCount[0];

	for( unsigned int yi = ybegin, i = ybegin * nodeCount; yi < yend; ++yi, i += nodeCount )
	{
		for( unsigned int xi = xbegin; xi < xend; ++xi )
		{
			mNodeArray[i + xi]->Darker( pos, innerRadius, outerRadius );
		}
	}

	///     
	UpdatePainting( &info, xbegin, ybegin, xend, yend, pos, outerRadius );

	///   ߰
	DOINGMAN->PushTerrainPainting( info );
	mModified = true;
	return true;
}

bool cTerrain::BlurColor( const NiPoint3& pos, float outerRadius, float ratio )
{
	///  
	unsigned int xbegin, ybegin, xend, yend;
	if( CalcRange( &xbegin, &ybegin, &xend, &yend, pos, outerRadius ) == false )
		return false;

	///   
	cTerrainPaintingInfo info;
	info.mNodeArray.Resize( (yend - ybegin) * (xend - xbegin) );

	///     
	///   尡 ϳ  ٷ Ѵ.
	if( BackupPainting( &info, xbegin, ybegin, xend, yend, pos, outerRadius ) == false )
	{
		return false;
	}

	///    鿡  
	unsigned int nodeCount = mCellCount / cTerrainLeafNode::mCellCount[0];

	for( unsigned int yi = ybegin, i = ybegin * nodeCount; yi < yend; ++yi, i += nodeCount )
	{
		for( unsigned int xi = xbegin; xi < xend; ++xi )
		{
			mNodeArray[i + xi]->BlurColor( pos, outerRadius, ratio );
		}
	}

	///     
	UpdatePainting( &info, xbegin, ybegin, xend, yend, pos, outerRadius );

	///   ߰
	DOINGMAN->PushTerrainPainting( info );
	mModified = true;
	return true;
}
#endif /// MAP_EDITOR
