/* ==========================================================================
*    : ̼
*    : 2007.02.07
*      :  迭 
* ǻ : 
*===========================================================================*/
#pragma once

class cVisibleArray;
class cCamera;

///  迭 
class cVisibleArraySorter
{
public:
	cVisibleArraySorter( cVisibleArray* array );
	virtual ~cVisibleArraySorter();

	/// 
	virtual void Sort( const cCamera& cam ) = 0;

	/// 
	virtual void Render() = 0;

protected:
	///  迭
	cVisibleArray* mArray;
};

///   迭 
class cAlphaArraySorter : public cVisibleArraySorter
{
public:
	cAlphaArraySorter( cVisibleArray* array );
	virtual ~cAlphaArraySorter();

	/// 
	virtual void Sort( const cCamera& cam );

	/// 
	virtual void Render();

protected:
	void SortObjectsByDepth( int l, int r );
	float ChoosePivot( int l, int r ) const;

protected:
	int mNumGeoms;
	int mMaxGeoms;
	NiGeometry** mGeoms;
	float* mDepths;
};

///   迭 
class cSolidArraySorter : public cVisibleArraySorter
{
public:
	cSolidArraySorter( cVisibleArray* array );
	virtual ~cSolidArraySorter();

	/// 
	virtual void Sort( const cCamera& cam );

	/// 
	virtual void Render();

protected:
	unsigned int mNumGeoms;
	NiGeometry** mGeoms;
};

///   
///  迭 ؽó  ϱ  Լ̴.
class cSolidNodeCompare
{
public:
	bool operator()( const NiGeometry* g0, const NiGeometry* g1 ) const
	{
		NiTexturingProperty* tp0 = (NiTexturingProperty*)g0->GetProperty( NiProperty::TEXTURING );
		NiTexturingProperty* tp1 = (NiTexturingProperty*)g1->GetProperty( NiProperty::TEXTURING );

		if( tp0 == 0 )
			return false;

		if( tp1 == 0 ) 
			return true;

		NiTexture* t0 = tp0->GetBaseTexture();
		NiTexture* t1 = tp1->GetBaseTexture();
		return t0 < t1;
	}
};
