/* ==========================================================================
*    : ̼
*    : 2007.03.09
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

class cMaterialData;
class cTerrain;
class cSceneNode;
class cAreaSceneNode;

///  
class cWorldManager
{
	static cWorldManager* mSingleton;

public:
	cWorldManager();
	~cWorldManager();

	/// 
	void Clear();

	/// ʱȭ
	void Init();

	/// ó
	void Process( float deltaTime, float accumTime, bool testing );
	void ProcessAmbient( float deltaTime );
	void ProcessFog( float deltaTime );

	/// 
	void Render();
	void RenderSkyDome();

	/// ϴ
	bool LoadSkyDome( const cString& pathName );
	bool LoadSkyDome( const cString& pathName, float scale, bool enabled );
	void SetSkyScale( float scale );
	void SetSkyEnabled( bool enabled );
	void SetSkyAmbient( const NiColor& color );
	void SetSkyDimmer( float dimmer );
	const char* GetSkyName() const;
	float GetSkyScale() const;
	bool IsSkyEnabled() const;

	/// 
	void SetArea( const cAreaSceneNode& n );
	void BlendArea( const cAreaSceneNode& n0, const cAreaSceneNode& n1, float ratio );

protected:
	///   
	void CollectGeometries( tList<NiGeometry*>* pgeomList, NiAVObject* obj );
	void CollectProperties( tList<NiMaterialProperty*>* ppropList, NiAVObject* obj );
	void SetMaterial( tList<NiMaterialProperty*>& propList, const cMaterialData& material );

	/// ش Ʈ  ۸ Ȱȭ
	void DisableZBuffer( NiAVObject* obj );

public:
	/// ü 
	static cWorldManager* GetSingleton();

protected:
	/// 
	cTerrain* mTerrain;

	/// ϴ
	//NiFogPropertyPtr mSkyFogProp;
	NiAmbientLightPtr mSkyLight;
	NiNodePtr mSkyDome;
	
	typedef tList<NiGeometry*> cGeomList;
	cGeomList mSkyGeomList;
	
	typedef tList<NiMaterialProperty*> cMatPropList;
	cMatPropList mSkyMatPropList;

	bool mSkyEnabled;
	cString mSkyName;

	/// ֺ
	NiColor mTargetSkyAmbient;
	NiColor mSkyAmbient;
	float mTargetSkyDimmer;
	float mSkyDimmer;
	NiColor mTargetTerrainAmbient;
	NiColor mTerrainAmbient;
	float mTargetTerrainDimmer;
	float mTerrainDimmer;
	NiColor mTargetStaticObjectAmbient;
	NiColor mStaticObjectAmbient;
	float mTargetStaticObjectDimmer;
	float mStaticObjectDimmer;
	NiColor mTargetDynamicObjectAmbient;
	NiColor mDynamicObjectAmbient;
	float mTargetDynamicObjectDimmer;
	float mDynamicObjectDimmer;

	/// Ȱ
	NiColor mTargetFogColor;
	NiColor mFogColor;
	float mTargetFogDepth;
	float mFogDepth;

	/// 浹 迭
	typedef tArray<cSceneNode*> cPickedArray;
	cPickedArray mPickedArray;
};

inline
void cWorldManager::SetSkyAmbient( const NiColor& color )
{
	mSkyLight->SetAmbientColor( color );
}

inline
void cWorldManager::SetSkyDimmer( float dimmer )
{
	mSkyLight->SetDimmer( dimmer );
}

inline
void cWorldManager::SetSkyScale( float scale )
{
	if( mSkyDome )
	{
		mSkyDome->SetScale( scale );
		mSkyDome->Update( 0.0f );
	}
}

inline
void cWorldManager::SetSkyEnabled( bool enabled )
{
	mSkyEnabled = enabled;
}

inline
const char* cWorldManager::GetSkyName() const
{
	return mSkyName.Cstr();
}

inline
float cWorldManager::GetSkyScale() const
{
	if( mSkyDome )
		return mSkyDome->GetWorldScale();
	else
		return 1.0f;
}

inline
bool cWorldManager::IsSkyEnabled() const
{
	return mSkyEnabled;
}

inline
cWorldManager* cWorldManager::GetSingleton()
{
	return mSingleton;
}

#define WORLDMAN cWorldManager::GetSingleton()
