/* ==========================================================================
*    : ̼
*    : 2007.03.09
*      : ȯ 
* ǻ : 
*===========================================================================*/
#pragma once

class cSceneNode;
class cAreaSceneNode;
class cEnvCameraDialog;
class cEnvLevelDistanceDialog;
class cEnvSkyDialog;
class cEnvDirLightDialog;

/// ȯ 
class cEnvEditor
{
	static cEnvEditor* mSingleton;

public:
	cEnvEditor();
	~cEnvEditor();

	/// 
	bool Save( cFileSaver& saver );

	/// ī޶
	void SetCamFarDistance( float dist );

	///   Ÿ
	void SetLevelDistance( unsigned int dist0, unsigned int dist1, unsigned int dist2 );

	/// ϴ
	bool LoadSky( const cString& pathName );
	void Update();
	void SetSkyEnabled( bool enabled );
	void SetSkyScale( float scale );

	/// Ɽ
	void SetDirLightAmbient( unsigned int i, const NiColor& color );
	void SetDirLightDiffuse( unsigned int i, const NiColor& color );
	void SetDirLightDimmer( unsigned int i, float dimmer );
	void SetDirLightRotate( unsigned int i, float xangle, float yangle, float zangle );

	/// ̾α
	void SetCameraDialog( cEnvCameraDialog* dlg );
	void SetLevelDistanceDialog( cEnvLevelDistanceDialog* dlg );
	void SetSkyDialog( cEnvSkyDialog* dlg );
	void SetDirLightDialog( cEnvDirLightDialog* dlg );

public:
	/// ü 
	static cEnvEditor* GetSingleton();

protected:
	/// ̾α
	cEnvCameraDialog* mCameraDialog;
	cEnvLevelDistanceDialog* mLevelDistanceDialog;
	cEnvSkyDialog* mSkyDialog;
	cEnvDirLightDialog* mDirLightDialog;

	/// ü  
	cAreaSceneNode* mGlobalArea;
};

inline
void cEnvEditor::SetCameraDialog( cEnvCameraDialog* dlg )
{
	assert( dlg );

	mCameraDialog = dlg;
}

inline
void cEnvEditor::SetLevelDistanceDialog( cEnvLevelDistanceDialog* dlg )
{
	assert( dlg );

	mLevelDistanceDialog = dlg;
}

inline
void cEnvEditor::SetSkyDialog( cEnvSkyDialog* dlg )
{
	assert( dlg );

	mSkyDialog = dlg;
}

inline
void cEnvEditor::SetDirLightDialog( cEnvDirLightDialog* dlg )
{
	assert( dlg );

	mDirLightDialog = dlg;
}

inline
cEnvEditor* cEnvEditor::GetSingleton()
{
	return mSingleton;
}

#define ENVEDIT cEnvEditor::GetSingleton()
