/* ==========================================================================
*    : ̼
*    : 2007.02.15
*      : ΰ
* ǻ : 
*===========================================================================*/
#pragma once

#include "Engine/Sphere.h"
#include "Engine/PlayerSceneNode.h"

#include "Lines.h"

const unsigned int MAX_PATH_COUNT = 2048;

class cLookAtCamera;
class cRibbonGeometry;

/// ΰ
class cHero
{
	static cHero* mSingleton;

public:
	cHero( cLookAtCamera* cam );
	~cHero();

	void Clear();

	/// ʱȭ
	bool Init();

	/// V
	void Reset();

	/// ó
	void Process( float time );

	/// 
	void RenderLines();

	/// ̵
	void SetTranslate( const NiPoint3& pos );
	const NiPoint3& GetWorldTranslate() const;

	/// ȸ
	const NiMatrix3& GetWorldRotate() const;

	/// ǥ 
	void SetTargetPos( const NiPoint3& pos );

	///  
	const cSphere& GetBoundSphere() const;
	const NiPoint3& GetCenter() const;

	///  
	cPlayerSceneNode* GetSceneNode() const;

public:
	/// ü 
	static cHero* GetSingleton();

private:
	/// ġ
	NiPoint3 mPos;

	/// ã  ̵ 
	NiPoint2 mPathArray[MAX_PATH_COUNT];
	unsigned int mPathCount;
	unsigned int mPathIndex;

	/// ã ̵  
	NiLinesPtr mPathLines;
	NiPoint3* mPosCoords;
	NiColorA* mColors;
	NiBool* mFlags;
	NiMaterialPropertyPtr mMatProp;
	NiVertexColorPropertyPtr mVertColorProp;
	NiWireframePropertyPtr mWireProp;

	///   
	cCircleLines mLevel0Lines;
	cCircleLines mLevel1Lines;
	cCircleLines mLevel2Lines;

	/// ī޶
	cLookAtCamera* mCamera;

	/// 
	cPlayerSceneNode* mNode;

	///  
	cSphere mBoundSphere;

	/// 
	//LPDIRECT3DTEXTURE9 mRibbonTexture;
	//cRibbonGeometry* mRibbonGeom;

	///  
	bool mNeedUpdate;
};

inline
const cSphere& cHero::GetBoundSphere() const
{
	return mBoundSphere;
}

inline
const NiPoint3& cHero::GetCenter() const
{
	if( mNode )
		return mNode->GetCenter();
	else
		return NiPoint3::ZERO;
}

inline
const NiPoint3& cHero::GetWorldTranslate() const
{
	return mNode->GetWorldTranslate();
}

inline
const NiMatrix3& cHero::GetWorldRotate() const
{
	return mNode->GetWorldRotate();
}

inline
cPlayerSceneNode* cHero::GetSceneNode() const
{
	return mNode;
}

inline
cHero* cHero::GetSingleton()
{
	return mSingleton;
}

#define HERO cHero::GetSingleton()
