/* ==========================================================================
*    : ̼
*    : 2006.12.13
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

class cSceneNode;
class cLightSceneNode;
class cLightTransformDialog;
class cLightPropertyDialog;
class cLightInfoDialog;

///  
/// ʻ  Ѵ.
class cLightEditor
{
	static cLightEditor* mSingleton;
	friend class cMapEditorView;
	friend class cObjectEditor;

public:
	cLightEditor();
	~cLightEditor();

	/// 
	void Clear();

	/// 
	void Render();

	/// ʱȭ
	void Init();

	/// 
	bool Save( cFileSaver& saver );

	///  
	bool CreateLight();

	/// ŷ
	bool Pick( CPoint point );

	/// 
	void DeselectAll();

	///   
	void AttachLightToTerrain( CPoint point );

	///  Ʈ 
	void AttachLightToObject( CPoint point );

	///  
	void DeleteLight();

	///  
	void CopyLight();

	///  ̾α׸ 
	void UpdateInfoDialog();

	///  ̵
	void SetLightTranslate( const NiPoint3& trans, bool updateDialog );

	///  
	void SetLightRadius( float scale, bool updateDialog );

	///  
	void SetLightAmbient( COLORREF rgb );
	void SetLightDiffuse0( COLORREF rgb );
	void SetLightDiffuse1( COLORREF rgb );
	void SetLightDiffuseAnimTime( float time );
	void SetLightSpecular( COLORREF rgb );

	///   
	void SetLightConstantAtten0( float value );
	void SetLightConstantAtten1( float value );
	void SetLightConstantAttenAnimTime( float value );
	void SetLightLinearAtten( float value );
	void SetLightQuadricAtten( float value );

	/// ̾α
	void SetTransformDialog( cLightTransformDialog* dlg );
	void SetPropertyDialog( cLightPropertyDialog* dlg );
	void SetInfoDialog( cLightInfoDialog* dlg );

	///  
	unsigned int GetNumLights() const;

private:
	/// ش  
	bool Kill( cLightSceneNode* node );

	/// ش  
	///  ο  Ѵ.
	cLightSceneNode* Clone( cLightSceneNode* node );

	/// ޽ ó
	void OnMouseMove( CPoint point );
	void OnLButtonDown_Transform( CPoint point );
	void OnRButtonDown_Transform( CPoint point, bool ctrl );
	void OnKeyDown( UINT c );

public:
	/// ü 
	static cLightEditor* GetSingleton();

protected:
	/// ġ ̾α
	cLightTransformDialog* mTransformDialog;

	/// Ӽ ̾α
	cLightPropertyDialog* mPropertyDialog;

	///  ̾α
	cLightInfoDialog* mInfoDialog;

	///   V
	typedef tHashSet<cLightSceneNode*> cCreatedSet;
	cCreatedSet mCreatedSet;

	/// ŷ  迭
	typedef tArray<cSceneNode*> cPickedArray;
	cPickedArray mPickedArray;

	/// õ 
	cLightSceneNode* mSelectedNode;

	///  
	///   ǥϴµ Ѵ.
	NiLinesPtr mCircleLines;
	NiPoint3* mPosCoords;
	NiBool* mFlags;
	NiMaterialPropertyPtr mMatProp;
	NiVertexColorPropertyPtr mVertColorProp;
	NiWireframePropertyPtr mWireProp;

	/// 콺 ǥ
	CPoint mMousePos;
};

inline
void cLightEditor::SetTransformDialog( cLightTransformDialog* dlg )
{
	assert( dlg && "null light transform dialog" );

	mTransformDialog = dlg;
}

inline
void cLightEditor::SetPropertyDialog( cLightPropertyDialog* dlg )
{
	assert( dlg && "null light property dialog" );

	mPropertyDialog = dlg;
}

inline
void cLightEditor::SetInfoDialog( cLightInfoDialog* dlg )
{
	assert( dlg && "null light info dialog" );

	mInfoDialog = dlg;
}

inline
unsigned int cLightEditor::GetNumLights() const
{
	return mCreatedSet.GetSize();
}

inline
cLightEditor* cLightEditor::GetSingleton()
{
	return mSingleton;
}

#define LIGHTEDIT cLightEditor::GetSingleton()
