/* ==========================================================================
*    : ̼
*    : 2006.12.02
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

class cTabWindow;
class cMapEditorView;
class cObjectEditor;

///  
class cMainFrame : public CFrameWnd
{
	static cMainFrame* mSingleton;
	DECLARE_DYNAMIC(cMainFrame)

public:
	cMainFrame();
	virtual ~cMainFrame();

	/// Ʈ
	void LoadProject( cString pathName );
	void SaveProject( cString pathName );
	void SetCameraFileName( const cString& fileName );
	void SetPaletteFileName( const cString& fileName );

	/// 
	void LoadTerrain( cString pathName, bool loadNavi = true );

	/// 
	void LoadScene( cString pathName );
	void AddScene( cString pathName );

	/// 
	void LoadSound( cString pathName );

	/// ׺޽
	void LoadNaviMesh( cString pathName );

	/// ׺ʵ
	void LoadNaviField( cString pathName );

	///  ׷
	void LoadAreaGroup( const cString& pathName );

	/// Ʈ ġ ũƮ
	void LoadOscr( const cString& pathName );

	///  
	void SetTerrainModified( const cString& pathName, bool modified );
	void SetTerrainModified( bool modified );
	void SetSceneModified( const cString& pathName, bool modified );
	void SetSceneModified( bool modified );
	void SetSoundSceneModified( const cString& pathName, bool modified );
	void SetSoundSceneModified( bool modified );
	void SetNaviMeshModified( const cString& pathName, bool modified );
	void SetNaviMeshModified( bool modified );
	void SetNaviFieldModified( const cString& pathName, bool modified );
	void SetNaviFieldModified( bool modified );

public:
	virtual BOOL PreCreateWindow( CREATESTRUCT& cs );
	virtual BOOL OnCreateClient( LPCREATESTRUCT cs, CCreateContext* pcontext );

public:
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	afx_msg int OnCreate( LPCREATESTRUCT cs );
	afx_msg void OnClose();
	afx_msg void OnLoadProject();
	afx_msg void OnSaveProject();
	afx_msg void OnSaveScreenShot();
	afx_msg void OnSaveLog();
	afx_msg void OnTerrainNew();
	afx_msg void OnTerrainOpen();
	afx_msg void OnTerrainSave();
	afx_msg void OnTerrainSaveAs();
	afx_msg void OnTerrainClearHeightMap();
	afx_msg void OnTerrainImportHeightMap();
	afx_msg void OnTerrainExportHeightMap();
	afx_msg void OnTerrainClearAlphaMap();
	afx_msg void OnTerrainImportAlphaMap();
	afx_msg void OnTerrainExportAlphaMap();
	afx_msg void OnTerrainClearColorMap();
	afx_msg void OnTerrainImportColorMap();
	afx_msg void OnTerrainExportColorMap();
	afx_msg void OnTerrainAdjustHeight();
	afx_msg void OnSceneNew();
	afx_msg void OnSceneOpen();
	afx_msg void OnSceneAdd();
	afx_msg void OnSceneSave();
	afx_msg void OnSceneSaveAs();
	afx_msg void OnSceneSaveAreaAs();
	afx_msg void OnSceneSaveObjectGroupAs();
	afx_msg void OnSceneLoadAreaGroup();
	afx_msg void OnSceneLoadObjectTransformScript();
	afx_msg void OnSceneAdjustAllPos();
	afx_msg void OnSceneAdjustAllSize();
	afx_msg void OnNaviMeshSave();
	afx_msg void OnNaviMeshSaveAs();
	afx_msg void OnNaviFieldSave();
	afx_msg void OnNaviFieldSaveAs();
	afx_msg void OnSoundNew();
	afx_msg void OnSoundOpen();
	afx_msg void OnSoundSave();
	afx_msg void OnSoundSaveAs();
	afx_msg void OnEditCopy();
	afx_msg void OnEditSelectAll();
	afx_msg void OnEditDeselectAll();
	afx_msg void OnEditChangeBackgroundColor();
	afx_msg void OnEditUndo();
	afx_msg void OnEditRedo();
	afx_msg void OnEscape();
	DECLARE_MESSAGE_MAP()

public:
	/// ü 
	static cMainFrame* GetSingleton();

protected:
	///  
	cTabWindow* mTabWindow;

	/// 
	cMapEditorView* mView;

	/// ø
	CSplitterWnd mSplitter;
	CSplitterWnd mLeftSplitter;

	///  ̸
	cString mTerrainName;
	cString mSceneName;
	cString mSoundSceneName;
	cString mNaviMeshName;
	cString mNaviFieldName;
	cString mCameraFileName;
	cString mPaletteFileName;

	///   
	bool mTerrainModified;
	bool mSceneModified;
	bool mSoundModified;
	bool mNaviMeshModified;
	bool mNaviFieldModified;
};

inline
void cMainFrame::SetCameraFileName( const cString& fileName )
{
	mCameraFileName = fileName;
}

inline
void cMainFrame::SetPaletteFileName( const cString& fileName )
{
	mPaletteFileName = fileName;
}

inline
cMainFrame* cMainFrame::GetSingleton()
{
	return mSingleton;
}

#define MAIN cMainFrame::GetSingleton()
