/* ==========================================================================
*    : ̼
*    : 2006.12.02
*      :   
* ǻ : 
*===========================================================================*/
#pragma once

class cDoingManager;
class cTerrainEditor;
class cObjectEditor;
class cLightEditor;
class cSoundEditor;
class cAreaEditor;
class cEnvEditor;
class cNaviMeshEditor;
class cNaviFieldEditor;

class cDialog;
class cTerrainBuildDialog;
class cTerrainPaintDialog;
class cTerrainOptionDialog;
class cTerrainInfoDialog;
class cObjectTransformDialog;
class cObjectPropertyDialog;
class cObjectInfoDialog;
class cLightTransformDialog;
class cLightPropertyDialog;
class cLightInfoDialog;
class cSoundTransformDialog;
class cSoundPropertyDialog;
class cSoundInfoDialog;
class cAreaTransformDialog;
class cAreaLightDialog;
class cAreaFogDialog;
class cAreaEtcDialog;
class cEnvCameraDialog;
class cEnvLevelDistanceDialog;
class cEnvSkyDialog;
class cEnvDirLightDialog;
class cNaviMeshBuildDialog;
class cNaviFieldPaintDialog;
class cNaviFieldInfoDialog;
class cSettingViewDialog;
class cSettingControlDialog;

class cApplication;
class cFreeCamera;
class cLookAtCamera;
class cHero;

const float GAME_CAM_FAR_DIST_METER = 500.0f;
const float GAME_CAM_FAR_DIST_UNIT = 50000.0f;

///  
enum eEditMode
{
	eEDIT_NULL = -1,
	eEDIT_TERRAIN_BUILD = 0,
	eEDIT_TERRAIN_PAINT,
	eEDIT_OBJECT_TRANSFORM,
	eEDIT_LIGHT_TRANSFORM,
	eEDIT_SOUND_TRANSFORM,
	eEDIT_AREA_TRANSFORM,
	eEDIT_NAVIMESH_BUILD,
	eEDIT_NAVIFIELD_PAINT,
	eEDIT_MAX_MODES
};

///   
class cMapEditorView : public CView
{
	static cMapEditorView* mSingleton;
	DECLARE_DYNCREATE( cMapEditorView )

public:
	typedef tArray<cFreeCamera*> cCameraArray;

public:
	cMapEditorView();
	virtual ~cMapEditorView();

	/// ʱȭ
	void Init();

	/// 
	void Update();

	/// ũ
	bool SaveScreenShot( const cString& pathName, unsigned int width, unsigned int height, bool onlyTerrain = false );

	/// α
	bool SaveLog( const cString& pathName, unsigned int resolution );

	/// ȭ ũ
	void Resize( unsigned int width, unsigned int height );

	/// ̾α
	void SetTerrainBuildDialog( cTerrainBuildDialog* dlg );
	void SetTerrainPaintDialog( cTerrainPaintDialog* dlg );
	void SetTerrainOptionDialog( cTerrainOptionDialog* dlg );
	void SetTerrainInfoDialog( cTerrainInfoDialog* dlg );
	void SetObjectTransformDialog( cObjectTransformDialog* dlg );
	void SetObjectPropertyDialog( cObjectPropertyDialog* dlg );
	void SetObjectInfoDialog( cObjectInfoDialog* dlg );
	void SetLightTransformDialog( cLightTransformDialog* dlg );
	void SetLightPropertyDialog( cLightPropertyDialog* dlg );
	void SetLightInfoDialog( cLightInfoDialog* dlg );
	void SetSoundTransformDialog( cSoundTransformDialog* dlg );
	void SetSoundPropertyDialog( cSoundPropertyDialog* dlg );
	void SetSoundInfoDialog( cSoundInfoDialog* dlg );
	void SetAreaTransformDialog( cAreaTransformDialog* dlg );
	void SetAreaLightDialog( cAreaLightDialog* dlg );
	void SetAreaFogDialog( cAreaFogDialog* dlg );
	void SetAreaEtcDialog( cAreaEtcDialog* dlg );
	void SetEnvCameraDialog( cEnvCameraDialog* dlg );
	void SetEnvLevelDistanceDialog( cEnvLevelDistanceDialog* dlg );
	void SetEnvSkyDialog( cEnvSkyDialog* dlg );
	void SetEnvDirLightDialog( cEnvDirLightDialog* dlg );
	void SetNaviMeshBuildDialog( cNaviMeshBuildDialog* dlg );
	void SetNaviFieldPaintDialog( cNaviFieldPaintDialog* dlg );
	void SetNaviFieldInfoDialog( cNaviFieldInfoDialog* dlg );
	void SetSettingViewDialog( cSettingViewDialog* dlg );
	void SetSettingControlDialog( cSettingControlDialog* dlg );

	///  
	void SetEditMode( eEditMode mode );
	eEditMode GetEditMode() const;

	/// ī޶
	void SelectCamera( unsigned int i, bool makeCurrent = false );
	void ZoomPersp();
	void ZoomOrtho();
	unsigned int NewCamera();
	void DeleteCamera();
	unsigned int LoadCamera( const cString& pathName );
	bool SaveCameraAs( const cString& pathName );

	void ChangeToFreeCamera();
	void ChangeToLookAtCamera();
	void MoveFreeCameraToHero();
	void MoveFreeCameraToSelectObject( bool next );
	void SetDefaultCameraFarDistance( float dist );
	void SetLookAtCameraFarDistance( float dist );

	cFreeCamera* GetDefaultCamera() const;
	cFreeCamera* GetFreeCamera() const;
	cLookAtCamera* GetLookAtCamera() const;

	/// ΰ
	cHero* GetHero() const;

protected:
	BOOL PreCreateWindow( CREATESTRUCT& cs );
	void OnDraw( CDC* dc );

public:
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump( CDumpContext& dc ) const;
#endif

public:
	void OnEditCopy();
	void OnEditDeselectAll();
	void OnEditChangeBackgroundColor();

protected:
	afx_msg int OnCreate( LPCREATESTRUCT cs );
	afx_msg void OnDestroy();
	afx_msg BOOL OnEraseBkgnd(CDC* dc);
	afx_msg void OnSize( UINT type, int cx, int cy );
	afx_msg void OnTimer( UINT_PTR nIDEvent );
	afx_msg void OnMouseMove( UINT flags, CPoint point );
	afx_msg BOOL OnMouseWheel( UINT flags, short zdelta, CPoint point );
	afx_msg void OnLButtonDown( UINT flags, CPoint point );
	afx_msg void OnLButtonUp( UINT flags, CPoint point );
	afx_msg void OnRButtonDown( UINT flags, CPoint point );
	afx_msg void OnRButtonUp( UINT flags, CPoint point );
	afx_msg void OnMButtonDown( UINT flags, CPoint point );
	afx_msg void OnMButtonUp( UINT flags, CPoint point );
	afx_msg void OnKeyDown(UINT c, UINT repeats, UINT flags);
	afx_msg void OnKeyUp(UINT c, UINT repeats, UINT flags);
	DECLARE_MESSAGE_MAP()

public:
	/// ü 
	static cMapEditorView* GetSingleton();

private:
	/// ø̼
	cApplication* mApplication;

	///  
	cDoingManager* mDoingManager;

	/// 
	cTerrainEditor* mTerrainEditor;
	cObjectEditor* mObjectEditor;
	cLightEditor* mLightEditor;
	cSoundEditor* mSoundEditor;
	cAreaEditor* mAreaEditor;
	cEnvEditor* mEnvEditor;
	cNaviMeshEditor* mNaviMeshEditor;
	cNaviFieldEditor* mNaviFieldEditor;

	/// ̾α
	cTerrainBuildDialog* mTerrainBuildDialog;
	cTerrainPaintDialog* mTerrainPaintDialog;
	cObjectTransformDialog* mObjectTransformDialog;
	cObjectPropertyDialog* mObjectPropertyDialog;
	cLightTransformDialog* mLightTransformDialog;
	cLightPropertyDialog* mLightPropertyDialog;
	cSoundTransformDialog* mSoundTransformDialog;
	cSoundPropertyDialog* mSoundPropertyDialog;
	cAreaTransformDialog* mAreaTransformDialog;
	cNaviMeshBuildDialog* mNaviMeshBuildDialog;
	cNaviFieldPaintDialog* mNaviFieldPaintDialog;
	cSettingViewDialog* mSettingViewDialog;
	cSettingControlDialog* mSettingControlDialog;

	///  
	eEditMode mEditMode;
	cDialog* mEditDialogs[eEDIT_MAX_MODES];

	/// ׽Ʈ  (true̸  , false̸  )
	bool mPlaying;

	/// ī޶
	cCameraArray mCameraArray;
	cFreeCamera* mDefaultCamera;
	cFreeCamera* mFreeCamera;
	cLookAtCamera* mLookAtCamera;

	/// ΰ
	cHero* mHero;
	bool mHeroLines;
};

inline
eEditMode cMapEditorView::GetEditMode() const
{
	return mEditMode;
}

inline
cHero* cMapEditorView::GetHero() const
{
	return mHero;
}

inline
cFreeCamera* cMapEditorView::GetDefaultCamera() const
{
	return mDefaultCamera;
}

inline
cFreeCamera* cMapEditorView::GetFreeCamera() const
{
	return mFreeCamera;
}

inline
cLookAtCamera* cMapEditorView::GetLookAtCamera() const
{
	return mLookAtCamera;
}

inline
cMapEditorView* cMapEditorView::GetSingleton()
{
	return mSingleton;
}

#define VIEW cMapEditorView::GetSingleton()
