#include "stdafx.h"
#include "MapEditorView.h"

#include "TerrainEditor.h"
#include "ObjectEditor.h"
#include "StringTable.h"

bool cMapEditorView::SaveLog( const cString& pathName, unsigned int resolution )
{
	cStringTable table;
	unsigned int row = 0;
	float size = mTerrainEditor->GetResolution() * mTerrainEditor->GetMetersPerVertex() / resolution;

	table.SetValue( row, 0, "----- ̸  α -----" );
	++row;

	table.SetValue( ++row, 0, "----- α  -----" );
	table.SetValue( ++row, 0, "[ ̸]" );
	table.SetValue( row, 1, pathName );
	table.SetValue( ++row, 0, "[ ػ]" );
	table.SetValue( row, 1, resolution );
	table.SetValue( ++row, 0, "[ ũ]" );
	table.SetValue( row, 1, size );
	table.SetValue( ++row, 0, "----------" );
	++row;

	mTerrainEditor->ExportLog( table, row );
	mObjectEditor->ExportLog( table, row, resolution );

	table.SetValue( ++row, 0, "-----  -----" );

	return table.Save( pathName );
}
