#include "stdafx.h"
#include "NaviFieldDialog.h"

#include "Resource.h"
#include "TabWindow.h"
#include "NaviFieldBuildDialog.h"
#include "NaviFieldPaintDialog.h"
#include "NaviFieldInfoDialog.h"

IMPLEMENT_DYNAMIC(cNaviFieldDialog, CDialog)

BEGIN_MESSAGE_MAP(cNaviFieldDialog, CDialog)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_WM_SIZE()
END_MESSAGE_MAP()

cNaviFieldDialog::cNaviFieldDialog()
: mBuildDialog( 0 )
, mPaintDialog( 0 )
, mInfoDialog( 0 )
{
}

cNaviFieldDialog::~cNaviFieldDialog()
{
}

int cNaviFieldDialog::OnCreate( LPCREATESTRUCT cs )
{
	if( CDialog::OnCreate(cs) == -1 )
		return -1;

	if( CDialog::OnCreate(cs) == -1 )
		return -1;

	/// η縶  
	mRollupWnd.Create( WS_VISIBLE | WS_CHILD, CRect(4, 4, 220, 400), this, 1 );

	/// ׺ʵ   ߰
	mBuildDialog = new cNaviFieldBuildDialog;
	mBuildDialog->Create( MAKEINTRESOURCE(IDD_DIALOG_NAVIFIELD_BUILD), &mRollupWnd );
	mRollupWnd.InsertPage( "Build", mBuildDialog );

	/// ׺ʵ ĥ  ߰
	mPaintDialog = new cNaviFieldPaintDialog;
	mPaintDialog->Create( MAKEINTRESOURCE(IDD_DIALOG_NAVIFIELD_PAINT), &mRollupWnd );
	mRollupWnd.InsertPage( "Paint", mPaintDialog );

	/// ׺ʵ   ߰
	mInfoDialog = new cNaviFieldInfoDialog;
	mInfoDialog->Create( MAKEINTRESOURCE(IDD_DIALOG_TERRAIN_INFO), &mRollupWnd );
	mRollupWnd.InsertPage( "Info", mInfoDialog );

	mRollupWnd.ExpandAllPages();
	return 0;
}

void cNaviFieldDialog::OnClose()
{
	TABWIN->SetButtonChecked( IDC_BUTTON_TAB_NAVIFIELD, false );
	CDialog::OnClose();
}

void cNaviFieldDialog::OnSize( UINT type, int cx, int cy )
{
	CDialog::OnSize( type, cx, cy );
	mRollupWnd.Resize( type, cx, cy );
}
