/* ==========================================================================
*    : ̼
*    : 2007.01.10
*      : ׺ʵ 
* ǻ : 
*===========================================================================*/
#pragma once

#include "Lines.h"

class cSceneNode;
class cPathFinder;
class cNaviField;
class cNaviFieldLeafNode;
class cNaviFieldBuildDialog;
class cNaviFieldPaintDialog;
class cNaviFieldInfoDialog;

/// ׺ʵ 
/// ʻ ׺ʵ   ϰ
/// ׺ʵ (*.navifield) , εѴ.
class cNaviFieldEditor
{
	static cNaviFieldEditor* mSingleton;
	friend class cMapEditorView;

public:
	cNaviFieldEditor();
	~cNaviFieldEditor();

	/// 
	void Clear();

	/// ó
	void Process();

	/// 
	void Render();

	/// ׺ʵ带  
	void Init( unsigned int resolution, float metersPerVertex = 1.0f, unsigned int unitsPerMeter = 100 );

	/// ׺ʵ带 ε
	bool Load( const cString& pathName );

	/// ׺ʵ带 
	bool Save();
	bool SaveAs( const cString& pathName );

	///  
	void SyncAllToNaviMesh();

	/// ĥ ̾α׸ 
	void SetPaintDialog( cNaviFieldPaintDialog* dlg );

	///  ̾α׸ 
	void SetInfoDialog( cNaviFieldInfoDialog* dlg );

	/// ŷ ġ  θ 
	void SetPickPosChanged( bool changed );

	///  ̸ 
	const cString& GetPathName() const;

	/// ػ󵵸 
	unsigned int GetResolution() const;

	///  ͼ 
	float GetMetersPerVertex() const;

	/// ã⸦ 
	cPathFinder* GetPathFinder() const;

protected:
	bool CalcRange( unsigned int* xbegin, unsigned int* ybegin, unsigned int* xend, unsigned int* yend, const NiPoint3& pos, float radius );

private:
	/// ޽ ó
	void OnTimer_Paint();
	void OnMouseMove( CPoint point );
	void OnLButtonDown_Paint( CPoint point );
	void OnLButtonUp();

public:
	/// ü 
	static cNaviFieldEditor* GetSingleton();

protected:
	/// ĥ ̾α
	cNaviFieldPaintDialog* mPaintDialog;

	///  ̾α
	cNaviFieldInfoDialog* mInfoDialog;

	/// ׺ʵ
	cNaviField* mNaviField;

	/// ã
	cPathFinder* mPathFinder;

	/// ŷ   迭
	typedef tArray<cSceneNode*> cPickedArray;
	cPickedArray mPickedArray;

	///  
	bool mDrawing;

	/// ŷ ġ
	NiPoint3 mPickPos;
	NiPoint3 mPickOldPos;
	bool mPickPosChanged;

	///  
	///   ǥϴµ Ѵ.
	cCircleLines mOuterLines;

	/// 콺 ǥ
	CPoint mMousePos;

	///  ̸
	cString mPathName;
};

inline
void cNaviFieldEditor::SetPaintDialog( cNaviFieldPaintDialog* dlg )
{
	assert( dlg && "null navifield paint dialog" );

	mPaintDialog = dlg;
}

inline
void cNaviFieldEditor::SetInfoDialog( cNaviFieldInfoDialog* dlg )
{
	assert( dlg && "null navifield info dialog" );

	mInfoDialog = dlg;
}

inline
void cNaviFieldEditor::SetPickPosChanged( bool changed )
{
	mPickPosChanged = changed;
}

inline
const cString& cNaviFieldEditor::GetPathName() const
{
	return mPathName;
}

inline
cNaviFieldEditor* cNaviFieldEditor::GetSingleton()
{
	return mSingleton;
}

inline
cPathFinder* cNaviFieldEditor::GetPathFinder() const
{
	return mPathFinder;
}

#define NAVIFIELDEDIT cNaviFieldEditor::GetSingleton()
#define PATHFINDER NAVIFIELDEDIT->GetPathFinder()
