/* ==========================================================================
*    : ̼
*    : 2006.12.17
*      : ׺ʵ ĥ ̾α
* ǻ : 
*===========================================================================*/
#pragma once

#include "UI/Dialog.h"
#include "UI/CheckButton.h"
#include "UI/CheckButtonGroup.h"
#include "UI/ColorBox.h"
#include "UI/NumericEdit.h"

#include "Resource.h"

class cMapEditorView;

/// ׺ʵ ĥ ̾α
class cNaviFieldPaintDialog : public cDialog
{
	DECLARE_DYNAMIC(cNaviFieldPaintDialog)

public:
	cNaviFieldPaintDialog();
	virtual ~cNaviFieldPaintDialog();

	/// 
	void UpdateRadius( float radius );

	/// ư
	void SetCheckedButton( int id );
	unsigned int GetCheckedButton() const;

	/// 
	float GetRadius() const;

	/// 
	COLORREF GetColor() const;

	/// ʵ尪
	void SetValue( unsigned char value );
	unsigned char GetValue() const;

protected:
	void DoDataExchange( CDataExchange* dx );
	BOOL OnInitDialog();

protected:
	DECLARE_MESSAGE_MAP()
	afx_msg void OnClickedButton();
	afx_msg void OnHScroll( UINT code, UINT pos, CScrollBar* bar );
	afx_msg LRESULT OnChangedValue( WPARAM id, LPARAM );

private:
	/// ư
	cCheckButton mColorButton;
	cCheckButton mPickButton;
	cCheckButtonGroup mGroup;

	///  
	cColorBox mColorBox;
	COLORREF mColor[16];

	///  Ʈ
	cNumericEdit mValueEdit;
};

inline
unsigned int cNaviFieldPaintDialog::GetCheckedButton() const
{
	cCheckButton* btn = mGroup.GetCheckedButton();

	if( btn == 0 )
		return 0;
	else
		return btn->GetDlgCtrlID();
}

inline
float cNaviFieldPaintDialog::GetRadius() const
{
	CSliderCtrl* slider = (CSliderCtrl*)GetDlgItem( IDC_SLIDER_NPAINT_RADIUS );
	return slider->GetPos() / 10.0f;
}

inline
COLORREF cNaviFieldPaintDialog::GetColor() const
{
	return mColorBox.GetColor();
}

inline
void cNaviFieldPaintDialog::SetValue( unsigned char i )
{
	assert( i < 16 );

	mColorBox.SetColor( mColor[i] );
	mValueEdit.SetValue( i );
}

inline
unsigned char cNaviFieldPaintDialog::GetValue() const
{
	return (unsigned char)mValueEdit.GetValue();
}
