/* ==========================================================================
*    : ̼
*    : 2006.12.13
*      : ׺޽ 
* ǻ : 
*===========================================================================*/
#pragma once

class cSceneNode;
class cNaviMesh;
class cNaviMeshLeafNode;
class cNaviMeshBuildDialog;

/// ׺޽ 
/// ʻ ׺޽   ϰ
/// ׺޽ (*.navimesh) , εѴ.
class cNaviMeshEditor
{
	static cNaviMeshEditor* mSingleton;
	friend class cMapEditorView;

public:
	cNaviMeshEditor();
	~cNaviMeshEditor();

	/// 
	void Clear();

	/// ó
	void Process();

	/// 
	void Render();

	/// ׺޽ø  
	void Init( unsigned int resolution, float metersPerVertex = 1.0f, unsigned int unitsPerMeter = 100 );

	/// ׺޽ø ε
	bool Load( const cString& pathName );

	/// ׺޽ø 
	bool Save();
	bool SaveAs( const cString& pathName );

	///  
	void SyncAllToTerrain();

	///  ̾α׸ 
	void SetBuildDialog( cNaviMeshBuildDialog* dlg );

	/// ŷ ġ  θ 
	void SetPickPosChanged( bool changed );

	///  ̸ 
	const cString& GetPathName() const;

	/// ػ󵵸 
	unsigned int GetResolution() const;

	///  ͼ 
	float GetMetersPerVertex() const;

private:
	/// ޽ ó
	void OnTimer_Build();
	void OnMouseMove( CPoint point );
	void OnLButtonDown_Build( CPoint point );
	void OnLButtonUp();

public:
	/// ü 
	static cNaviMeshEditor* GetSingleton();

protected:
	///  ̾α
	cNaviMeshBuildDialog* mBuildDialog;

	/// ׺޽
	cNaviMesh* mNaviMesh;

	/// ŷ   迭
	typedef tArray<cSceneNode*> cPickedArray;
	cPickedArray mPickedArray;

	///  
	bool mDrawing;

	/// ŷ ġ
	NiPoint3 mPickPos;
	NiPoint3 mPickOldPos;
	bool mPickPosChanged;

	///  
	///   ǥϴµ Ѵ.
	NiLinesPtr mCircleLines;
	NiPoint3* mPosCoords;
	NiColorA* mColors;
	NiBool* mFlags;
	NiMaterialPropertyPtr mMatProp;
	NiVertexColorPropertyPtr mVertColorProp;
	NiWireframePropertyPtr mWireProp;

	/// 콺 ǥ
	CPoint mMousePos;

	///  ̸
	cString mPathName;
};

inline
void cNaviMeshEditor::SetBuildDialog( cNaviMeshBuildDialog* dlg )
{
	assert( dlg && "null navimesh build dialog" );

	mBuildDialog = dlg;
}

inline
void cNaviMeshEditor::SetPickPosChanged( bool changed )
{
	mPickPosChanged = changed;
}

inline
const cString& cNaviMeshEditor::GetPathName() const
{
	return mPathName;
}

inline
cNaviMeshEditor* cNaviMeshEditor::GetSingleton()
{
	return mSingleton;
}

#define NAVIMESHEDIT cNaviMeshEditor::GetSingleton()
