/* ==========================================================================
*    : ̼
*    : 2006.12.13
*      : Ʈ 
* ǻ : 
*===========================================================================*/
#pragma once

class cSceneNode;
class cStaticSceneNode;
class cObjectCreating;
class cObjectSelectingInfo;
class cObjectSelecting;
class cObjectDeletingInfo;
class cObjectDeleting;
class cObjectCopying;
class cObjectTranslating;
class cObjectRotating;
class cObjectScaling;
class cObjectTransformDialog;
class cObjectPropertyDialog;
class cObjectInfoDialog;
class cStringTable;

/// ׷ Ʈ
/// Ʈ ׷ ϳ   Ѵ.
class cObjectGroup
{
	friend class cObjectEditor;

public:
	cObjectGroup();
	~cObjectGroup();

	/// 
	void Clear();

	/// 
	void Render();

	/// Ʈ 
	void Select( cStaticSceneNode* node, bool ctrl );
	void Select( const tHashSet<cStaticSceneNode*>& nodeSet );
	void Deselect();

	/// Ʈ 
	void Delete();

	/// ̵
	void SetTranslate( const NiPoint3& trans );
	const NiPoint3& GetTranslate() const;

	/// ȸ
	void SetRotate( float xangle, float yangle, float zangle );
	const NiMatrix3& GetRotate() const;

	/// 
	void SetScale( float scale );
	float GetScale() const;

	///  
	void SetMaterialApplied( bool matApplied );
	bool GetMaterialApplied() const;

	/// ֺ ݻ
	void SetAmbient( COLORREF rgb );
	COLORREF GetAmbient() const;

	///  ݻ
	void SetDiffuse( COLORREF rgb );
	COLORREF GetDiffuse() const;

	/// ߻
	void SetEmissive( COLORREF rgb );
	COLORREF GetEmissive() const;

	/// ̸ 
	const char* GetFileName() const;

	///  
	void SetVisibleLevel( unsigned int level );
	unsigned int GetVisibleLevel() const;

	///  
	void SetOccludeLevel( unsigned int level );
	unsigned int GetOccludeLevel() const;

	/// Ȱ 
	void SetFogApplied( bool fogApplied );
	bool GetFogApplied() const;

	/// Ʈ  
	unsigned int GetSize() const;

	/// ִ θ 
	bool IsEmpty() const;

	/// õ   V 
	const tHashSet<cStaticSceneNode*>& GetSelectedSet() const;

	typedef tHashSet<cStaticSceneNode*> cSelectedSet;
private:
	///  Ż
	void DetachAll();
	void AttachAll();

	/// 
	/// Undo ʿ  Ѵ.
	void CollectUnSelecting( cObjectSelectingInfo* info );
	void CollectUnDeleting( cObjectDeletingInfo* info );

	/// 
	/// Redo ʿ  Ѵ.
	void CollectReSelecting( cObjectSelectingInfo* info );
	void CollectReDeleting( cObjectDeletingInfo* info );

	/// Undo
	void Undo( const cObjectSelecting& doing );
	void Undo( const cObjectDeleting& doing );
	void Undo( const cObjectTranslating& doing );
	void Undo( const cObjectRotating& doing );
	void Undo( const cObjectScaling& doing );

	/// Redo
	void Redo( const cObjectSelecting& doing );
	void Redo( const cObjectDeleting& doing );
	void Redo( const cObjectTranslating& doing );
	void Redo( const cObjectRotating& doing );
	void Redo( const cObjectScaling& doing );

private:
	///  
	NiNodePtr mNiNode;

	///  
	/// õ   ǥϴµ Ѵ.
	NiLinesPtr mCircleLines;
	NiPoint3* mPosCoords;
	NiColorA* mColors;
	NiBool* mFlags;
	NiMaterialPropertyPtr mMatProp;
	NiVertexColorPropertyPtr mVertColorProp;
	NiWireframePropertyPtr mWireProp;

	/// õ   V
	cSelectedSet mSelectedSet;
};

inline
const NiPoint3& cObjectGroup::GetTranslate() const
{
	return mNiNode->GetTranslate();
}

inline
const NiMatrix3& cObjectGroup::GetRotate() const
{
	return mNiNode->GetRotate();
}

inline
float cObjectGroup::GetScale() const
{
	return mNiNode->GetScale();
}

inline
unsigned int cObjectGroup::GetSize() const
{
	return mSelectedSet.GetSize();
}

inline
bool cObjectGroup::IsEmpty() const
{
	return mSelectedSet.IsEmpty();
}

inline
const tHashSet<cStaticSceneNode*>& cObjectGroup::GetSelectedSet() const
{
	return mSelectedSet;
}

/// Ʈ 
/// ʻ Ʈ( ) ϰ
///  (*.scene) , εѴ.
class cObjectEditor
{
	static cObjectEditor* mSingleton;
	friend class cMapEditorView;
	friend class cObjectGroup;
	friend class cObjectCreating;
	friend class cObjectSelecting;
	friend class cObjectDeleting;
	friend class cObjectCopying;
	friend class cObjectTranslating;
	friend class cObjectRotating;
	friend class cObjectScaling;

public:
	cObjectEditor();
	~cObjectEditor();

	/// 
	void Clear();
	void ClearGarbage();

	/// 
	void Render( bool group );

	/// ʱȭ
	void Init();
	void Init( unsigned int gridSize, float metersPerVertex = 1.0f, unsigned int unitsPerMeter = 100 );
	void InitTree();

	/// ε
	bool Load( const cString& pathName );
	bool Add( const cString& pathName );
	bool LoadAreaGroup( const cString& pathName );
	bool LoadObjectTransformScript( const cString& pathName );

	/// 
	bool Save();
	bool SaveGlobalArea( cFileSaver& saver );
	bool SaveAs( const cString& pathName, bool objectAdded = true, bool lightAdded = true, bool soundAdded = true, bool areaAdded = true );
	bool SaveAreaAs( const cString& pathName );
	bool SaveObjectGroupAs( const cString& pathName );

	/// α
	void ExportLog( cStringTable& table, unsigned int& row, unsigned int divides );

	/// Ʈ ġ, ũ 
	void AdjustAllPos( float scale );
	void AdjustAllSize( float scale );

	/// Ʈ 
	bool CreateObject( const char* pathName );

	/// Ʈ ˻
	bool SelectObject( const char* pathName );
	bool Find( cStaticSceneNode* node );

	inline cObjectGroup* GetObjectGroup() { return mObjectGroup; }

	/// ŷ
	bool Pick( CPoint point, bool ctrl );

	/// 
	void SelectAll();
	void DeselectAll();

	/// Ʈ ׷
	void AttachGroupToTerrain( CPoint point );
	void AttachGroupToObject( CPoint point );
	void SetGroupTranslate( const NiPoint3& trans, bool updateDialog );
	void SetGroupRotate( float xangle, float yangle, float zangle, bool updateDialog );
	void SetGroupScale( float scale, bool updateDialog );
	void SetGroupAmbient( COLORREF rgb );
	void SetGroupDiffuse( COLORREF rgb );
	void SetGroupEmissive( COLORREF rgb );
	void SetGroupVisibleLevel( unsigned int level );
	void SetGroupOccludeLevel( unsigned int level );
	void SetGroupFogApplied( bool fogApplied );
	void SetGroupMaterialApplied( bool matApplied );
	void DeleteGroup();
	void CopyGroup();

	///  ̾α׸ 
	void UpdateInfoDialog();

	///
	void SetVisibleLevelToSiblings();
	void SetOccludeLevelToSiblings();
	void SetFogToSiblings();
	void SetMaterialToSiblings();
	void SetAmbientSiblings();
	void SetDiffuseSiblings();
	void SetEmissiveSiblings();

	/// ֺ
	void SetAmbientLightAmbient( unsigned int i, const NiColor& color );
	void SetAmbientLightDiffuse( unsigned int i, const NiColor& color );
	void SetAmbientLightDimmer( unsigned int i, float dimmer );
	NiAmbientLight* GetAmbientLight( unsigned int i ) const;

	/// Ȱ
	void SetFog( bool enabled, const NiColor& color, float depth );
	void SetFogColor( const NiColor& color );
	void SetFogDepth( float depth );

	/// ̾α׸ 
	void SetTransformDialog( cObjectTransformDialog* dlg );
	void SetPropertyDialog( cObjectPropertyDialog* dlg );
	void SetInfoDialog( cObjectInfoDialog* dlg );

	///  ̸ 
	const cString& GetPathName() const;

private:
	/// Undo
	void Undo( const cObjectCreating& doing );
	void Undo( const cObjectSelecting& doing );
	void Undo( const cObjectDeleting& doing );
	void Undo( const cObjectCopying& doing );
	void Undo( const cObjectTranslating& doing );
	void Undo( const cObjectRotating& doing );
	void Undo( const cObjectScaling& doing );

	/// Redo
	void Redo( const cObjectCreating& doing );
	void Redo( const cObjectSelecting& doing );
	void Redo( const cObjectDeleting& doing );
	void Redo( const cObjectCopying& doing );
	void Redo( const cObjectTranslating& doing );
	void Redo( const cObjectRotating& doing );
	void Redo( const cObjectScaling& doing );

	/// ش  带 
	bool Kill( cStaticSceneNode* node );

	/// ش  带 Ȱ
	void Rebirth( cStaticSceneNode* node );

	/// ش  带 
	///  ο  带 Ѵ.
	cStaticSceneNode* Clone( cStaticSceneNode* node );

	/// ޽ ó
	void OnMouseMove( CPoint point );
	void OnLButtonDown_Transform( CPoint point, bool ctrl );
	void OnRButtonDown_Transform( CPoint point, bool ctrl );
	void OnKeyDown( UINT c );

public:
	/// ü 
	static cObjectEditor* GetSingleton();

protected:
	///  ̾α
	cObjectTransformDialog* mTransformDialog;

	/// Ӽ ̾α
	cObjectPropertyDialog* mPropertyDialog;

	///  ̾α
	cObjectInfoDialog* mInfoDialog;

	///    V
	typedef tHashSet<cStaticSceneNode*> cCreatedSet;
	cCreatedSet mCreatedSet;

	///    V
	typedef tHashSet<cStaticSceneNode*> cDestroyedSet;
	cDestroyedSet mDestroyedSet;

	/// ŷ   迭
	typedef tArray<cSceneNode*> cPickedArray;
	cPickedArray mPickedArray;

	/// ׷ Ʈ
	cObjectGroup* mObjectGroup;

	/// 콺 ǥ
	CPoint mMousePos;

	///  ̸
	cString mPathName;
};

inline
void cObjectEditor::SetTransformDialog( cObjectTransformDialog* dlg )
{
	assert( dlg );

	mTransformDialog = dlg;
}

inline
void cObjectEditor::SetPropertyDialog( cObjectPropertyDialog* dlg )
{
	assert( dlg );

	mPropertyDialog = dlg;
}

inline
void cObjectEditor::SetInfoDialog( cObjectInfoDialog* dlg )
{
	assert( dlg );

	mInfoDialog = dlg;
}

inline
const cString& cObjectEditor::GetPathName() const
{
	return mPathName;
}

inline
cObjectEditor* cObjectEditor::GetSingleton()
{
	return mSingleton;
}

#define OBJECTEDIT cObjectEditor::GetSingleton()
