#include "stdafx.h"
#include "ObjectEditor.h"

#include "MainFrame.h"
#include "MapEditorView.h"
#include "ObjectInfoDialog.h"

#include "Engine/StaticSceneNode.h"

#include "Doing/DoingManager.h"
#include "Doing/ObjectCopying.h"

void cObjectEditor::CopyGroup()
{
	if( mObjectGroup->IsEmpty() )
		return;

	///  ϸ鼭   
	typedef tHashSet<cStaticSceneNode*> cSelectedSet;
	const cSelectedSet& selectedSet = mObjectGroup->GetSelectedSet();

	unsigned int numNodes = selectedSet.GetSize();

	cObjectCopyingInfo undo;
	undo.mNumObjects = numNodes;
	cStaticSceneNode** p = undo.mNodes = new cStaticSceneNode*[numNodes];

	cSelectedSet::cConstIterator i = selectedSet.Begin();
	cSelectedSet::cConstIterator end = selectedSet.End();

	for( ; i != end; ++i, ++p )
	{
		cStaticSceneNode* n = Clone( (cStaticSceneNode*)(*i) );
		assert( n && "failed to clone object" );

		*p = n;
	}

	///   ߰
	DOINGMAN->PushObjectCopying( undo );

	///  ׷ ġ ̵
	SetGroupTranslate( mObjectGroup->GetTranslate() + NiPoint3(0.0f, 0.0f, 300.0f), true );

	/// 並 
	VIEW->Update();

	///  θ 
	MAIN->SetSceneModified( true );

	///  ̾α׸ 
	mInfoDialog->UpdateNumObjects( mCreatedSet.GetSize() );
}

void cObjectEditor::Undo( const cObjectCopying& doing )
{
	/// Ʈ 
	unsigned int numNodes = doing.mNumObjects;
	cStaticSceneNode** p = doing.mNodes;

	for( unsigned int i = 0; i < numNodes; ++i, ++p )
	{
		OBJECTEDIT->Kill( *p );
	}
}

void cObjectEditor::Redo( const cObjectCopying& doing )
{
	///  Ʈ ٽ 츲 -_-;
	unsigned int numNodes = doing.mNumObjects;
	cStaticSceneNode** p = doing.mNodes;

	for( unsigned int i = 0; i < numNodes; ++i, ++p )
	{
		OBJECTEDIT->Rebirth( *p );
	}
}
