#include "stdafx.h"
#include "ObjectEditor.h"

#include "MainFrame.h"
#include "MapEditorView.h"
#include "ObjectTransformDialog.h"
#include "ObjectPropertyDialog.h"
#include "ObjectInfoDialog.h"

#include "Doing/DoingManager.h"
#include "Doing/ObjectCreating.h"

#include "Engine/SceneManager.h"
#include "Engine/StaticSceneNode.h"

bool cObjectEditor::CreateObject( const char* pathName )
{
	///  θ 
	cString path;
	GetFilePath( &path, pathName );
	SetCurrentDirectory( path.Cstr() );

	///  带 
	cStaticSceneNodeParam param;
	param.mPathName = pathName;
	cStaticSceneNode* n = SCENEMAN->CreateStatic( param );

	if( n )
	{
		///   
		cObjectCreatingInfo undo;
		undo.mNode = n;

		///   ߰
		DOINGMAN->PushObjectCreating( undo );

		///  V ߰
		mCreatedSet.Insert( n );

		///  Ʈ 
		mObjectGroup->Select( n, false );
		mTransformDialog->UpdateObject( mObjectGroup );
		mPropertyDialog->UpdateObject( mObjectGroup );

		/// 並 
		VIEW->Update();

		///  θ 
		MAIN->SetSceneModified( true );

		///  ̾α׸ 
		mInfoDialog->UpdateNumObjects( mCreatedSet.GetSize() );
	}
	return n != 0;
}

void cObjectEditor::Undo( const cObjectCreating& doing )
{
	/// Ʈ 
	Kill( doing.mUndo.mNode );
}

void cObjectEditor::Redo( const cObjectCreating& doing )
{
	///  Ʈ ٽ 츲 -_-;
	Rebirth( doing.mUndo.mNode );
}
