#include "stdafx.h"
#include "ObjectEditor.h"

#include "MapEditorView.h"
#include "ObjectTransformDialog.h"
#include "ObjectPropertyDialog.h"

#include "Doing/DoingManager.h"
#include "Doing/ObjectSelecting.h"

#include "Engine/StaticSceneNode.h"

void cObjectGroup::Select( cStaticSceneNode* node, bool ctrl )
{
	assert( node );

	/// ̹ õǾ ˻
	bool alreadySelected = false;
	cSelectedSet::cIterator i = mSelectedSet.Find( node );

	if( i != mSelectedSet.End() )
		alreadySelected = true;

	if( mSelectedSet.GetSize() == 1 && alreadySelected == true )
		return;

	/// Undo  
	cObjectSelectingInfo undo;
	CollectUnSelecting( &undo );
	
	///  Ż
	DetachAll();

	/// õ 带 ߰ Ǵ 
	if( ctrl == false )
	{
		mSelectedSet.Clear();
		mSelectedSet.Insert( node );
	}
	else
	{
		if( alreadySelected )
			mSelectedSet.Erase( i );
		else
			mSelectedSet.Insert( node );
	}

	///  
	AttachAll();

	/// Redo  
	cObjectSelectingInfo redo;
	CollectReSelecting( &redo );

	///   ߰
	DOINGMAN->PushObjectSelecting( undo, redo );
}

void cObjectGroup::Select( const tHashSet<cStaticSceneNode*>& nodeSet )
{
	/// Undo  
	cObjectSelectingInfo undo;
	CollectUnSelecting( &undo );

	///  Ż
	DetachAll();

	/// õ 带  
	mSelectedSet.Clear();

	///  ߰
	typedef tHashSet<cStaticSceneNode*> cNodeSet;
	cNodeSet::cConstIterator i = nodeSet.Begin();
	cNodeSet::cConstIterator end = nodeSet.End();

	for( ; i != end; ++i )
	{
		mSelectedSet.Insert( *i );
	}

	///  
	AttachAll();

	/// Redo  
	cObjectSelectingInfo redo;
	CollectReSelecting( &redo );

	///   ߰
	DOINGMAN->PushObjectSelecting( undo, redo );
}

void cObjectGroup::Deselect()
{
	/// Undo  
	cObjectSelectingInfo undo;
	CollectUnSelecting( &undo );

	///  Ż
	DetachAll();

	/// õ 带  
	mSelectedSet.Clear();

	/// Redo  
	cObjectSelectingInfo redo;
	CollectReSelecting( &redo );

	///   ߰
	DOINGMAN->PushObjectSelecting( undo, redo );
}

void cObjectGroup::CollectUnSelecting( cObjectSelectingInfo* pundo )
{
	assert( pundo && "null doing info" );

	unsigned int numNodes = mSelectedSet.GetSize();

	if( numNodes == 0 )
	{
		pundo->mTranslate = mNiNode->GetTranslate();
		pundo->mRotate = mNiNode->GetRotate();
		pundo->mScale = mNiNode->GetScale();
	}
	else
	{
		pundo->mTranslate = mNiNode->GetTranslate();
		pundo->mRotate = mNiNode->GetRotate();
		pundo->mScale = mNiNode->GetScale();
		pundo->mNumObjects = numNodes;
		cObjectSelectingInfo::cObjectInfo* p = pundo->mObjectInfos = new cObjectSelectingInfo::cObjectInfo[numNodes];

		cSelectedSet::cIterator i = mSelectedSet.Begin();
		cSelectedSet::cIterator end = mSelectedSet.End();

		for( ; i != end; ++i, ++p )
		{
			cStaticSceneNode* n = *i;

			p->mNode = n;
			p->mTranslate = n->GetTranslate();
			p->mRotate = n->GetRotate();
			p->mScale = n->GetScale();
		}
	}
}

void cObjectGroup::CollectReSelecting( cObjectSelectingInfo* predo )
{
	assert( predo && "null doing info" );

	unsigned int numNodes = mSelectedSet.GetSize();

	if( numNodes == 0 )
	{
		predo->mTranslate = mNiNode->GetTranslate();
		predo->mRotate = mNiNode->GetRotate();
		predo->mScale = mNiNode->GetScale();
	}
	else
	{
		predo->mTranslate = mNiNode->GetTranslate();
		predo->mRotate = mNiNode->GetRotate();
		predo->mScale = mNiNode->GetScale();
		predo->mNumObjects = numNodes;
		cObjectSelectingInfo::cObjectInfo* p = predo->mObjectInfos = new cObjectSelectingInfo::cObjectInfo[numNodes];

		cSelectedSet::cIterator i = mSelectedSet.Begin();
		cSelectedSet::cIterator end = mSelectedSet.End();

		for( ; i != end; ++i, ++p )
		{
			cStaticSceneNode* n = *i;

			p->mNode = n;
			p->mTranslate = n->GetTranslate();
			p->mRotate = n->GetRotate();
			p->mScale = n->GetScale();
		}
	}
}

void cObjectGroup::Undo( const cObjectSelecting& doing )
{
	/// 
	DetachAll();
	mSelectedSet.Clear();

	/// Undo
	const cObjectSelectingInfo& undo = doing.mUndo;
	mNiNode->SetTranslate( undo.mTranslate );
	mNiNode->SetRotate( undo.mRotate );
	mNiNode->SetScale( undo.mScale );

	unsigned int numNodes = undo.mNumObjects;
	cObjectSelectingInfo::cObjectInfo* p = undo.mObjectInfos;

	for( unsigned int i = 0; i < numNodes; ++i, ++p )
	{
		cStaticSceneNode* n = p->mNode;

		mSelectedSet.Insert( n );
		mNiNode->AttachChild( n->GetNiObject() );

		n->SetTranslate( p->mTranslate );
		n->SetRotate( p->mRotate );
		n->SetScale( p->mScale );
	}

	mNiNode->Update( 0.0f );
}

void cObjectGroup::Redo( const cObjectSelecting& doing )
{
	/// 
	DetachAll();
	mSelectedSet.Clear();

	/// Redo
	const cObjectSelectingInfo& redo = doing.mRedo;
	mNiNode->SetTranslate( redo.mTranslate );
	mNiNode->SetRotate( redo.mRotate );
	mNiNode->SetScale( redo.mScale );

	unsigned int numNodes = redo.mNumObjects;
	cObjectSelectingInfo::cObjectInfo* p = redo.mObjectInfos;

	for( unsigned int i = 0; i < numNodes; ++i, ++p )
	{
		cStaticSceneNode* n = p->mNode;

		mSelectedSet.Insert( n );
		mNiNode->AttachChild( n->GetNiObject() );

		n->SetTranslate( p->mTranslate );
		n->SetRotate( p->mRotate );
		n->SetScale( p->mScale );
	}

	mNiNode->Update( 0.0f );
}

bool cObjectEditor::SelectObject( const char* pathName )
{
	cString fileName;
	::GetFileName( &fileName, pathName );

	bool found = false;
	bool first = true;
	cCreatedSet::cIterator i = mCreatedSet.Begin();
	cCreatedSet::cIterator iend = mCreatedSet.End();

	for( ; i != iend; ++i )
	{
		cStaticSceneNode* n = *i;

		if( n->GetFileName() == fileName )
		{
			found = true;

			if( first )
			{
				first = false;
				mObjectGroup->Select( n, false );
			}
			else
			{
				mObjectGroup->Select( n, true );
			}
		}
	}

	if( found )
	{
		/// 並 
		VIEW->Update();

		/// ̾α׸ 
		mTransformDialog->UpdateObject( mObjectGroup );
		mPropertyDialog->UpdateObject( mObjectGroup );
	}

	return found;
}

void cObjectEditor::SelectAll()
{
	if( mCreatedSet.IsEmpty() == false )
	{
		mObjectGroup->Select( mCreatedSet );
		mTransformDialog->UpdateObject( mObjectGroup );
		mPropertyDialog->UpdateObject( mObjectGroup );
	}
}

void cObjectEditor::DeselectAll()
{
	if( mCreatedSet.IsEmpty() == false && mObjectGroup->GetSize() > 0 )
	{
		mObjectGroup->Deselect();
		mTransformDialog->UpdateObject( mObjectGroup );
		mPropertyDialog->UpdateObject( mObjectGroup );
	}
}

void cObjectEditor::Undo( const cObjectSelecting& doing )
{
	mObjectGroup->Undo( doing );
	mTransformDialog->UpdateObject( mObjectGroup );
	mPropertyDialog->UpdateObject( mObjectGroup );
}

void cObjectEditor::Redo( const cObjectSelecting& doing )
{
	mObjectGroup->Redo( doing );
	mTransformDialog->UpdateObject( mObjectGroup );
	mPropertyDialog->UpdateObject( mObjectGroup );
}
