#include "stdafx.h"
#include "SoundDialog.h"

#include "Resource.h"
#include "TabWindow.h"
#include "SoundTransformDialog.h"
#include "SoundPropertyDialog.h"
#include "SoundInfoDialog.h"

IMPLEMENT_DYNAMIC(cSoundDialog, CDialog)

BEGIN_MESSAGE_MAP(cSoundDialog, CDialog)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_WM_SIZE()
END_MESSAGE_MAP()

cSoundDialog::cSoundDialog()
: mTransformDialog( 0 )
, mPropertyDialog( 0 )
, mInfoDialog( 0 )
{
}

cSoundDialog::~cSoundDialog()
{
}

int cSoundDialog::OnCreate( LPCREATESTRUCT cs )
{
	if( CDialog::OnCreate(cs) == -1 )
		return -1;

	/// η縶  
	mRollupWnd.Create( WS_VISIBLE | WS_CHILD, CRect(4, 4, 220, 400), this, 1 );

	///  ġ  ߰
	mTransformDialog = new cSoundTransformDialog;
	mTransformDialog->Create( MAKEINTRESOURCE(IDD_DIALOG_SOUND_TRANSFORM), &mRollupWnd );
	mRollupWnd.InsertPage( "Transform", mTransformDialog );

	///  Ӽ  ߰
	mPropertyDialog = new cSoundPropertyDialog;
	mPropertyDialog->Create( MAKEINTRESOURCE(IDD_DIALOG_SOUND_PROPERTY), &mRollupWnd );
	mRollupWnd.InsertPage( "Property", mPropertyDialog );

	///    ߰
	mInfoDialog = new cSoundInfoDialog;
	mInfoDialog->Create( MAKEINTRESOURCE(IDD_DIALOG_SOUND_INFO), &mRollupWnd );
	mRollupWnd.InsertPage( "Info", mInfoDialog );

	mRollupWnd.ExpandAllPages();
	return 0;
}

void cSoundDialog::OnClose()
{
	TABWIN->SetButtonChecked( IDC_BUTTON_TAB_SOUND, false );
	CDialog::OnClose();
}

void cSoundDialog::OnSize( UINT type, int cx, int cy )
{
	CDialog::OnSize( type, cx, cy );
	mRollupWnd.Resize( type, cx, cy );
}
