/* ==========================================================================
*    : ̼
*    : 2006.12.13
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

class cSceneNode;
class cSoundSceneNode;
class cSoundTransformDialog;
class cSoundPropertyDialog;
class cSoundInfoDialog;

///  
/// ʻ  Ѵ.
class cSoundEditor
{
	static cSoundEditor* mSingleton;
	friend class cMapEditorView;
	friend class cObjectEditor;

public:
	cSoundEditor();
	~cSoundEditor();

	/// 
	void Clear();

	/// 
	void Render();

	/// ʱȭ
	void Init();

	///// ε
	bool Load( const cString& pathName );

	///// 
	bool Save();
	bool SaveAs( const cString& pathName );

	/// 
	bool Save( cFileSaver& saver );

	/// 带 
	bool CreateSound( const char* pathName );

	/// ŷ
	bool Pick( CPoint point );

	/// 
	void DeselectAll();

	/// 带  
	void AttachSoundToTerrain( CPoint point );

	/// 带 Ʈ 
	void AttachSoundToObject( CPoint point );

	/// 带 
	void DeleteSound();

	/// 带 
	void CopySound();

	///  ̾α׸ 
	void UpdateInfoDialog();

	///  ̵
	void SetSoundTranslate( const NiPoint3& trans, bool updateDialog );

	///  
	void SetSoundRadius( float scale, bool updateDialog );

	///   Ÿ
	void SetSoundAttenDistance( float dist, bool updateDialog );

	///  Ӽ
	void SetSoundLoopCount( int count );
	void SetSoundLoopInterval( float interval );
	void SetSoundVolumeRatio( float ratio );

	/// ̾α
	void SetTransformDialog( cSoundTransformDialog* dlg );
	void SetPropertyDialog( cSoundPropertyDialog* dlg );
	void SetInfoDialog( cSoundInfoDialog* dlg );

	///  ̸ 
	const cString& GetPathName() const;

	///  
	unsigned int GetNumSounds() const;

private:
	/// ش 带 
	bool Kill( cSoundSceneNode* node );

	/// ش 带 
	///  ο 带 Ѵ.
	cSoundSceneNode* Clone( cSoundSceneNode* node );

	/// ޽ ó
	void OnMouseMove( CPoint point );
	void OnLButtonDown_Transform( CPoint point );
	void OnRButtonDown_Transform( CPoint point, bool ctrl );
	void OnKeyDown( UINT c );

public:
	/// ü 
	static cSoundEditor* GetSingleton();

protected:
	/// ġ ̾α
	cSoundTransformDialog* mTransformDialog;

	/// Ӽ ̾α
	cSoundPropertyDialog* mPropertyDialog;

	///  ̾α
	cSoundInfoDialog* mInfoDialog;

	///   V
	typedef tHashSet<cSoundSceneNode*> cCreatedSet;
	cCreatedSet mCreatedSet;

	/// ŷ  迭
	typedef tArray<cSceneNode*> cPickedArray;
	cPickedArray mPickedArray;

	/// õ 
	cSoundSceneNode* mSelectedNode;

	///  
	///   ǥϴµ Ѵ.
	NiLinesPtr mCircleLines;
	NiPoint3* mPosCoords;
	NiBool* mFlags;
	NiMaterialPropertyPtr mMatProp;
	NiVertexColorPropertyPtr mVertColorProp;
	NiWireframePropertyPtr mWireProp;

	/// 콺 ǥ
	CPoint mMousePos;

	///  ̸
	cString mPathName;
};

inline
void cSoundEditor::SetTransformDialog( cSoundTransformDialog* dlg )
{
	assert( dlg && "null sound transform dialog" );

	mTransformDialog = dlg;
}

inline
void cSoundEditor::SetPropertyDialog( cSoundPropertyDialog* dlg )
{
	assert( dlg && "null sound property dialog" );

	mPropertyDialog = dlg;
}

inline
void cSoundEditor::SetInfoDialog( cSoundInfoDialog* dlg )
{
	assert( dlg && "null sound info dialog" );

	mInfoDialog = dlg;
}

inline
unsigned int cSoundEditor::GetNumSounds() const
{
	return mCreatedSet.GetSize();
}

inline
cSoundEditor* cSoundEditor::GetSingleton()
{
	return mSingleton;
}

inline
const cString& cSoundEditor::GetPathName() const
{
	return mPathName;
}

#define SOUNDEDIT cSoundEditor::GetSingleton()
