/* ==========================================================================
*    : ̼
*    : 2007.01.08
*      :  Ӽ ̾α
* ǻ : 
*===========================================================================*/
#pragma once

#include "Resource.h"
#include "UI/NumericEdit.h"

class cSoundSceneNode;

///  Ӽ ̾α
class cSoundPropertyDialog : public CDialog
{
	DECLARE_DYNAMIC(cSoundPropertyDialog)

public:
	cSoundPropertyDialog();
	virtual ~cSoundPropertyDialog();

	///   
	void UpdateSound( const char* name, unsigned int loopCount, float interval, float volume );

	/// Ȱȭ θ 
	void SetEnabled( bool enabled );

protected:
	virtual void DoDataExchange( CDataExchange* dx );
	BOOL OnInitDialog();

protected:
	DECLARE_MESSAGE_MAP()
	afx_msg LRESULT OnChangedValue( WPARAM id, LPARAM );

private:
	/// ݺ Ƚ
	cNumericEdit mLoopCountEdit;

	///  
	cNumericEdit mIntervalEdit;

	/// 
	cNumericEdit mVolumeRatioEdit;
};

inline
void cSoundPropertyDialog::SetEnabled( bool enabled )
{
	if( enabled )
	{
		mLoopCountEdit.SetEnabled( true );
		mIntervalEdit.SetEnabled( true );
		mVolumeRatioEdit.SetEnabled( true );
	}
	else
	{
		GetDlgItem(IDC_EDIT_SPROP_NAME)->SetWindowText( "" );

		mLoopCountEdit.SetValue( 0.0f );
		mLoopCountEdit.SetEnabled( false );

		mIntervalEdit.SetValue( 0.0f );
		mIntervalEdit.SetEnabled( false );

		mVolumeRatioEdit.SetValue( 0.0f );
		mVolumeRatioEdit.SetEnabled( false );
	}
}
