/* ==========================================================================
*    : ̼
*    : 2006.12.07
*      :  ġ ̾α
* ǻ : 
*===========================================================================*/
#pragma once

#include "UI/Dialog.h"
#include "UI/Button.h"
#include "UI/CheckButton.h"
#include "UI/CheckButtonGroup.h"
#include "UI/NumericEdit.h"

class cGroupSound;

///  ġ ̾α
class cSoundTransformDialog : public cDialog
{
	DECLARE_DYNAMIC(cSoundTransformDialog)

public:
	cSoundTransformDialog();
	virtual ~cSoundTransformDialog();

	void SetCheckedButton( int id );
	unsigned int GetCheckedButton() const;

	///   
	void UpdateSound( const NiPoint3& translate, float radius, float attenDist );

	/// Ȱȭ θ 
	void SetEnabled( bool enabled );

	/// ġ
	NiPoint3 GetTranslate() const;

	/// 
	float GetRadius() const;

	///  Ÿ
	float GetAttenDistance() const;

protected:
	virtual void DoDataExchange( CDataExchange* dx );
	BOOL OnInitDialog();

protected:
	DECLARE_MESSAGE_MAP()
	afx_msg void OnClickedButton();
	afx_msg LRESULT OnChangedTransform( WPARAM id, LPARAM );

private:
	/// ư
	cCheckButton mPickButton;
	cCheckButton mAttachToTerrainButton;
	cCheckButton mAttachToObjectButton;
	cCheckButtonGroup mButtonGroup;

	///  Ʈ
	cNumericEdit mTxEdit;
	cNumericEdit mTyEdit;
	cNumericEdit mTzEdit;
	cNumericEdit mRadiusEdit;
	cNumericEdit mAttenDistEdit;
};

inline
void cSoundTransformDialog::SetEnabled( bool enabled )
{
	if( enabled )
	{
		mTxEdit.SetEnabled( true );
		mTyEdit.SetEnabled( true );
		mTzEdit.SetEnabled( true );
		mRadiusEdit.SetEnabled( true );
		mAttenDistEdit.SetEnabled( true );
	}
	else
	{
		mTxEdit.SetValue( 0.0f );
		mTyEdit.SetValue( 0.0f );
		mTzEdit.SetValue( 0.0f );
		mRadiusEdit.SetValue( 0.0f );
		mAttenDistEdit.SetValue( 0.0f );

		mTxEdit.SetEnabled( false );
		mTyEdit.SetEnabled( false );
		mTzEdit.SetEnabled( false );
		mRadiusEdit.SetEnabled( false );
		mAttenDistEdit.SetEnabled( false );
	}
}

inline
NiPoint3 cSoundTransformDialog::GetTranslate() const
{
	float x = mTxEdit.GetValue() * 100.0f;
	float y = mTyEdit.GetValue() * 100.0f;
	float z = mTzEdit.GetValue() * 100.0f;
	return NiPoint3( x, y, z );
}

inline
float cSoundTransformDialog::GetRadius() const
{
	return mRadiusEdit.GetValue() * 100.0f;
}

inline
float cSoundTransformDialog::GetAttenDistance() const
{
	return mAttenDistEdit.GetValue() * 100.0f;
}
