/* ==========================================================================
*    : ̼
*    : 2006.12.06
*      :   ̾α
* ǻ : 
*===========================================================================*/
#pragma once

#include "UI/Dialog.h"
#include "UI/Button.h"
#include "UI/CheckButton.h"
#include "UI/CheckButtonGroup.h"

#include "Resource.h"

///   ̾α
class cTerrainBuildDialog : public cDialog
{
	DECLARE_DYNAMIC(cTerrainBuildDialog)

public:
	cTerrainBuildDialog();
	virtual ~cTerrainBuildDialog();

	/// 
	void UpdateInnerRadius( float radius );
	void UpdateOuterRadius( float radius );

	/// ư
	void SetCheckedButton( int id );
	unsigned int GetCheckedButton() const;

	/// ŷ ġ
	void SetPickPos( const NiPoint3& pos );

	///  (: meter)
	float GetInnerRadius() const;
	float GetOuterRadius() const;

	///  (: percent)
	unsigned int GetStrength() const;

	///   (: percent)
	unsigned int GetSmoothRatio() const;

protected:
	void DoDataExchange( CDataExchange* dx );
	BOOL OnInitDialog();

protected:
	DECLARE_MESSAGE_MAP()
	afx_msg void OnClickedButton();
	afx_msg void OnClickedSyncAllButton();
	afx_msg void OnHScroll( UINT code, UINT pos, CScrollBar* bar );

private:
	/// ư
	cCheckButton mRaiseButton;
	cCheckButton mLowerButton;
	cCheckButton mFlattenButton;
	cCheckButton mSmoothButton;
	cCheckButton mSyncButton;
	cCheckButton mSyncToPickPosButton;
	cCheckButtonGroup mGroup;

	cButton mSyncAllButton;
};

inline
unsigned int cTerrainBuildDialog::GetCheckedButton() const
{
	cCheckButton* btn = mGroup.GetCheckedButton();

	if( btn == 0 )
		return 0;
	else
		return btn->GetDlgCtrlID();
}

inline
float cTerrainBuildDialog::GetInnerRadius() const
{
	CSliderCtrl* slider = (CSliderCtrl*)GetDlgItem( IDC_SLIDER_TBUILD_INNER_RADIUS );
	return slider->GetPos() / 10.0f;
}

inline
float cTerrainBuildDialog::GetOuterRadius() const
{
	CSliderCtrl* slider = (CSliderCtrl*)GetDlgItem( IDC_SLIDER_TBUILD_OUTER_RADIUS );
	return slider->GetPos() / 10.0f;
}

inline
unsigned int cTerrainBuildDialog::GetStrength() const
{
	CSliderCtrl* slider = (CSliderCtrl*)GetDlgItem( IDC_SLIDER_TBUILD_STRENGTH );
	return slider->GetPos();
}

inline
unsigned int cTerrainBuildDialog::GetSmoothRatio() const
{
	CSliderCtrl* slider = (CSliderCtrl*)GetDlgItem( IDC_SLIDER_TBUILD_SMOOTH_RATIO );
	return slider->GetPos();
}
