/* ==========================================================================
*    : ̼
*    : 2006.12.13
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

#include "Lines.h"

class cBox;
class cFreeCamera;
class cSceneNode;
class cTerrainLeafNode;
class cTerrainBuildDialog;
class cTerrainPaintDialog;
class cTerrainOptionDialog;
class cTerrainInfoDialog;
class cStringTable;

///   
enum eTerrainViewMode
{
	eTERRAIN_VIEW_WIREFRAME,
	eTERRAIN_VIEW_SOLID,
	eTERRAIN_VIEW_TEXTURED,
	eTERRAIN_VIEW_WIRETEXTURED
};

/// Ÿ ׷
/// õ    ϳ   Ѵ.
class cTileGroup
{
	friend class cTerrainEditor;

public:
	cTileGroup();
	~cTileGroup();

	/// 
	void Clear();

	/// 
	void Render();

	///  带 
	bool Select( cTerrainLeafNode* node );
	bool Add( cTerrainLeafNode* node );
	bool Remove( cTerrainLeafNode* node );

	///  ؽó
	int GetTextureIndex0() const;
	int GetTextureIndex1() const;
	int GetTextureIndex2() const;

	///  ڸ 
	cBox GetBoundBox() const;

	///    
	unsigned int GetSize() const;

	/// ִ θ 
	bool IsEmpty() const;

	/// õ   V 
	const tHashSet<cTerrainLeafNode*>& GetSelectedSet() const;

private:
	///  
	void SetVisible( bool visible );

	///  ؽó
	void SetDetailTextures( unsigned int index0, unsigned int index1, unsigned int index2 );

private:
	///  
	/// õ   ǥϴµ Ѵ.
	NiLinesPtr mBoxLines;
	NiPoint3* mPosCoords;
	NiBool* mFlags;
	NiMaterialPropertyPtr mMatProp;
	NiWireframePropertyPtr mWireProp;

	/// õ   V
	typedef tHashSet<cTerrainLeafNode*> cSelectedSet;
	cSelectedSet mSelectedSet;
};

inline
unsigned int cTileGroup::GetSize() const
{
	return mSelectedSet.GetSize();
}

inline
bool cTileGroup::IsEmpty() const
{
	return mSelectedSet.IsEmpty();
}

inline
const tHashSet<cTerrainLeafNode*>& cTileGroup::GetSelectedSet() const
{
	return mSelectedSet;
}

///  
/// ʻ    ϰ
///  (*.terrain) , εѴ.
class cTerrainEditor
{
	static cTerrainEditor* mSingleton;
	friend class cMapEditorView;

public:
	cTerrainEditor();
	~cTerrainEditor();

	/// 
	void Clear();

	/// ó
	void Process();

	/// 
	void Render( bool group );

	/// ʱȭ
	void Init( unsigned int resolution, float metersPerVertex = 1.0f, unsigned int unitsPerMeter = 100 );

	/// ε
	bool Load( const cString& pathName );

	/// 
	bool Save();
	bool SaveAs( const cString& pathName );

	/// α
	void ExportLog( cStringTable& table, unsigned int& row );

	///  ī޶
	void ZoomPersp( cFreeCamera* cam );
	void ZoomOrtho( cFreeCamera* cam );

	/// ̸
	void ClearHeightMap();
	bool ImportHeightMap( const cString& pathName );
	bool ExportHeightMap( const cString& pathName );

	/// ĸ
	void ClearAlphaMap();
	bool ImportAlphaMap( const cString& pathName );
	bool ExportAlphaMap( const cString& pathName );

	/// 
	void ClearColorMap();
	bool ImportColorMap( const cString& pathName );
	bool ExportColorMap( const cString& pathName );

	/// 
	void AdjustHeight( float scale );

	/// ׺޽
	void SyncAllToNaviMesh();

	/// ̾α
	void SetBuildDialog( cTerrainBuildDialog* dlg );
	void SetPaintDialog( cTerrainPaintDialog* dlg );
	void SetOptionDialog( cTerrainOptionDialog* dlg );
	void SetInfoDialog( cTerrainInfoDialog* dlg );

	/// Level of detail
	void SetLodEnabled( bool enabled );

	///  
	void SetVisible( bool visible );

	/// ؽó
	bool LoadTexture( const cString& pathName );
	void UnLoadTexture( unsigned int index );
	void SetDetailTextures( unsigned int index0, unsigned int index1, unsigned int index2 );
	void SetDetailTexturesToAll( unsigned int index0, unsigned int index1, unsigned int index2 );

	/// ֺ
	void SetAmbientLightAmbient( const NiColor& color );
	void SetAmbientLightDiffuse( const NiColor& color );
	void SetAmbientLightDimmer( float dimmer );
	NiAmbientLight* GetAmbientLight() const;

	/// Ȱ
	void SetFog( bool enabled, const NiColor& color, float depth );
	void SetFogColor( const NiColor& color );
	void SetFogDepth( float depth );

	///  
	void SetViewMode( eTerrainViewMode viewMode );

	/// ŷ ġ  
	void SetPickPosChanged( bool changed );

	///  ̸
	const cString& GetPathName() const;

	/// ػ
	unsigned int GetResolution() const;

	///  ͼ
	float GetMetersPerVertex() const;

	/// ʹ 
	unsigned int GetUnitsPerMeter() const;

private:
	/// ޽ ó
	void OnTimer_Build();
	void OnTimer_Paint();
	void OnMouseMove_Build( CPoint point );
	void OnMouseMove_Paint( CPoint point );
	void OnLButtonDown_Build( CPoint point );
	void OnLButtonDown_Paint( CPoint point );
	void OnLButtonUp();
	void OnKeyDown( UINT c );

public:
	/// ü
	static cTerrainEditor* GetSingleton();

protected:
	/// ̾α
	cTerrainBuildDialog* mBuildDialog;
	cTerrainPaintDialog* mPaintDialog;
	cTerrainOptionDialog* mOptionDialog;
	cTerrainInfoDialog* mInfoDialog;

	/// ŷ   迭
	typedef tArray<cSceneNode*> cPickedArray;
	cPickedArray mPickedArray;

	/// ׷ 
	cTileGroup* mGroup;

	///  
	bool mDrawing;

	/// ŷ ġ
	NiPoint3 mPickPos;
	NiPoint3 mPickOldPos;
	bool mPickPosChanged;

	///  
	///   ǥϴµ Ѵ.
	cCircleLines mInnerLines;
	cCircleLines mOuterLines;

	/// 콺 ǥ
	CPoint mMousePos;

	///  ̸
	cString mPathName;
};

inline
void cTerrainEditor::SetBuildDialog( cTerrainBuildDialog* dlg )
{
	assert( dlg );

	mBuildDialog = dlg;
}

inline
void cTerrainEditor::SetPaintDialog( cTerrainPaintDialog* dlg )
{
	assert( dlg );

	mPaintDialog = dlg;
}

inline
void cTerrainEditor::SetOptionDialog( cTerrainOptionDialog* dlg )
{
	assert( dlg );

	mOptionDialog = dlg;
}

inline
void cTerrainEditor::SetInfoDialog( cTerrainInfoDialog* dlg )
{
	assert( dlg );

	mInfoDialog = dlg;
}

inline
void cTerrainEditor::SetPickPosChanged( bool changed )
{
	mPickPosChanged = changed;
}

inline
const cString& cTerrainEditor::GetPathName() const
{
	return mPathName;
}

inline
cTerrainEditor* cTerrainEditor::GetSingleton()
{
	return mSingleton;
}

#define TERRAINEDIT	cTerrainEditor::GetSingleton()
