#include "stdafx.h"
#include "TerrainEditor.h"

#include "StringTable.h"
#include "Engine/Terrain.h"

void cTerrainEditor::ExportLog( cStringTable& table, unsigned int& row )
{
	unsigned int resolution = TERRAIN->GetCellCount();
	table.SetValue( ++row, 0, "-----   -----" );

	table.SetValue( ++row, 0, "[ ̸]" );
	table.SetValue( row, 1, mPathName );
	table.SetValue( ++row, 0, "[ػ]" );
	table.SetValue( row, 1, resolution );
	table.SetValue( ++row, 0, "[ ]" );
	table.SetValue( row, 1, TERRAIN->GetMetersPerVertex() );
	table.SetValue( ++row, 0, "[ ũ]" );
	table.SetValue( row, 1, resolution * TERRAIN->GetMetersPerVertex() );

	table.SetValue( ++row, 0, "[Ÿ ؽó]" );

	/// ؽó 迭 
	for( unsigned int i = 0; i < TERRAIN_TEXTURE_COUNT; ++i )
	{
		table.SetValue( ++row, 0, i );

		cTerrainTexture* tex = TERRAIN->GetTexture( i );
		
		if( tex )
			table.SetValue( row, 1, tex->GetFileName() );
	}
	table.SetValue( ++row, 0, "----------" );
	++row;
}
