#include "stdafx.h"
#include "TerrainInfoDialog.h"

#include "resource.h"

IMPLEMENT_DYNAMIC(cTerrainInfoDialog, CDialog)

BEGIN_MESSAGE_MAP(cTerrainInfoDialog, CDialog)
END_MESSAGE_MAP()

cTerrainInfoDialog::cTerrainInfoDialog()
{
}

cTerrainInfoDialog::~cTerrainInfoDialog()
{
}

void cTerrainInfoDialog::DoDataExchange( CDataExchange* dx )
{
	CDialog::DoDataExchange(dx);
}

void cTerrainInfoDialog::Update( unsigned int resolution, unsigned int leafResolution, float metersPerVertex, unsigned int unitsPerMeter )
{
	/// ׸ ũ⸦ 
	cString s;
	s.Format( "%d * %d cells", resolution, resolution );
	SetDlgItemText( IDC_EDIT_TINFO_GRIDSIZE, s.Cstr() );

	///  ͼ 
	if( metersPerVertex == 1.0f )
	{
		SetDlgItemText( IDC_EDIT_TINFO_METERSPERVERTEX, "1.00 meter" );
	}
	else
	{
		s.Format( "%.2f meters", metersPerVertex );
		SetDlgItemText( IDC_EDIT_TINFO_METERSPERVERTEX, s.Cstr() );
	}

	/// ʹ  
	s.Format( "%d units", unitsPerMeter );
	SetDlgItemText( IDC_EDIT_TINFO_UNITSPERMETER, s.Cstr() );

	/// ũ⸦ 
	float sizeMeters = resolution * metersPerVertex;
	s.Format( "%.2f * %.2f meters", sizeMeters, sizeMeters );
	SetDlgItemText( IDC_EDIT_TINFO_SIZEMETERS, s.Cstr() );

	float sizeUnits = sizeMeters * unitsPerMeter;
	s.Format( "%.2f * %.2f units", sizeUnits, sizeUnits );
	SetDlgItemText( IDC_EDIT_TINFO_SIZEUNITS, s.Cstr() );

	/// Ÿ  
	unsigned int tiles = resolution / leafResolution;
	s.Format( "%d * %d = %d tiles", tiles, tiles, tiles * tiles );
	SetDlgItemText( IDC_EDIT_TINFO_TILES, s.Cstr() );
}
