/* ==========================================================================
*    : ̼
*    : 2006.12.12
*      :  Ʈ
* ǻ : 
*===========================================================================*/
#pragma once

class cNumericEdit;

/// Ʈ
class cNumEdit : public CEdit
{
	DECLARE_DYNAMIC( cNumEdit )

public:
	cNumEdit();

	BOOL Create( DWORD style, const RECT& rect, CWnd* parent, UINT id );

protected:
	DECLARE_MESSAGE_MAP()
	afx_msg void OnKeyDown( UINT c, UINT repeats, UINT flags );
	afx_msg void OnChar( UINT c, UINT repeats, UINT flags );
	//afx_msg void OnEnChange();
	afx_msg HBRUSH CtlColor( CDC* /*dc*/, UINT /*nCtlColor*/ );

private:
	/// θ
	cNumericEdit* mParent;

	BOOL   m_fOverFlow;
	CBrush m_brError;
};

/// 
class cNumSpin : public CSpinButtonCtrl
{
	DECLARE_DYNAMIC( cNumSpin )

public:
	cNumSpin();

	BOOL Create( DWORD style, const RECT& rect, CWnd* parent, UINT id );
	void SetStep( float step );

protected:
	DECLARE_MESSAGE_MAP()
	afx_msg void OnDeltapos( NMHDR* pnmhdr, LRESULT* presult );

private:
	/// θ
	cNumericEdit* mParent;

	/// 
	float mStep;
};

/// ư
class cNumEditButton : public CButton
{
	DECLARE_DYNAMIC( cNumEditButton )

public:
	cNumEditButton();
	BOOL Create( LPCTSTR caption, DWORD style, const RECT& rect, CWnd* parent, UINT id );

protected:
	DECLARE_MESSAGE_MAP()
	afx_msg LRESULT OnBnSetStyle( WPARAM wparam, LPARAM lparam );
	afx_msg void OnLButtonDown( UINT flags, CPoint point );

private:
	/// θ
	cNumericEdit* mParent;
};

/// ˾ 
class cNumEditPopup : public CWnd
{
	DECLARE_DYNAMIC( cNumEditPopup )

public:
	cNumEditPopup();
	BOOL Create( cNumericEdit* parent, float step );

protected:
	DECLARE_MESSAGE_MAP()
	afx_msg void OnMouseMove( UINT flags, CPoint point );
	afx_msg void OnLButtonUp( UINT flags, CPoint point );

private:
	/// θ
	cNumericEdit* mParent;

	/// 巡 ǥ
	int mDragY;

	/// 
	float mStep;
};

///  ޽
static const UINT NEN_CHANGED = ::RegisterWindowMessage(_T("NEN_CHANGED-{CD9B6FDC-F420-4956-91B0-AB882EC15A89}"));

///  Ʈ
class cNumericEdit : public CWnd
{
	DECLARE_DYNAMIC( cNumericEdit )

public:
	cNumericEdit();

	BOOL Create( float min, float max, float value, float step, CWnd* parent, UINT id, DWORD style = WS_VISIBLE | WS_TABSTOP );
	void ShowPopup();
	void HidePopup();

	void SetDelta( float delta );
	void SetDeltaNotify( float delta );
	void SetValue( float value );
	void SetValueNotify( float value );
	void SetRange( float min, float max );
	void SetReadOnly( bool readOnly );
	void SetEnabled( bool enabled );

	float GetDelta() const;
	float GetValue() const;
	void GetRange( float* min, float* max ) const;
	bool IsReadOnly() const;

protected:
	void ResizeChildren( int cx, int cy );

public:
	afx_msg int OnCreate( LPCREATESTRUCT cs );
	afx_msg void OnSize( UINT type, int cx, int cy );
	//afx_msg void OnVScroll( UINT sbcode, UINT pos, CScrollBar* pscrollBar );
	afx_msg void OnSetFocus( CWnd* poldWnd );
	afx_msg void OnKeyDown( UINT c, UINT repeats, UINT flags );
	DECLARE_MESSAGE_MAP()

private:
	/// Ʈ
	cNumEdit mEdit;

	/// 
	cNumSpin mSpin;

	/// ư
	cNumEditButton mButton;

	/// ̵
	UINT mID;

	/// 
	float mMin;
	float mMax;

	/// 
	float mValue;

	/// Ÿ
	float mDelta;

	/// 
	float mStep;

	/// Ȱȭ 
	bool mEnabled;
};

inline float cNumericEdit::GetDelta() const
{
	return mDelta;
}

inline float cNumericEdit::GetValue() const
{
	return mValue;
}

inline void cNumericEdit::GetRange( float* min, float* max ) const
{
	*min = mMin;
	*max = mMax;
}

inline bool cNumericEdit::IsReadOnly() const
{
	return ( mEdit.GetStyle() & ES_READONLY ) > 0;
}
