// CharModelDlg.cpp :  Դϴ.
//

#include "stdafx.h"
#include "CharModelDlg.h"

#include "resource.h"

#include "GameResourceManager.h"
#include ".\charmodeldlg.h"

#include "ModelView.h"
#include "Item_Common.h"

#include "Player_Common.h"
#include "PlayerSceneNode.h"
#include "CharacterForm.h"
#include "SceneManager.h"

// cCharModelDlg ȭ Դϴ.

IMPLEMENT_DYNAMIC(cCharModelDlg, CDialog)

BEGIN_MESSAGE_MAP(cCharModelDlg, CDialog)
	ON_BN_CLICKED(IDC_RADIO1, OnBnClickedRadio1)
	ON_BN_CLICKED(IDC_RADIO2, OnBnClickedRadio2)
	ON_BN_CLICKED(IDC_RADIO3, OnBnClickedRadio3)
	ON_BN_CLICKED(IDC_RADIO4, OnBnClickedRadio4)
	ON_BN_CLICKED(IDC_RADIO5, OnBnClickedRadio5)

	ON_CBN_SELCHANGE(IDC_COMBO1, OnCbnSelchangeCombo1)
	ON_CBN_SELCHANGE(IDC_COMBO2, OnCbnSelchangeCombo2)
	ON_CBN_SELCHANGE(IDC_COMBO3, OnCbnSelchangeCombo3)
	ON_CBN_SELCHANGE(IDC_COMBO4, OnCbnSelchangeCombo4)
	ON_CBN_SELCHANGE(IDC_COMBO5, OnCbnSelchangeCombo5)
	ON_CBN_SELCHANGE(IDC_COMBO6, OnCbnSelchangeCombo6)
	ON_CBN_SELCHANGE(IDC_COMBO7, OnCbnSelchangeCombo7)
	ON_CBN_SELCHANGE(IDC_COMBO8, OnCbnSelchangeCombo8)
	ON_CBN_SELCHANGE(IDC_COMBO9, OnCbnSelchangeCombo9)
	ON_CBN_SELCHANGE(IDC_COMBO10, OnCbnSelchangeCombo10)

END_MESSAGE_MAP()

cCharModelDlg::cCharModelDlg(CWnd* /*pParent=NULL*/)
{
	mCurRace = 0;
	mCurGender = 0;

	mLinkWeapon[0] = (unsigned int)-1;
	mLinkWeapon[1] = (unsigned int)-1;

	mCurWeaponState = eWEAPON_STATE_NONE;
}

cCharModelDlg::~cCharModelDlg()
{
}

void cCharModelDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

	for(unsigned int i=0;i<eRACE_MAX;i++)
		DDX_Control( pDX, IDC_RADIO1+i, mRaceRadio[i] );

	for(unsigned int i=0;i<eGENDER_MAX;i++)
		DDX_Control( pDX, IDC_RADIO4+i, mGenderRadio[i] );

	for( unsigned int i=0;i<COMBO_MAX;i++ )
		DDX_Control( pDX, IDC_COMBO1 + i, mComboArray[i] );

	mRaceRadio[eRACE_HUMAN].SetCheck( 1 );
	mGenderRadio[eGENDER_MALE].SetCheck( 1 );
}

void cCharModelDlg::OpenData()
{
	mLinkWeapon[0] = (unsigned int)-1;
	mLinkWeapon[1] = (unsigned int)-1;

	int idx = -1;

	for( unsigned int i=0;i<COMBO_MAX;i++ )
		mComboArray[i].ResetContent();

	for(unsigned int i=0;i<eRACE_MAX;i++)
		mRaceRadio[i].SetCheck(0);
	for(unsigned int i=0;i<eGENDER_MAX;i++)
		mGenderRadio[i].SetCheck(0);

	mCurRace = eRACE_HUMAN;
	mCurGender = eGENDER_MALE;

	mRaceRadio[mCurRace].SetCheck( 1 );
	mGenderRadio[mCurGender].SetCheck( 1 );

	CComboBox* box = 0;

	/// hair & hair color
	box = &mComboArray[COMBO_HAIR];
	unsigned int hairCount = GAMERESOURCEMAN->GetDefaultHairCount();
	for( unsigned int i=0; i<hairCount; i++ )
	{
		char buf[256] = {0,};
		sprintf( buf, "Hair%2d", i+1 );
		box->AddString( buf );
	}
	box->SetCurSel(0);

	box = &mComboArray[COMBO_HAIRCOLOR];
	unsigned int hairColorCount = GAMERESOURCEMAN->GetHairColorCount();
	for( unsigned int i=0; i<hairColorCount; i++ )
	{
		char buf[256] = {0,};
		sprintf( buf, "Hair Color%2d", i+1 );
		box->AddString( buf );
	}
	box->SetCurSel(0);

	/// face
	box = &mComboArray[COMBO_FACE];
	unsigned int faceCount = GAMERESOURCEMAN->GetDefaultFaceCount();
	for( unsigned int i=0; i<faceCount; i++ )
	{
		char buf[256] = {0,};
		sprintf( buf, "Face%2d", i+1 );
		box->AddString( buf );
	}
	box->SetCurSel(0);

	/// jacket
	box = &mComboArray[COMBO_JACKET];
	idx = box->AddString("None");
	box->SetItemDataPtr(idx,0);
	box->SetCurSel(idx);

	/// pants
	box = &mComboArray[COMBO_PANTS];
	idx = box->AddString("None");
	box->SetItemDataPtr(idx,0);
	box->SetCurSel(0);

	/// gloves
	box = &mComboArray[COMBO_GLOVES];
	idx = box->AddString("None");
	box->SetItemDataPtr(idx,0);
	box->SetCurSel(0);

	/// boots
	box = &mComboArray[COMBO_BOOTS];
	idx = box->AddString("None");
	box->SetItemDataPtr(idx,0);
	box->SetCurSel(0);

	/// weapon1
	box = &mComboArray[COMBO_WEAPON_TYPE];
	box->AddString("NONE");
	box->AddString("SWORD");
	box->AddString("BLADE");
	box->AddString("DUAL");
	box->AddString("CUTTER");
	box->AddString("GUN");
	box->AddString("STAFF");
	box->SetCurSel(0);
	mCurWeaponState = eWEAPON_STATE_NONE;

	box = &mComboArray[COMBO_WEAPON_KIND];
	idx = box->AddString("None");
	box->SetItemDataPtr(idx,0);
	box->SetCurSel(0);
	box->EnableWindow( FALSE );

	/// weapon2
	box = &mComboArray[COMBO_SHIELD];
	idx = box->AddString("None");
	box->SetItemDataPtr(idx,0);
	box->SetCurSel(0);

	/// Add item list
	cArrayHashMap* itemMap = GAMERESOURCEMAN->GetItemList();
	cArrayHashMap::cIterator i = itemMap->Begin();
	cArrayHashMap::cIterator iend = itemMap->End();
	for( ; i != iend; ++i )
	{
		sItemInfo* info = (sItemInfo*)(i->mSecond);
		if( info == 0 )
			continue;

		char buff[256] = {0,};

		switch( info->mType )
		{
		case ITEM_WEAPON:
			{
				if( info->mSubType == ITEM_WEAPON_SHIELD )
				{
					LPCTSTR str = GAMERESOURCEMAN->GetItemNameText( info->mNameIndex );
					::sprintf( buff, "%s (%d)", str, info->mIndex );
					idx = mComboArray[COMBO_SHIELD].AddString( buff );
					mComboArray[COMBO_SHIELD].SetItemDataPtr(idx,info);

				}
				else
				{
					int type = mComboArray[COMBO_WEAPON_TYPE].GetCurSel();
					if( info->mSubType == type )
					{
						LPCTSTR str = GAMERESOURCEMAN->GetItemNameText( info->mNameIndex );
						::sprintf( buff, "%s (%d)", str, info->mIndex );
						idx = mComboArray[COMBO_WEAPON_KIND].AddString( buff );
						mComboArray[COMBO_WEAPON_KIND].SetItemDataPtr(idx,info);
					}
				}
			}
			break;
		case ITEM_WEAR:
			{
				LPCTSTR str = GAMERESOURCEMAN->GetItemNameText( info->mNameIndex );

				if( info->mSubType == ITEM_WEAR_UPPER )
					box = &mComboArray[COMBO_JACKET];
				else if( info->mSubType == ITEM_WEAR_LOWER )
					box = &mComboArray[COMBO_PANTS];
				else if( info->mSubType == ITEM_WEAR_HANDS )
					box = &mComboArray[COMBO_GLOVES];
				else if( info->mSubType == ITEM_WEAR_FEET )
					box = &mComboArray[COMBO_BOOTS];
				else
					continue;

				::sprintf( buff, "%s (%d)", str, info->mIndex );
				idx = box->AddString( buff );
				box->SetItemDataPtr( idx, info );
			}
			break;
		default:
			continue;
		}
	}
}

void cCharModelDlg::OnBnClickedRadio1()
{
	if( mCurRace == eRACE_HUMAN )
		return;

	mCurRace = eRACE_HUMAN;
	mCurGender = eGENDER_MALE;

	for(unsigned int i=0;i<eGENDER_MAX;i++)
		mGenderRadio[i].SetCheck(0);
	mGenderRadio[mCurGender].SetCheck( 1 );

	UpdateCharacterData( mCurRace * eGENDER_MAX + mCurGender );

	CHARACTERFORM->UpdateDrama();
}


void cCharModelDlg::OnBnClickedRadio2()
{
	if( mCurRace == eRACE_BEAST )
		return;

	mCurRace = eRACE_BEAST;
	mCurGender = eGENDER_MALE;

	for(unsigned int i=0;i<eGENDER_MAX;i++)
		mGenderRadio[i].SetCheck(0);
	mGenderRadio[mCurGender].SetCheck( 1 );

	UpdateCharacterData( mCurRace * eGENDER_MAX + mCurGender );

	CHARACTERFORM->UpdateDrama();
}

void cCharModelDlg::OnBnClickedRadio3()
{
	if( mCurRace == eRACE_ELF )
		return;

	mCurRace = eRACE_ELF;
	mCurGender = eGENDER_MALE;

	for(unsigned int i=0;i<eGENDER_MAX;i++)
		mGenderRadio[i].SetCheck(0);
	mGenderRadio[mCurGender].SetCheck( 1 );

	UpdateCharacterData( mCurRace * eGENDER_MAX + mCurGender );

	CHARACTERFORM->UpdateDrama();
}

void cCharModelDlg::OnBnClickedRadio4()
{
	if( mCurGender == eGENDER_MALE )
		return;

	mCurGender = eGENDER_MALE;

	UpdateCharacterData( mCurRace * eGENDER_MAX + mCurGender );

	CHARACTERFORM->UpdateDrama();
}

void cCharModelDlg::OnBnClickedRadio5()
{
	if( mCurGender == eGENDER_FEMALE )
		return;

	mCurGender = eGENDER_FEMALE;

	UpdateCharacterData( mCurRace * eGENDER_MAX + mCurGender );

	CHARACTERFORM->UpdateDrama();
}

void cCharModelDlg::OnCbnSelchangeCombo1()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	CComboBox* box = &mComboArray[COMBO_HAIR];
	int curSel = box->GetCurSel();
	if( curSel < 0 )
	{
		assert(0);
		return;
	}
	const char* filename = GAMERESOURCEMAN->GetDefaultHairFileName( curSel, mCurRace, mCurGender );
	VIEW->ChangeCharacterParts( cPlayerSceneNode::ePART_HAIR, filename );
}

void cCharModelDlg::OnCbnSelchangeCombo2()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	CComboBox* box = &mComboArray[COMBO_HAIRCOLOR];
	int curSel = box->GetCurSel();
	if( curSel < 0 )
	{
		assert(0);
		return;
	}
}

void cCharModelDlg::OnCbnSelchangeCombo3()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	CComboBox* box = &mComboArray[COMBO_FACE];
	int curSel = box->GetCurSel();
	if( curSel < 0 )
	{
		assert(0);
		return;
	}

	const char* filename = GAMERESOURCEMAN->GetFaceTextureFileName( curSel+1, mCurRace, mCurGender );
	VIEW->ChangeCharacterPartsTexture( cPlayerSceneNode::ePART_FACE, filename );
}

void cCharModelDlg::OnCbnSelchangeCombo4()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	CComboBox* box = &mComboArray[COMBO_JACKET];
	int curSel = box->GetCurSel();
	if( curSel < 0 )
	{
		assert(0);
		return;
	}

	sItemInfo* info = (sItemInfo*)box->GetItemDataPtr( curSel );
	if( info == 0 )
	{
		/// ⺻  
		const char* filename = GAMERESOURCEMAN->GetDefaultWearFileName( ePART_BODY1, mCurRace, mCurGender );
		VIEW->ChangeCharacterParts( cPlayerSceneNode::ePART_BODY1, filename );
		return;
	}

	if( info->mType == ITEM_WEAR )
	{
		const char* filename = GAMERESOURCEMAN->GetItemFileName( info->mModelIndex1, mCurRace, mCurGender, false );
		bool check = VIEW->ChangeCharacterParts( cPlayerSceneNode::ePART_BODY1, filename );
		if( check == false )
		{
			/// ⺻  
			const char* filename = GAMERESOURCEMAN->GetDefaultWearFileName( ePART_BODY1, mCurRace, mCurGender );
			VIEW->ChangeCharacterParts( cPlayerSceneNode::ePART_BODY1, filename );
			return;
		}
	}
}

void cCharModelDlg::OnCbnSelchangeCombo5()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	CComboBox* box = &mComboArray[COMBO_PANTS];
	int curSel = box->GetCurSel();
	if( curSel < 0 )
	{
		assert(0);
		return;
	}
	sItemInfo* info = (sItemInfo*)box->GetItemDataPtr( curSel );
	if( info == 0 )
	{
		/// ⺻  
		const char* filename = GAMERESOURCEMAN->GetDefaultWearFileName( ePART_BODY2, mCurRace, mCurGender );
		VIEW->ChangeCharacterParts( cPlayerSceneNode::ePART_BODY2, filename );
		return;
	}

	if( info->mType == ITEM_WEAR )
	{
		const char* filename = GAMERESOURCEMAN->GetItemFileName( info->mModelIndex1, mCurRace, mCurGender, false );
		bool check = VIEW->ChangeCharacterParts( cPlayerSceneNode::ePART_BODY2, filename );
		if( check == false )
		{
			/// ⺻  
			const char* filename = GAMERESOURCEMAN->GetDefaultWearFileName( ePART_BODY2, mCurRace, mCurGender );
			VIEW->ChangeCharacterParts( cPlayerSceneNode::ePART_BODY2, filename );
			return;
		}
	}
}

void cCharModelDlg::OnCbnSelchangeCombo6()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	CComboBox* box = &mComboArray[COMBO_GLOVES];
	int curSel = box->GetCurSel();
	if( curSel < 0 )
	{
		assert(0);
		return;
	}

	sItemInfo* info = (sItemInfo*)box->GetItemDataPtr( curSel );
	if( info == 0 )
	{
		/// ⺻  
		const char* filename = GAMERESOURCEMAN->GetDefaultWearFileName( ePART_HAND, mCurRace, mCurGender );
		VIEW->ChangeCharacterParts( cPlayerSceneNode::ePART_HAND, filename );
		return;
	}

	if( info->mType == ITEM_WEAR )
	{
		const char* filename = GAMERESOURCEMAN->GetItemFileName( info->mModelIndex1, mCurRace, mCurGender, false );
		bool check = VIEW->ChangeCharacterParts( cPlayerSceneNode::ePART_HAND, filename );
		if( check == false )
		{
			/// ⺻  
			const char* filename = GAMERESOURCEMAN->GetDefaultWearFileName( ePART_HAND, mCurRace, mCurGender );
			VIEW->ChangeCharacterParts( cPlayerSceneNode::ePART_HAND, filename );
			return;
		}
	}
}

void cCharModelDlg::OnCbnSelchangeCombo7()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	CComboBox* box = &mComboArray[COMBO_BOOTS];
	int curSel = box->GetCurSel();
	if( curSel < 0 )
	{
		assert(0);
		return;
	}

	sItemInfo* info = (sItemInfo*)box->GetItemDataPtr( curSel );
	if( info == 0 )
	{
		/// ⺻  
		const char* filename = GAMERESOURCEMAN->GetDefaultWearFileName( ePART_FOOT, mCurRace, mCurGender );
		VIEW->ChangeCharacterParts( cPlayerSceneNode::ePART_FOOT, filename );
		return;
	}

	if( info->mType == ITEM_WEAR )
	{
		const char* filename = GAMERESOURCEMAN->GetItemFileName( info->mModelIndex1, mCurRace, mCurGender, false );
		bool check = VIEW->ChangeCharacterParts( cPlayerSceneNode::ePART_FOOT, filename );
		if( check == false )
		{
			/// ⺻  
			const char* filename = GAMERESOURCEMAN->GetDefaultWearFileName( ePART_FOOT, mCurRace, mCurGender );
			VIEW->ChangeCharacterParts( cPlayerSceneNode::ePART_FOOT, filename );
			return;
		}
	}
}

void cCharModelDlg::OnCbnSelchangeCombo8()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	CComboBox* box = &mComboArray[COMBO_WEAPON_TYPE];
	int curSel = box->GetCurSel();
	if( curSel < 0 )
	{
		assert(0);
		return;
	}

	box = &mComboArray[COMBO_WEAPON_KIND];
	box->ResetContent();

	int idx = box->AddString("None");
	box->SetItemDataPtr(idx,0);
	box->SetCurSel(0);

	if( curSel == 0 )
	{
		box->EnableWindow( FALSE );
	}
	else
	{
		box->EnableWindow( TRUE );

		cArrayHashMap* itemMap = GAMERESOURCEMAN->GetItemList();
		cArrayHashMap::cIterator i = itemMap->Begin();
		cArrayHashMap::cIterator iend = itemMap->End();

		char buff[256] = {0,};
		for( ; i != iend; ++i )
		{
			sItemInfo* info = (sItemInfo*)(i->mSecond);
			if( info == 0 )
				continue;
			if( info->mType != ITEM_WEAPON )
				continue;
			if( info->mSubType != curSel-1 )
				continue;

			LPCTSTR str = GAMERESOURCEMAN->GetItemNameText( info->mNameIndex );
			::sprintf( buff, "%s (%d)", str, info->mIndex );
			idx = box->AddString( buff );
			box->SetItemDataPtr(idx,info);
		}
	}

	if( curSel > 1 )
	{
		mComboArray[COMBO_SHIELD].SetCurSel(0);
		mComboArray[COMBO_SHIELD].EnableWindow( FALSE );
	}
	else
		mComboArray[COMBO_SHIELD].EnableWindow( TRUE );


	UpdateWeaponData();

	mCurWeaponState = (unsigned char)curSel;
	CHARACTERFORM->UpdateDrama();
}

void cCharModelDlg::OnCbnSelchangeCombo9()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	CComboBox* box = &mComboArray[COMBO_WEAPON_KIND];
	int curSel = box->GetCurSel();
	if( curSel < 0 )
	{
		assert(0);
		return;
	}

	///  
	UpdateWeaponData();
}

void cCharModelDlg::OnCbnSelchangeCombo10()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	CComboBox* box = &mComboArray[COMBO_SHIELD];
	if( mComboArray[COMBO_WEAPON_TYPE].GetCurSel() > 1 )
	{
		box->SetCurSel(0);
		return;
	}

	int curSel = box->GetCurSel();
	if( curSel < 0 )
	{
		assert(0);
		return;
	}

	///  
	UpdateWeaponData();
}

void cCharModelDlg::UpdateCharacterData( unsigned long modelIndex )
{
	VIEW->CreateCharacter( modelIndex, mCurRace, mCurGender );

	OnCbnSelchangeCombo1();
	OnCbnSelchangeCombo2();
	OnCbnSelchangeCombo3();
	OnCbnSelchangeCombo4();
	OnCbnSelchangeCombo5();
	OnCbnSelchangeCombo6();
	OnCbnSelchangeCombo7();

	mLinkWeapon[0] = (unsigned int)-1;
	mLinkWeapon[1] = (unsigned int)-1;
	UpdateWeaponData();
}

void cCharModelDlg::UpdateWeaponData()
{
	SCENEMAN->SetDramaProcess( true );

	/// ʱȭ
	VIEW->UnLinkCharacterWeapon( mLinkWeapon[0], mLinkWeapon[1] );
	mLinkWeapon[0] = (unsigned int)-1;
	mLinkWeapon[1] = (unsigned int)-1;

	float fScale = 1.00f;
	if( mCurRace == eRACE_HUMAN )
	{
		fScale = (mCurGender == eGENDER_MALE)? 1.03f:1.06f;
	}
	else if( mCurRace == eRACE_ELF )
	{
		fScale = (mCurGender == eGENDER_MALE)? 1.15f:1.09f;
	}
	else if( mCurRace == eRACE_BEAST )
	{
		fScale = (mCurGender == eGENDER_MALE)? 1.12f:1.00f;
	}

	/// 
	CComboBox* box = &mComboArray[COMBO_WEAPON_KIND];
	int curSel = box->GetCurSel();
	if( curSel > 0 )
	{
		sItemInfo* info = (sItemInfo*)box->GetItemDataPtr( curSel );
		if( info->mType == ITEM_WEAPON )
		{
			switch( info->mSubType )
			{
			case ITEM_WEAPON_SWORD:
				{
					const char* filename = GAMERESOURCEMAN->GetItemFileName( info->mModelIndex1, mCurRace, mCurGender, true );
					mLinkWeapon[0] = VIEW->LinkCharacterWeapon( cPlayerSceneNode::eLINK_RHAND, filename, fScale );
				}
				break;
			case ITEM_WEAPON_DUAL:				// ̵
			case ITEM_WEAPON_CUTTER:			//   
				{
					const char* filename = GAMERESOURCEMAN->GetItemFileName( info->mModelIndex1, mCurRace, mCurGender, true );
					mLinkWeapon[0] = VIEW->LinkCharacterWeapon( cPlayerSceneNode::eLINK_RHAND, filename, fScale );

					filename = GAMERESOURCEMAN->GetItemFileName( info->mModelIndex2, mCurRace, mCurGender, true );
					mLinkWeapon[1] = VIEW->LinkCharacterWeapon( cPlayerSceneNode::eLINK_LHAND, filename, fScale );

					mComboArray[COMBO_SHIELD].SetCurSel( 0 );
				}
				return;
			case ITEM_WEAPON_BLADE:				// հ
			case ITEM_WEAPON_GUN:				// ,
			case ITEM_WEAPON_STAFF:				// 
				{
					const char* filename = GAMERESOURCEMAN->GetItemFileName( info->mModelIndex1, mCurRace, mCurGender, true );
					mLinkWeapon[0] = VIEW->LinkCharacterWeapon( cPlayerSceneNode::eLINK_RHAND, filename, fScale );

					mComboArray[COMBO_SHIELD].SetCurSel( 0 );
				}
				return;
			default:
				{
					assert(0);
				}
				break;
			}
		}
	}

	box = &mComboArray[COMBO_SHIELD];
	curSel = box->GetCurSel();
	if( curSel > 0 )
	{
		sItemInfo* info = (sItemInfo*)box->GetItemDataPtr( curSel );
		if( info->mType == ITEM_WEAPON )
		{
			if( info->mSubType == ITEM_WEAPON_SHIELD )
			{
				const char* filename = GAMERESOURCEMAN->GetItemFileName( info->mModelIndex1, mCurRace, mCurGender, true );
				mLinkWeapon[1] = VIEW->LinkCharacterWeapon( cPlayerSceneNode::eLINK_LARM, filename, fScale );
			}
		}
	}
}
