// EMERGENT GAME TECHNOLOGIES PROPRIETARY INFORMATION
//
// This software is supplied under the terms of a license agreement or
// nondisclosure agreement with Emergent Game Technologies and may not
// be copied or disclosed except in accordance with the terms of that
// agreement.
//
//      Copyright (c) 1996-2006 Emergent Game Technologies.
//      All Rights Reserved.
//
// Emergent Game Technologies, Chapel Hill, North Carolina 27517
// http://www.emergent.net

//---------------------------------------------------------------------------
inline void cActorManagerForPartition::SetCallbackObject(
	CallbackObject* pkCallbackObject)
{
	m_pkCallbackObject = pkCallbackObject;
}
//---------------------------------------------------------------------------
inline cActorManagerForPartition::CallbackObject* cActorManagerForPartition::GetCallbackObject()
const
{
	return m_pkCallbackObject;
}
//---------------------------------------------------------------------------
inline cActorManagerForPartition::SequenceID cActorManagerForPartition::GetTargetAnimation() const
{
	return m_eTargetID;
}
//---------------------------------------------------------------------------
inline bool cActorManagerForPartition::SetTargetAnimation(SequenceID eSequenceID)
{
	if (m_eTargetID == eSequenceID)
	{
		return true;
	}

	if (eSequenceID != INVALID_SEQUENCE_ID)
	{
		NiControllerSequence* pkSequence;
		if (!m_kSequenceMap.GetAt(eSequenceID, pkSequence))
		{
			return false;
		}
	}

	m_eTargetID = eSequenceID;
	m_bBuildTimeline = true;

	return true;
}
//---------------------------------------------------------------------------
inline bool cActorManagerForPartition::UpdateTargetAnimation(SequenceID eSequenceID)
{
	NiControllerSequence* pkSequence = GetSequence(eSequenceID);
	if( pkSequence )
	{
		pkSequence->ResetSequence();
		//		pkSequence->Update( m_fTime );

		return true;
	}

	Reset();

	return false;
}
//---------------------------------------------------------------------------
inline void cActorManagerForPartition::Reset()
{
	if (m_spManager)
	{
		m_spManager->DeactivateAll();
	}
	m_eTargetID = INVALID_SEQUENCE_ID;
	m_fTime = INVALID_TIME;
	m_bBuildTimeline = false;
	m_fTimelineRefreshTime = NI_INFINITY;
	m_eTransitionState = NO_TRANSITION;
	m_bStartTransition = false;
	m_fTransStartTime = NI_INFINITY;
	m_fTransEndTime = -NI_INFINITY;
	m_fTransStartFrameTime = INVALID_TIME;
	m_pcTargetKey = NULL;
	m_eCurID = INVALID_SEQUENCE_ID;
	m_pkCurSequence = NULL;
	m_eNextID = INVALID_SEQUENCE_ID;
	m_pkNextSequence = NULL;
	m_bChainActive = false;
	m_fNextChainTime = INVALID_TIME;
	m_kChainIDs.RemoveAll();
	m_kChainDurations.RemoveAll();
	m_kExtraSequences.RemoveAll();
	m_kTimeline.RemoveAll();
}
//---------------------------------------------------------------------------
inline cActorManagerForPartition::SequenceID cActorManagerForPartition::GetCurAnimation() const
{
	return m_eCurID;
}
//---------------------------------------------------------------------------
inline cActorManagerForPartition::TransitionState cActorManagerForPartition::GetTransitionState()
const
{
	return m_eTransitionState;
}
//---------------------------------------------------------------------------
inline cActorManagerForPartition::SequenceID cActorManagerForPartition::GetNextAnimation() const
{
	return m_eNextID;
}
//---------------------------------------------------------------------------
inline NiNode* cActorManagerForPartition::GetNifRoot() const
{
	return m_spModelRoot;
}
//---------------------------------------------------------------------------
inline NiAVObject* cActorManagerForPartition::GetActorRoot() const
{
	assert(m_spManager && NiIsKindOf(NiAVObject, m_spManager->GetTarget()));
	return (NiAVObject*) m_spManager->GetTarget();
}
//---------------------------------------------------------------------------
inline NiKFMTool* cActorManagerForPartition::GetKFMTool() const
{
	return m_spKFMTool;
}
//---------------------------------------------------------------------------
inline NiControllerManager* cActorManagerForPartition::GetControllerManager() const
{
	return m_spManager;
}
//---------------------------------------------------------------------------
inline NiBoneLODController* cActorManagerForPartition::GetBoneLODController() const
{
	return m_spBoneLOD;
}
//---------------------------------------------------------------------------
inline NiControllerSequence* cActorManagerForPartition::GetSequence(
	SequenceID eSequenceID) const
{
	NiControllerSequence* pkSequence;
	if (m_kSequenceMap.GetAt(eSequenceID, pkSequence))
	{
		return pkSequence;
	}

	return NULL;
}
//---------------------------------------------------------------------------
inline NiAVObject* cActorManagerForPartition::GetAccumRoot() const
{
	assert(m_spManager);
	return m_spManager->GetAccumRoot();
}
//---------------------------------------------------------------------------
inline void cActorManagerForPartition::ClearAllRegisteredCallbacks()
{
	m_kCallbacks.RemoveAll();
	m_bBuildTimeline = true;
}
//---------------------------------------------------------------------------
inline float cActorManagerForPartition::GetNextEventTime(EventType eEventType,
														 SequenceID eSequenceID, const NiFixedString& kTextKey)
{
	if (eEventType == TEXT_KEY_EVENT && kTextKey.Exists())
	{
		NiTextKeyMatch kMatchObject(kTextKey);
		return GetNextEventTime(eEventType, eSequenceID, &kMatchObject);
	}
	else
	{
		return GetNextEventTime(eEventType, eSequenceID);
	}
}
//---------------------------------------------------------------------------
inline float cActorManagerForPartition::GetNextEventTime(EventType eEventType,
														 SequenceID eSequenceID, NiTextKeyMatch* pkMatchObject)
{
	switch (eEventType)
	{
	case ANIM_ACTIVATED:
		return GetNextAnimActivatedTime(eSequenceID);
	case ANIM_DEACTIVATED:
		return GetNextAnimDeactivatedTime(eSequenceID);
	case TEXT_KEY_EVENT:
		return GetNextTextKeyEventTime(eSequenceID, pkMatchObject );
	case END_OF_SEQUENCE:
		return GetNextEndOfSequenceTime(eSequenceID);
	default:
		return INVALID_TIME;
	}
}
//---------------------------------------------------------------------------
inline cActorManagerForPartition::CallbackData::CallbackData(EventType eEventType,
															 SequenceID eSequenceID, NiTextKeyMatch * pkMatchObject ) : 
m_eEventType(eEventType), m_eSequenceID(eSequenceID),
m_spMatchObject(NULL)
{
	SetMatchObject( pkMatchObject );
}
//---------------------------------------------------------------------------
inline cActorManagerForPartition::CallbackData::~CallbackData()
{
	m_spMatchObject = 0;
}
//---------------------------------------------------------------------------
inline void cActorManagerForPartition::CallbackData::SetMatchObject( 
	NiTextKeyMatch* pkMatchObject )
{
	m_spMatchObject = pkMatchObject;
}
//---------------------------------------------------------------------------
inline NiTextKeyMatchPtr cActorManagerForPartition::CallbackData::GetMatchObject() const
{
	return m_spMatchObject;
}
//---------------------------------------------------------------------------
inline cActorManagerForPartition::TimelineData::~TimelineData()
{
	m_spMatchObject = 0;
}
//---------------------------------------------------------------------------
inline void cActorManagerForPartition::TimelineData::SetValues(float fEventTime,
															   EventType eEventType, SequenceID eSequenceID, 
															   NiTextKeyMatch* pkMatchObject, const NiFixedString& kTextKeyMatched)
{
	m_fEventTime = fEventTime;
	m_eEventType = eEventType;
	m_eSequenceID = eSequenceID;
	m_spMatchObject = pkMatchObject;
	m_kTextKeyMatched = kTextKeyMatched;
}
//---------------------------------------------------------------------------
inline float cActorManagerForPartition::GetNextEndOfSequenceTime(SequenceID eSequenceID)
{
	// This function returns the next time that the "end" text key will occur
	// in the specified sequence. This is a convenience function for a
	// commonly desired text key. If the time of the next "end" text key
	// cannot be determined, INVALID_TIME is returned.

	NiTextKeyMatch kKeyMatch( NiActorManager::GetDefaultEndTextKey() );
	return GetNextTextKeyEventTime(eSequenceID, &kKeyMatch );
}
//---------------------------------------------------------------------------
inline cActorManagerForPartition::ChainCompletionInfo::ChainCompletionInfo()
{
}
//---------------------------------------------------------------------------
inline cActorManagerForPartition::ChainCompletionInfo::~ChainCompletionInfo()
{
}
//---------------------------------------------------------------------------
inline void cActorManagerForPartition::ChainCompletionInfo::SetName(
	const NiFixedString& kName)
{
	m_kName = kName;
}
//---------------------------------------------------------------------------
inline void cActorManagerForPartition::ChainCompletionInfo::SetNextName(
	const NiFixedString& kNextName)
{
	m_kNextName = kNextName;
}
//---------------------------------------------------------------------------
inline void cActorManagerForPartition::RefreshControllerManager()
{
	m_spBoneLOD = FindBoneLODController(m_spModelRoot);
	assert(m_spBoneLOD);

	//	m_spManager = FindControllerManager(m_spNIFRoot);
	//	assert(m_spManager);
}
//---------------------------------------------------------------------------
inline void cActorManagerForPartition::RebuildTimeline()
{
	m_bBuildTimeline = true;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
inline unsigned int cActorManagerForPartition::GetPartsCount()
{
	return mArrayParts.GetAllocatedSize();
}
//---------------------------------------------------------------------------
inline NiAVObject* cActorManagerForPartition::GetParts( unsigned int partIdx ) const
{
	assert(mArrayParts.GetAllocatedSize() > partIdx);
	return mArrayParts.GetAt( partIdx );
}
//---------------------------------------------------------------------------
inline NiAVObject* cActorManagerForPartition::GetKeepParts( unsigned int partIdx ) const
{
	assert(mArrayKeepParts.GetAllocatedSize() > partIdx);
	return mArrayKeepParts.GetAt( partIdx );
}
//---------------------------------------------------------------------------