#include "stdafx.h"
#include "Application.h"

#include "DXVersion.h"
#include "AppWindow.h"
#include "AppTimer.h"

#include "FilePackSystem.h"
#include "RenderSystem.h"
#include "SoundSystem.h"
#include "InputSystem.h"
#include "DevSystem.h"

#include "GameResourceManager.h"
#include "ResourceManager.h"
#include "CameraManager.h"
#include "SceneManager.h"
#include "SkillManager.h"
#include "DramaturgyManager.h"

cApplication* cApplication::mSingleton = 0;

cApplication::cApplication()
: mFileSystem( 0 )
, mRenderSystem( 0 )
#ifdef MAP_EDITOR
, mSoundSystem( 0 )
#endif
, mInputSystem( 0 )
, mDevSystem( 0 )
, mResourceManager( 0 )
, mGameResourceManager( 0 )
, mCameraManager( 0 )
, mSceneManager( 0 )
, mSkillManager(0)
, mDramaManager(0)
{
	assert( mSingleton == 0 && "bad singleton!" );
	mSingleton = this;

	///  Ÿ̸ 
	mTimer = new cAppTimer;
	mTimer->Reset();
	mAccumTime = 0;
	mDeltaTime = 0;

	mActive = true;
}

cApplication::~cApplication()
{
	delete mDramaManager;
	delete mSkillManager;
	delete mSceneManager;
	delete mCameraManager;
	delete mGameResourceManager;
	delete mResourceManager;
	delete mDevSystem;
	delete mInputSystem;
	delete mRenderSystem;
	delete mFileSystem;
	delete mSoundSystem;
	delete mWindow;
	delete mTimer;

	mSingleton = 0;
}

void cApplication::Clear()
{
	if( mSceneManager )
		mSceneManager->Clear();

	if( mResourceManager )
		mResourceManager->Clear();
}

bool cApplication::Init( HWND wnd )
{
	///  츦 
	mWindow = new cAppWindow( wnd );

	///  ý 
	mFileSystem = new cFilePackSystem;
	if( !mFileSystem || !mFileSystem->Init() )
	{
		return false;
	}

	///  ý 
	mRenderSystem = new cRenderSystem( mWindow );
	if( mRenderSystem->Init() == false )
	{
		assert( 0 && "failed to init render system" );
		return false;
	}

	///  ý 
	mSoundSystem = new cSoundSystem;
	if( mSoundSystem->Init( wnd ) == false )
	{
		assert( 0 && "failed to init sound system" );
		return false;
	}

#ifdef MAP_EDITOR
	///  ý 
	mDevSystem = new cDevSystem( NiRenderer::GetRenderer() );
	if( mDevSystem->Init() == false )
	{
		assert( 0 && "failed to init dev system" );
		return false;
	}
#endif

	/// Է ý 
	mInputSystem = new cInputSystem;

	/// ڿ ڸ 
	mResourceManager = new cResourceManager;
	//mpResourceManager->SetBaseDir( baseDir );

	mDramaManager = new cDramaturgyManager;
	if( mDramaManager == 0 )
		return false;
//	if( mDramaManager->Init() == false )
//	{
//		assert( 0 && "failed to init Drama manager" );
//		return false;
//	}

	mGameResourceManager = new cGameResourceManager;
	if( mGameResourceManager->Init() == false )
		return false;

	/// ī޶ ڸ 
	mCameraManager = new cCameraManager;
	mCameraManager->CreateFree( true );

	///  ڸ 
	mSceneManager = new cSceneManager;
	if( !mSceneManager || !mSceneManager->Init( NiPoint3::ZERO, 100.0f, 100000.0f ) )
	{
		return false;
	}

	mSkillManager = new cSkillManager;
	if( mSkillManager->Init() == false )
	{
		assert( 0 && "failed to init skill manager" );
		return false;
	}

	/// Ÿ̸ 
	mTimer->Start();
	return true;
}

void cApplication::Exit()
{

	/// Ÿ̸ 
	mTimer->Stop();
}

void cApplication::Process()
{
//	NiSleep(1);

	///  ð 
	mDeltaTime = mTimer->GetDeltaTime() * 0.001f;
	mAccumTime += mDeltaTime;

	/// Է ڸ ó
	mInputSystem->Process();

	/// ī޶ ڸ ó
	mCameraManager->Process( mDeltaTime );

	mSkillManager->Process( mDeltaTime, mAccumTime );

	mSoundSystem->Process( mDeltaTime, mAccumTime );

	///  ڸ ó
	mSceneManager->Process( mDeltaTime, mAccumTime );

	if( mDevSystem )
		mDevSystem->Process( mAccumTime );
}

void cApplication::Render()
{
	mRenderSystem->Render();
}
