/* ==========================================================================
*    : ̼
*    : 2006.12.20
*      : ø̼
* ǻ : 
*===========================================================================*/
#pragma once

class cAppWindow;
class cAppTimer;
class cFilePackSystem;
class cRenderSystem;
class cSoundSystem;
class cInputSystem;
class cResourceManager;
class cGameResourceManager;
class cCameraManager;
class cSceneManager;
class cDevSystem;
class cSkillManager;
class cDramaturgyManager;

/// ø̼
class cApplication
{
	static cApplication* mSingleton;

public:
	cApplication();
	~cApplication();

	/// 
	void Clear();

	/// ʱȭ
	bool Init( HWND wnd );

	/// 
	void Exit();

	/// ó
	void Process();

	/// 
	void Render();

	/// Ȱȭ 
	void SetActive( bool active );
	bool IsActive();

	/// Ÿ̸
	cAppTimer* GetTimer();
	float GetDeltaTime() const;
	float GetAccumTime() const;

public:
	/// ü 
	static cApplication* GetSingleton();

private:
	///  â
	cAppWindow* mWindow;

	///  ý
	cFilePackSystem* mFileSystem;

	///  ý
	cRenderSystem* mRenderSystem;

	///  ý
	cSoundSystem* mSoundSystem;

	/// Է ý
	cInputSystem* mInputSystem;

	///  ý
	cDevSystem* mDevSystem;

	/// ڿ 
	cResourceManager* mResourceManager;
	cGameResourceManager* mGameResourceManager;

	/// ī޶ 
	cCameraManager* mCameraManager;

	///  
	cSceneManager* mSceneManager;

	cSkillManager*	mSkillManager;

	cDramaturgyManager* mDramaManager;

	/// Ÿ̸
	cAppTimer* mTimer;

	///  ð
	float mAccumTime;

	///  ð
	float mDeltaTime;

	/// Ȱȭ 
	bool mActive;
};

inline void cApplication::SetActive( bool active )
{
	mActive = active;
}

inline bool cApplication::IsActive()
{
	return mActive;
}

inline cAppTimer* cApplication::GetTimer()
{
	return mTimer;
}

inline float cApplication::GetDeltaTime() const
{
	return mDeltaTime;
}

inline float cApplication::GetAccumTime() const
{
	return mAccumTime;
}


inline cApplication* cApplication::GetSingleton()
{
	return mSingleton;
}

#define THEAPP cApplication::GetSingleton()
