#pragma once
#include "BaseObject_Common.h"

class cEffectSceneNode;
class cDramaturgyInfo;
class cDynamicSceneNode;

struct sBulletAction;
struct sCrashInfo;

class cBulletObj
{
public:
	cBulletObj();
	virtual ~cBulletObj();

	bool Init( cDramaturgyInfo* pInfo, sBulletAction* pAct, cDynamicSceneNode* pNode );
	bool Update( float time );

	inline void SpeedUp( float val ) { mSpeed += val; }

protected:
	void Crash( NiPoint3 dir = -NiPoint3::UNIT_Y );

	void BulletRotate( NiPoint3 startAt, NiPoint3 endAt );

protected:

	struct sCrashInfo
	{
		unsigned short	crashEffectIdx;
		unsigned int	crashLinkPos;
		NiPoint3		crashVar;
	};

	/// ߻ü
	cEffectSceneNode*	mBullet;

	float				mSpeed;
	NiPoint3			mDesiredDir;

	float				mAccumTime;

	/// 浹 ó  
//	sObject				mTarget;
	unsigned int		mTargetLinkPos;
	NiPoint3			mLastTargetPos;

	/// 浹 ȿ 
	bool				mExistCrashEffect;

	unsigned int		mCrashCount;
	sCrashInfo			mCrashInfo[5];

	///  
	cDramaturgyInfo*	mpDramaInfo;
};