#include "StdAfx.h"
#include "CallbackStreamPak.h"

#include "ModelInstance.h"
#include "ResourceManager.h"

NiCriticalSection cCallbackStreamPACK::mQueueCriticalSection;

cCallbackStreamPACK::cCallbackStreamPACK()
{
	// ׽Ʈ ؼ ũ⸦ Ѵ.
	mpFileQueue = NiNew NiTPrimitiveQueue<char*>(100);
}

cCallbackStreamPACK::~cCallbackStreamPACK()
{
	ClearQueue();

	SAFE_NIDELETE( mpFileQueue );
}

void cCallbackStreamPACK::AddLoadFile( const char* fileName )
{
	if( ::strlen( fileName ) == 0 ) 
	{
		return;
	}

	/// ť ä.
	mQueueCriticalSection.Lock();
	{
		char* name = new char[260];
		NiStrcpy( name, 260, fileName );
		mpFileQueue->Add( name );
	}
	mQueueCriticalSection.Unlock();
}

void cCallbackStreamPACK::ClearQueue()
{
	mQueueCriticalSection.Lock();
	{
		char* name = mpFileQueue->Remove();
		while( name )
		{
			delete[]name;
			name = mpFileQueue->Remove();
		}
	}
	mQueueCriticalSection.Unlock();
}

void cCallbackStreamPACK::BackgroundLoadBeginEx()
{
	mQueueCriticalSection.Lock();
	{
		///  ܺο  ϵ Ѵٸ, Ʒ ּ Ͻÿ..
		//	if( m_eBackgroundLoadStatus != IDLE ) return;
		if( mpFileQueue->IsEmpty() )
		{
			mQueueCriticalSection.Unlock();
			return;
		}

		/// Set m_uiLoad to UINT_MAX so we can determine in BackgroundLoadPoll
		/// whether the background thread has run far enough to set the variables
		/// we use to compute progress.
		m_uiLoad = UINT_MAX;

		/// Ӻ긮  ó̴.
		if( m_pkBGLoadProc == NULL )
			m_pkBGLoadProc = NiNew cBackgroundLoadProcedureEx( this );

		/// StreamPackѰ ..ε  Ѱ Ѵ..
		assert( m_pkThread == NULL );
		if( m_pkThread ) 
		{
			mQueueCriticalSection.Unlock();
			return;
		}

		/// ε  ..
		m_pkThread = NiThread::Create( m_pkBGLoadProc );
		assert(m_pkThread);
		if( !m_pkThread )
		{
			mQueueCriticalSection.Unlock();
			return;
		}

		///  ɼ 
		m_pkThread->SetPriority(NiThread::BELOW_NORMAL);
		m_pkThread->Resume();

		m_eBackgroundLoadStatus = LOADING;
	}
	mQueueCriticalSection.Unlock();
}

/// !! ̺κ ΰ ٸ ̹Ƿ ڵ ſ 
void cCallbackStreamPACK::BackgroundLoadEx()
{
	bool isEmpty = false;
	char* fileName = NULL;
	NiNode* n = NULL;

	while( !isEmpty )
	{
		/// ť ϳ .
		mQueueCriticalSection.Lock();
		{
			fileName = mpFileQueue->Remove(); 
			if( mpFileQueue->IsEmpty() ) 
			{
				isEmpty = true;
			}
		}
		mQueueCriticalSection.Unlock();

		if( !fileName || strlen(fileName) < 5) 
		{
			/// εϷ ϸ NULL ..
			continue;
		}

		if( RESOURCEMAN->GetObjectByName(fileName) )
		{
			/// ̹ εǾ ִٸ..
			continue;
		}

#ifdef _PAK_LOAD


#else
		//if( NiStream::Load( cResourceManager::ConvertMediaFilename(fileName) ) )
		if( NiStream::Load( fileName ) )
		{
			n = NiDynamicCast( NiNode, NiStream::GetObjectAt(0) );

			/// TODO : ʼ  !!
			RESOURCEMAN->AddObject( n, fileName );

			BackgroundLoadOnExit();
		}
#endif
		/// ִ ޸ .
		SAFE_DELETE_ARRAY( fileName );
	}

	m_kSemaphore.Signal();
}

void cCallbackStreamPACK::BackgroundLoadOnExit()
{
	/// о Ϳ  ξ ó 
	/// ξ忡 CPU ҴѴ.
	NiSleep( 1 );

}

unsigned int cCallbackStreamPACK::cBackgroundLoadProcedureEx::ThreadProcedure( void* /*pArg*/ )
{
	( (cCallbackStreamPACK*)m_pkStream )->BackgroundLoadEx();

	return 0;
}

/// !! ̺κ Main Thread󿡼 ó
///  ε óΰ ƴϴ.
void cCallbackStreamPACK::Process()
{
	if( m_eBackgroundLoadStatus == IDLE )
	{
		/// ε 尡 ޽Ļ¸  Ϳ
		///  üũѴ.
		BackgroundLoadBeginEx();
	}
	else
	{
		/// ε ̸
		/// ε 忡 CPUҴ..
		Sleep( 1 );

		/// ° 
		LoadState loadState;
		BackgroundLoadPoll(&loadState);
	}
}