/* ==========================================================================
*    : ̼
*    : 2006.12.07
*      : ī޶ 
* ǻ : 
*===========================================================================*/
#pragma once

#include "Camera.h"

class cFreeCamera;
class cLookAtCamera;

/// ī޶ 
/// ī޶ , ϴ ̴.
class cCameraManager
{
	static cCameraManager* mSingleton;

public:
	cCameraManager();
	~cCameraManager();

	/// ó
	void Process( float deltaTime );

	/// 
	void DestroyAll();
	void Destroy( cCamera* cam );

	/// 
	cFreeCamera* CreateFree( bool makeCurrent = false );
	cLookAtCamera* CreateLookAt( bool makeCurrent = false );

	void SetCurrent( cCamera* cam );
	cCamera* GetCurrent();
	cCamera* GetCamera( unsigned int i );

	/// ȭ ǥ ϴ  
	void GetRayFromWindowPoint( NiPoint3* porigin, NiPoint3* pdir, int mouseX, int mouseY );

	/// ӷ
	void SetCameraTranslateSpeed( float unitsPerSec );
	void SetCameraRotateSpeed( float anglesPerSec );

public:
	/// ü 
	static cCameraManager* GetSingleton();

protected:
	/// ī޶ 迭
	typedef tArray<cCamera*> cCameraArray;
	cCameraArray mCameraArray;

	///  ī޶
	cCamera* mCurrentCamera;
};

inline
void cCameraManager::GetRayFromWindowPoint( NiPoint3* porigin, NiPoint3* pdir, int mouseX, int mouseY )
{
	if( mCurrentCamera )
	{
		mCurrentCamera->GetRayFromWindowPoint( mouseX, mouseY, *porigin, *pdir );
	}
	else
	{
		assert( 0 && "null current camera" );
	}
}

inline
cCamera* cCameraManager::GetCurrent()
{
	return mCurrentCamera;
}

inline
cCamera* cCameraManager::GetCamera( unsigned int i )
{
	if( i < mCameraArray.GetSize() )
		return mCameraArray[i];
	else
		return 0;
}

inline
cCameraManager* cCameraManager::GetSingleton()
{
	return mSingleton;
}

#define CAMERAMAN cCameraManager::GetSingleton()
