#pragma once

class cDevSystem
{
	static cDevSystem* mSingleton;

public:
	cDevSystem(NiRenderer* renderer);
	~cDevSystem();

	bool Init();
	void Process( float time );
	void Render();

public:
	/// ü 
	static cDevSystem* GetSingleton();

private:
	void UpdateDevInfo();

private:
	NiFontPtr mFont;
	NiRendererPtr mRenderer;	
	NiOldString2DPtr mInfoString0;
	NiOldString2DPtr mInfoString1;

	/// FPS
	double mLastTime;
	long double mFrames;
	float mFPS;
};

inline cDevSystem* cDevSystem::GetSingleton()
{
	return mSingleton;
}

#define DEVSYS cDevSystem::GetSingleton()
