/* =====================================================================
*      :	DramaturgyManager.h , DramaturgyManager.cpp
*      :	 ,  Ľ
*    :	
*    :    2006 10 16
*
* ߰ :
*		߰¥    ۾	  ߰
* 
* ǻ :	.
* =======================================================================*/
#pragma once

#include "DramaturgyInfo.h"

enum eMONSTERATTACK_TYPE;

enum eAPPLYDRAMA_TYPE
{
	eAPPLYDRAMA_DAMAGE = 0,
	eAPPLYDRAMA_CRITICAL,
	eAPPLYDRAMA_DIE1,
	eAPPLYDRAMA_DIE2,

	eAPPLYDRAMA_MAX,
};

/// ⺻	- ** (3 * 2 * 7 = 42)
/// ų		- * (3 * 2 = 6)
class cDramaturgyManager
{
public:
	static cDramaturgyManager*		mpDramaturgyManager;

	cDramaturgyManager();
	~cDramaturgyManager();

	bool				Init();

	/// ⿡ Ե 3D ̸ εϴµ Ѵ.
	void				DirectLoadPlayerDramaObj( unsigned long skillIdx );
	void				DirectLoadMonsterDramaObj( unsigned long monsterIdx );
	void				DirectLoadPlayerApplyDramaObj( unsigned char race, unsigned char gender );
	void				DirectLoadMonsterApplyDramaObj( unsigned long monsterIdx );
	void				DirectLoadInfluenceDramaObj( unsigned long influenceIdx );

	///  ȹ (ⰴü Thread Loading)
	cDramaturgyInfo*	GetPlayerDramaturgyInfo( unsigned long skillIdx, unsigned short weaponstate, unsigned char race, unsigned char gender );
	cDramaturgyInfo*	GetPlayerDramaturgyInfo( unsigned long skillIdx, unsigned short dramaKey );
	cDramaturgyInfo*	GetMonsterDramaturgyInfo( unsigned long monsterIdx, eMONSTERATTACK_TYPE type );

	cDramaturgyInfo*	GetPlayerApplyDramaInfo( unsigned char race, unsigned char gender, eAPPLYDRAMA_TYPE type );
	cDramaturgyInfo*	GetMonsterApplyDramaInfo( unsigned long monsterIdx, eAPPLYDRAMA_TYPE type );

	///  
	cDramaturgyInfo*	GetInfluenceDramaturgyInfo( unsigned long influenceIdx );

	void ReLoadDramaturgyFileList();

	/// ȿ  ܺȣ
	bool LoadInfluenceDrama( unsigned long influenceIdx, const cString& fileName, bool loadObject = false );

protected:
	/// "PlayerDramaFileList.txt" load
	bool LoadPlayerDramaturgyFileList();

	/// "MonsterDramaFileList.txt"
	bool LoadMonsterDramaturgyFileList();

	/// "ApplyDramaList.txt" load
	bool LoadApplyDramaturgyFileList();

protected:
	/// 
	typedef tPointerHashMap<unsigned long, void*>	cSkillDramaMap;
	/// key = ((race*gender_max)+gender)*weaponstate_max + weaponstate;
	typedef tPointerHashMap<unsigned long, void*> cDramaturgyInfoMap;

	///  ޸
	/// key = skillIdx, value = cDramatugyInfoMap pointer;
	cSkillDramaMap	mPlayerDramaturgyInfoMap;

	/// key = skillIdx, value = cDramatugyInfo pointer;
	cSkillDramaMap	mMonsterDramaturgyInfoMap;

	/// ȿ  
	cSkillDramaMap	mInfluenceDramaturgyInfoMap;

	/// key = monster Index ( - 1001̻ ĳ ǥ)
	cSkillDramaMap	mApplyDramaMap;
};

#define DRAMATURGYMAN cDramaturgyManager::mpDramaturgyManager